/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.mof2binding;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ConstantFormFieldBinding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ProgramParameterBinding;
import org.eclipse.edt.compiler.binding.StructureItemBinding;
import org.eclipse.edt.compiler.binding.SystemFunctionParameterSpecialTypeBinding;
import org.eclipse.edt.compiler.binding.VariableFormFieldBinding;
import org.eclipse.edt.compiler.binding.annotationType.EGLSystemParameterTypesAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.mof2binding.EClassBinding;
import org.eclipse.edt.compiler.internal.mof2binding.EFieldBinding;
import org.eclipse.edt.compiler.internal.mof2binding.EFunctionBinding;
import org.eclipse.edt.compiler.internal.mof2binding.EParameterBinding;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2BindingPart;
import org.eclipse.edt.mof.EClass;
import org.eclipse.edt.mof.EDataType;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EFunction;
import org.eclipse.edt.mof.EGenericType;
import org.eclipse.edt.mof.EModelElement;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EParameter;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.ETypedElement;
import org.eclipse.edt.mof.EVisitor;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.AccessKind;
import org.eclipse.edt.mof.egl.ConstantFormField;
import org.eclipse.edt.mof.egl.Constructor;
import org.eclipse.edt.mof.egl.Delegate;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.FormField;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.FunctionParameter;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.ParameterKind;
import org.eclipse.edt.mof.egl.ProgramParameter;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.StructuredField;
import org.eclipse.edt.mof.egl.TypedElement;
import org.eclipse.edt.mof.egl.VariableFormField;
import org.eclipse.edt.mof.egl.lookup.ProxyPart;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public abstract class Mof2BindingMember
extends Mof2BindingPart {
    public Mof2BindingMember(IBindingEnvironment env) {
        super(env);
    }

    public boolean visit(Field field) {
        IBinding binding = this.getBinding((EObject)field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType((TypedElement)field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            if (field.getContainer() instanceof Record) {
                binding = new FlexibleRecordFieldBinding(name, declarer, type);
            } else {
                binding = new ClassFieldBinding(name, declarer, type);
                ((ClassFieldBinding)binding).setIsStatic(field.isStatic());
                ((ClassFieldBinding)binding).setIsPrivate(field.getAccessKind() == AccessKind.ACC_PRIVATE);
            }
            this.handleAnnotations((Element)field, binding);
            this.putBinding((EObject)field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(StructuredField field) {
        StructureItemBinding binding = (StructureItemBinding)this.getBinding((EObject)field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType((TypedElement)field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new StructureItemBinding(name, declarer, type);
            binding.setOccurs(field.getOccurs());
            this.handleAnnotations((Element)field, binding);
            this.putBinding((EObject)field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(VariableFormField field) {
        VariableFormFieldBinding binding = (VariableFormFieldBinding)this.getBinding((EObject)field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            ITypeBinding type = this.bindingForType((TypedElement)field);
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new VariableFormFieldBinding(name, declarer, type);
            binding.setOccurs(field.getOccurs());
            this.handleAnnotations((Element)field, binding);
            this.handleElementAnnotations((FormField)field, binding);
            this.putBinding((EObject)field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(ConstantFormField field) {
        ConstantFormFieldBinding binding = (ConstantFormFieldBinding)this.getBinding((EObject)field);
        if (binding == null) {
            InternUtil.intern((String)field.getName());
            field.getContainer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            binding = new ConstantFormFieldBinding(declarer);
            binding.setOccurs(field.getOccurs());
            this.handleAnnotations((Element)field, binding);
            this.handleElementAnnotations((FormField)field, binding);
            this.putBinding((EObject)field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(Constructor constructor) {
        IBinding binding = this.getBinding((EObject)constructor);
        if (binding == null) {
            IPartBinding type = (IPartBinding)this.getBinding((EObject)constructor.getContainer());
            if (type == null) {
                constructor.getContainer().accept((EVisitor)this);
                type = (IPartBinding)this.stack.pop();
            }
            binding = new ConstructorBinding(type);
            ((ConstructorBinding)binding).setPrivate(constructor.getAccessKind() == AccessKind.ACC_PRIVATE);
            this.putBinding((EObject)constructor, ((ConstructorBinding)binding).getType());
            for (FunctionParameter parm : constructor.getParameters()) {
                parm.accept((EVisitor)this);
                ((ConstructorBinding)binding).addParameter((FunctionParameterBinding)this.stack.pop());
            }
            this.handleAnnotations((Element)constructor, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(Function function) {
        IBinding binding = this.getBinding((EObject)function);
        if (binding == null) {
            String name = InternUtil.intern((String)function.getName());
            IPartBinding type = (IPartBinding)this.getBinding((EObject)function.getContainer());
            if (type == null) {
                function.getContainer().accept((EVisitor)this);
                type = (IPartBinding)this.stack.pop();
            }
            binding = new FunctionBinding(name, type);
            this.putBinding((EObject)function, binding);
            for (FunctionParameter parm : function.getParameters()) {
                parm.accept((EVisitor)this);
                ((FunctionBinding)binding).addParameter((FunctionParameterBinding)this.stack.pop());
            }
            if (function.getType() != null) {
                ((FunctionBinding)binding).setReturnType(this.bindingForType((TypedElement)function));
            }
            ((FunctionBinding)binding).setStatic(function.isStatic());
            ((FunctionBinding)binding).setPrivate(function.getAccessKind() == AccessKind.ACC_PRIVATE);
            this.handleAnnotations((Element)function, binding);
            this.overrideFunctionParameterTypes((FunctionBinding)binding);
            binding = new NestedFunctionBinding(name, type, (FunctionBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    private void overrideFunctionParameterTypes(FunctionBinding function) {
        IAnnotationBinding ann = function.getAnnotation(EGLSystemParameterTypesAnnotationTypeBinding.getInstance());
        if (ann != null) {
            this.overrideParmTypes((Object[])ann.getValue(), function);
        }
    }

    private void overrideParmTypes(Object[] parmMap, FunctionBinding function) {
        int i = 0;
        while (i < parmMap.length) {
            SystemFunctionParameterSpecialTypeBinding newType;
            String value = parmMap[i].toString();
            if (value.length() > 0 && (newType = SystemFunctionParameterSpecialTypeBinding.getType(value)) != null) {
                ((FunctionParameterBinding)function.getParameters().get(i)).setType(newType);
            }
            ++i;
        }
    }

    public boolean visit(FunctionParameter parm) {
        IBinding binding = this.getBinding((EObject)parm);
        if (binding == null) {
            FunctionBinding func;
            IPartBinding declarer;
            String name = InternUtil.intern((String)parm.getName());
            parm.getType().accept((EVisitor)this);
            ITypeBinding type = (ITypeBinding)this.stack.pop();
            if (parm.getContainer() instanceof Delegate) {
                declarer = (IPartBinding)this.getBinding((EObject)parm.getContainer());
                func = null;
            } else {
                declarer = (IPartBinding)this.getBinding((EObject)((Member)parm.getContainer()).getContainer());
                func = (FunctionBinding)this.getBinding((EObject)parm.getContainer());
            }
            binding = new FunctionParameterBinding(name, declarer, type, func);
            if (parm.getParameterKind() == ParameterKind.PARM_IN) {
                ((FunctionParameterBinding)binding).setInput(true);
            } else if (parm.getParameterKind() == ParameterKind.PARM_OUT) {
                ((FunctionParameterBinding)binding).setOutput(true);
            }
            this.putBinding((EObject)parm, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(ProgramParameter parm) {
        IBinding binding = this.getBinding((EObject)parm);
        if (binding == null) {
            String name = InternUtil.intern((String)parm.getName());
            parm.getType().accept((EVisitor)this);
            ITypeBinding type = (ITypeBinding)this.stack.pop();
            IPartBinding declarer = (IPartBinding)this.getBinding((EObject)parm.getContainer());
            binding = new ProgramParameterBinding(name, declarer, type);
            this.putBinding((EObject)parm, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EField field) {
        IBinding binding = this.getBinding((EObject)field);
        if (binding == null) {
            String name = InternUtil.intern((String)field.getName());
            field.getDeclarer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            ITypeBinding type = this.bindingForType((ETypedElement)field, declarer);
            if (declarer instanceof FlexibleRecordBinding) {
                binding = new FlexibleRecordFieldBinding(name, declarer, type);
            } else if (declarer instanceof EClassBinding) {
                binding = new EFieldBinding(name, declarer, type);
                ((EFieldBinding)binding).setTransient(field.isTransient());
                ((EFieldBinding)binding).setContainment(field.getContainment());
            } else {
                binding = new ClassFieldBinding(name, declarer, type);
            }
            this.handleMetadata((EModelElement)field, binding);
            this.putBinding((EObject)field, binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EFunction function) {
        IBinding binding = this.getBinding((EObject)function);
        if (binding == null) {
            String name = InternUtil.intern((String)function.getName());
            ITypeBinding type = null;
            function.getDeclarer().accept((EVisitor)this);
            IPartBinding declarer = (IPartBinding)this.stack.pop();
            if (function.getEType() != null) {
                type = this.bindingForType((ETypedElement)function, declarer);
            }
            binding = new EFunctionBinding(name, declarer);
            this.putBinding((EObject)function, binding);
            for (EParameter parm : function.getEParameters()) {
                parm.accept((EVisitor)this);
                ((FunctionBinding)binding).addParameter((EParameterBinding)this.stack.pop());
            }
            if (type != null) {
                ((FunctionBinding)binding).setReturnType(type);
            }
            binding = new NestedFunctionBinding(name, declarer, (FunctionBinding)binding);
        }
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EParameter parm) {
        IBinding binding = this.getBinding((EObject)parm);
        String name = InternUtil.intern((String)parm.getName());
        ITypeBinding type = null;
        if (parm.getEType() != null) {
            parm.getEType().accept((EVisitor)this);
            type = (ITypeBinding)this.stack.pop();
        }
        IPartBinding declarer = (IPartBinding)this.getBinding((EObject)parm.getFunction().getDeclarer());
        FunctionBinding func = (FunctionBinding)this.getBinding((EObject)parm.getFunction());
        binding = new EParameterBinding(name, declarer, type, func);
        this.putBinding((EObject)parm, binding);
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EDataType type) {
        String key = type.getMofSerializationKey();
        PrimitiveTypeBinding binding = key.equals(MofFactory.INSTANCE.getEStringEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance(Primitive.STRING) : (key.equals(MofFactory.INSTANCE.getEIntEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance(Primitive.INT) : (key.equals(MofFactory.INSTANCE.getEBooleanEDataType().getMofSerializationKey()) ? PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN) : PrimitiveTypeBinding.getInstance(Primitive.ANY)));
        this.stack.push(binding);
        return false;
    }

    public boolean visit(EGenericType type) {
        ((EType)type.getETypeArguments().get(0)).accept((EVisitor)this);
        ITypeBinding elementType = (ITypeBinding)this.stack.pop();
        ArrayTypeBinding binding = ArrayTypeBinding.getInstance(elementType);
        this.stack.push(binding);
        return false;
    }

    private ITypeBinding bindingForType(TypedElement element) {
        ITypeBinding binding;
        if (element instanceof ProxyPart) {
            binding = this.createProxyBinding((ProxyPart)element);
        } else {
            element.getType().accept((EVisitor)this);
            binding = (ITypeBinding)this.stack.pop();
        }
        if (element.isNullable()) {
            binding = binding.getNullableInstance();
        }
        return binding;
    }

    private ITypeBinding bindingForType(ETypedElement element, ITypeBinding declarer) {
        ITypeBinding binding = null;
        if (declarer instanceof FlexibleRecordBinding && this.isEGLReflectType((EType)element.getEType().getEClassifier())) {
            binding = this.getEGLReflectTypeFor((EClass)element.getEType().getEClassifier());
        } else {
            element.getEType().accept((EVisitor)this);
            binding = (ITypeBinding)this.stack.pop();
        }
        if (element.isNullable()) {
            binding = binding.getNullableInstance();
        }
        return binding;
    }

    private boolean isEGLReflectType(EType type) {
        if (type.getEClassifier() instanceof EClass) {
            EClass eClass = (EClass)type.getEClassifier();
            String typeSignature = eClass.getETypeSignature();
            return typeSignature.equals("org.eclipse.edt.mof.EField") || typeSignature.equals("org.eclipse.edt.mof.EClass") || typeSignature.equals("org.eclipse.edt.mof.EClassifier") || typeSignature.equals("org.eclipse.edt.mof.EFunction");
        }
        return false;
    }

    private ITypeBinding getEGLReflectTypeFor(EClass eClass) {
        IPartBinding binding = null;
        String typeSignature = eClass.getETypeSignature();
        if (typeSignature.equals("org.eclipse.edt.mof.EField")) {
            binding = SystemPartManager.FIELDREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EClass")) {
            binding = SystemPartManager.TYPEREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EClassifier")) {
            binding = SystemPartManager.TYPEREF_BINDING;
        } else if (typeSignature.equals("org.eclipse.edt.mof.EFunction")) {
            binding = SystemPartManager.FUNCTIONREF_BINDING;
        }
        return binding;
    }
}

