/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.utils.PartBindingCache;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class PartPathEntry {
    private File path;
    private PartBindingCache bindingCache = new PartBindingCache();
    private Map resolvedPackages = new HashMap();
    private Set unresolvedPackages = new HashSet();
    private Set resolvedParts = new HashSet();
    private Set unresolvedParts = new HashSet();
    private IEnvironment declaringEnvironment;

    public PartPathEntry(File path) {
        this.path = path;
    }

    public File getPath() {
        return this.path;
    }

    public void setDeclaringEnvironment(IEnvironment declaringEnvironment) {
        this.declaringEnvironment = declaringEnvironment;
    }

    public boolean hasPart(String[] packageName, String partName) {
        File pkg = this.getPackage(packageName);
        if (pkg != null) {
            File partFile = new File(pkg, this.getFileName(partName));
            String key = partFile.getAbsolutePath();
            if (this.resolvedParts.contains(key)) {
                return true;
            }
            if (this.unresolvedParts.contains(key)) {
                return false;
            }
            if (partFile.exists()) {
                this.resolvedParts.add(key);
                return true;
            }
            this.unresolvedParts.add(key);
            return false;
        }
        return false;
    }

    public boolean hasPackage(String[] packageName) {
        return this.getPackage(packageName) != null;
    }

    private File getPackage(String[] packageName) {
        if (packageName.length == 0) {
            return this.path;
        }
        String[] key = InternUtil.intern((String[])packageName);
        File folder = (File)this.resolvedPackages.get(key);
        if (folder != null) {
            return folder;
        }
        if (this.unresolvedPackages.contains(key)) {
            return null;
        }
        folder = this.getPackage(this.stripLast(packageName));
        if (folder == null) {
            this.unresolvedPackages.add(key);
            return null;
        }
        String last = packageName[packageName.length - 1];
        if ((folder = new File(folder, IRFileNameUtility.toIRFileName(last))).exists()) {
            this.resolvedPackages.put(key, folder);
            return folder;
        }
        this.unresolvedPackages.add(key);
        return null;
    }

    private String[] stripLast(String[] arr) {
        if (arr.length < 2) {
            return new String[0];
        }
        String[] newArr = new String[arr.length - 1];
        System.arraycopy(arr, 0, newArr, 0, newArr.length);
        return newArr;
    }

    public long lastModified(String[] packageName, String partName) {
        File partFile = this.getFile(packageName, partName);
        return partFile.lastModified();
    }

    private File getFile(String[] packageName, String partName) {
        File pkg = this.getPackage(packageName);
        File partFile = new File(pkg, String.valueOf(IRFileNameUtility.toIRFileName(partName)) + ".ir");
        return partFile;
    }

    private String getFileName(String partName) {
        return String.valueOf(IRFileNameUtility.toIRFileName(partName)) + ".ir";
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = this.bindingCache.get(packageName, partName);
        if (result != null) {
            return result;
        }
        return null;
    }
}

