/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.sdk.compile;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.utils.Util;
import org.eclipse.edt.compiler.sdk.compile.BuildPathException;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class SourcePathInfo {
    private static final SourcePathInfo INSTANCE = new SourcePathInfo();
    private ResourceInfo rootResourceInfo = new ResourceInfo();

    private SourcePathInfo() {
    }

    public static SourcePathInfo getInstance() {
        return INSTANCE;
    }

    public void reset() {
        this.rootResourceInfo = new ResourceInfo();
    }

    public void addPart(String[] packageName, String partName, int partType, File declaringFile, String caseSensitivePartName) {
        ResourceInfo root = this.rootResourceInfo;
        int i = 0;
        while (i < packageName.length) {
            root = root.addPackage(InternUtil.intern((String)packageName[i]));
            ++i;
        }
        root.addPart(partName, partType, declaringFile, caseSensitivePartName);
    }

    private void initializeEGLPackageHelper(File parent, ResourceInfo parentMap) {
        File[] resources = parent.listFiles();
        if (resources == null) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isDirectory()) {
                ResourceInfo info = parentMap.addPackage(InternUtil.intern((String)resources[i].getName()));
                this.initializeEGLPackageHelper(resources[i], info);
            } else if (Util.isEGLFileName(resources[i].getName())) {
                this.initializeEGLFileHelper(resources[i], parentMap);
            }
            ++i;
        }
    }

    private void initializeEGLFileHelper(File file, ResourceInfo parentResourceInfo) {
        org.eclipse.edt.compiler.core.ast.File parsedFile = ASTManager.getInstance().getFileAST(file);
        List parts = parsedFile.getParts();
        for (Part part : parts) {
            parentResourceInfo.addPart(part.getIdentifier(), Util.getPartType(part), file, part.getName().getCaseSensitiveIdentifier());
        }
        parentResourceInfo.addPart(Util.getFilePartName(file), Util.getPartType(parsedFile), file, Util.getCaseSensitiveFilePartName(file));
    }

    public boolean hasPackage(String[] packageName) {
        ResourceInfo info = this.rootResourceInfo;
        int i = 0;
        while (i < packageName.length) {
            if ((info = info.getPackage(packageName[i])) == null) break;
            ++i;
        }
        return info != null;
    }

    public int hasPart(String[] packageName, String partName) {
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getPartType(partName);
        }
        return 1;
    }

    private ResourceInfo getPackageInfo(String[] packageName) {
        ResourceInfo info = this.rootResourceInfo;
        int i = 0;
        while (i < packageName.length) {
            if ((info = info.getPackage(packageName[i])) == null) break;
            ++i;
        }
        return info;
    }

    public File getDeclaringFile(String[] packageName, String partName) {
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getFile(partName);
        }
        return null;
    }

    public void setSourceLocations(File[] sourceLocations) {
        int i = 0;
        while (i < sourceLocations.length) {
            if (!sourceLocations[i].exists()) {
                try {
                    throw new BuildPathException("Invalid path: " + sourceLocations[i].getCanonicalPath());
                }
                catch (IOException e) {
                    throw new BuildPathException("Invalid path: ", e);
                }
            }
            this.initializeEGLPackageHelper(sourceLocations[i], this.rootResourceInfo);
            ++i;
        }
    }

    public String getCaseSensitivePartName(String[] packageName, String partName) {
        ResourceInfo info = this.getPackageInfo(packageName);
        if (info != null) {
            return info.getCaseSensitivePartName(partName);
        }
        return null;
    }

    private class PartEntry {
        private int partType;
        private File file;
        private String caseSensitivePartName;

        public PartEntry(int partType, File file, String caseSensitivePartName) {
            this.partType = partType;
            this.file = file;
            this.caseSensitivePartName = caseSensitivePartName;
        }

        public File getFile() {
            return this.file;
        }

        public int getPartType() {
            return this.partType;
        }

        public String getCaseSensitivePartName() {
            return this.caseSensitivePartName;
        }
    }

    private class ResourceInfo {
        private HashMap packages = null;
        private HashMap parts = null;

        private ResourceInfo() {
        }

        public ResourceInfo addPackage(String packageName) {
            ResourceInfo pkgInfo;
            if (this.packages == null) {
                this.packages = new HashMap(5);
            }
            if ((pkgInfo = (ResourceInfo)this.packages.get(packageName)) == null) {
                pkgInfo = new ResourceInfo();
                this.packages.put(packageName, pkgInfo);
            }
            return pkgInfo;
        }

        public ResourceInfo getPackage(String packageName) {
            if (this.packages != null) {
                return (ResourceInfo)this.packages.get(packageName);
            }
            return null;
        }

        public void addPart(String partName, int partType, File file, String caseSensitivePartName) {
            if (this.parts == null) {
                this.parts = new HashMap();
            }
            if (!this.parts.containsKey(partName)) {
                this.parts.put(partName, new PartEntry(partType, file, caseSensitivePartName));
            }
        }

        public File getFile(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getFile();
            }
            return null;
        }

        public int getPartType(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getPartType();
            }
            return 1;
        }

        public String getCaseSensitivePartName(String partName) {
            PartEntry part = this.getPart(partName);
            if (part != null) {
                return part.getCaseSensitivePartName();
            }
            return null;
        }

        private PartEntry getPart(String partName) {
            if (this.parts != null) {
                return (PartEntry)this.parts.get(partName);
            }
            return null;
        }

        public String toString() {
            Set set;
            StringBuffer result = new StringBuffer();
            result.append("Packages: \n");
            if (this.packages == null) {
                result.append("\tNone");
            } else {
                set = this.packages.keySet();
                for (String pkgName : set) {
                    result.append("\t" + pkgName + "\n");
                }
            }
            result.append("\n");
            result.append("Parts: \n");
            if (this.parts == null) {
                result.append("\tNone");
            } else {
                set = this.parts.keySet();
                for (String partName : set) {
                    result.append("\t" + partName + "\n");
                }
            }
            result.append("\n");
            return result.toString();
        }

        public boolean containsPart(String identifier) {
            return this.parts != null && this.parts.containsKey(identifier);
        }
    }
}

