/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.gen.AbstractGeneratorCommand;
import org.eclipse.edt.gen.EGLMessages.EGLMessage;
import org.eclipse.edt.gen.EglContext;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.Element;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.Function;
import org.eclipse.edt.mof.egl.Statement;
import org.eclipse.edt.mof.egl.Type;

public class Context
extends EglContext {
    private static final long serialVersionUID = 6429116299734843162L;
    private boolean smapIsProcessing;
    private boolean smapHasOutstandingLine;
    private int firstEglLineNumber;
    private int lastEglLineNumber;
    private int firstJavaLineNumber;
    private int lastJavaLineNumber;
    private Function currentFunction;
    private String currentFile;
    private StringBuffer smapData = new StringBuffer();
    private StringBuffer smapExtension = new StringBuffer();
    private List<String> smapFiles = new ArrayList<String>();

    public Context(AbstractGeneratorCommand processor) {
        super(processor);
        this.smapData.append("SMAP\n");
        this.smapExtension.append("");
    }

    public Function getCurrentFunction() {
        return this.currentFunction;
    }

    public void setCurrentFunction(Function currentFunction) {
        this.currentFunction = currentFunction;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
    }

    public StringBuffer getSmapData() {
        return this.smapData;
    }

    public StringBuffer getSmapExtension() {
        return this.smapExtension;
    }

    public List<String> getSmapFiles() {
        return this.smapFiles;
    }

    public boolean isSmapIsProcessing() {
        return this.smapIsProcessing;
    }

    public void setSmapIsProcessing(boolean smapIsProcessing) {
        this.smapIsProcessing = smapIsProcessing;
    }

    public String getRawPrimitiveMapping(String item) {
        return super.getPrimitiveMapping(item);
    }

    public String getPrimitiveMapping(String item) {
        String value = super.getPrimitiveMapping(item);
        if (value != null) {
            List typesImported = (List)this.getAttribute(((Object)((Object)this)).getClass(), "partTypesImported");
            for (String imported : typesImported) {
                if (!value.equalsIgnoreCase(imported)) continue;
                if (value.indexOf(46) < 0) break;
                value = value.substring(value.lastIndexOf(46) + 1);
                break;
            }
        }
        return value;
    }

    public String getRawPrimitiveMapping(Type type) {
        return super.getPrimitiveMapping(type);
    }

    public String getPrimitiveMapping(Type type) {
        String value = super.getPrimitiveMapping(type);
        if (value != null) {
            List typesImported = (List)this.getAttribute(((Object)((Object)this)).getClass(), "partTypesImported");
            for (String imported : typesImported) {
                if (!value.equalsIgnoreCase(imported)) continue;
                if (value.indexOf(46) < 0) break;
                value = value.substring(value.lastIndexOf(46) + 1);
                break;
            }
        }
        return value;
    }

    public String getRawNativeImplementationMapping(Type type) {
        return super.getNativeImplementationMapping(type);
    }

    public String getNativeImplementationMapping(Type type) {
        String value = super.getNativeImplementationMapping(type);
        List typesImported = (List)this.getAttribute(((Object)((Object)this)).getClass(), "partTypesImported");
        for (String imported : typesImported) {
            if (!value.equalsIgnoreCase(imported)) continue;
            if (value.indexOf(46) < 0) break;
            value = value.substring(value.lastIndexOf(46) + 1);
            break;
        }
        return value;
    }

    public String getRawNativeInterfaceMapping(Type type) {
        return super.getNativeInterfaceMapping(type);
    }

    public String getNativeInterfaceMapping(Type type) {
        String value = super.getNativeInterfaceMapping(type);
        List typesImported = (List)this.getAttribute(((Object)((Object)this)).getClass(), "partTypesImported");
        for (String imported : typesImported) {
            if (!value.equalsIgnoreCase(imported)) continue;
            if (value.indexOf(46) < 0) break;
            value = value.substring(value.lastIndexOf(46) + 1);
            break;
        }
        return value;
    }

    public void invoke(String genMethod, Expression object, TemplateContext ctx, TabbedWriter out) {
        Annotation annotation = object.getAnnotation("EGL_Location");
        if (!this.smapIsProcessing && annotation != null && annotation.getValue("line") != null) {
            this.smapIsProcessing = true;
            int thisEglLineNumber = (Integer)annotation.getValue("line");
            if (thisEglLineNumber != this.lastEglLineNumber) {
                this.writeSmapLine();
                this.smapHasOutstandingLine = true;
                this.firstEglLineNumber = thisEglLineNumber;
                this.lastEglLineNumber = thisEglLineNumber;
                this.firstJavaLineNumber = out.getLineNumber();
            }
            super.invoke(genMethod, (EObject)object, new Object[]{ctx, out});
            if (this.lastJavaLineNumber == 0) {
                this.lastJavaLineNumber = out.getLineNumber();
            }
            this.smapIsProcessing = false;
        } else {
            if (this.smapIsProcessing && annotation != null && annotation.getValue("line") != null) {
                this.lastEglLineNumber = (Integer)annotation.getValue("line");
            }
            super.invoke(genMethod, (EObject)object, new Object[]{ctx, out});
            if (this.smapIsProcessing) {
                this.lastJavaLineNumber = out.getLineNumber();
            }
        }
    }

    public void invoke(String genMethod, Statement object, TemplateContext ctx, TabbedWriter out) {
        if (this.smapIsProcessing) {
            Annotation annotation = object.getAnnotation("EGL_Location");
            if (annotation != null && annotation.getValue("line") != null) {
                this.lastEglLineNumber = (Integer)annotation.getValue("line");
            }
            super.invoke(genMethod, (EObject)object, new Object[]{ctx, out});
            this.lastJavaLineNumber = out.getLineNumber() - 1;
            if (this.firstJavaLineNumber > this.lastJavaLineNumber) {
                this.lastJavaLineNumber = this.firstJavaLineNumber;
            }
        } else {
            super.invoke(genMethod, (EObject)object, new Object[]{ctx, out});
        }
    }

    public void genSmapEnd(Function object, TabbedWriter out) {
        Annotation annotation = object.getAnnotation("EGL_Location");
        if (annotation != null && annotation.getValue("line") != null) {
            int thisEglLineNumber = (Integer)annotation.getValue("line");
            this.writeSmapLine();
            this.smapHasOutstandingLine = true;
            this.firstEglLineNumber = thisEglLineNumber;
            this.lastEglLineNumber = thisEglLineNumber;
            this.firstJavaLineNumber = out.getLineNumber();
            this.lastJavaLineNumber = out.getLineNumber();
            this.smapIsProcessing = false;
        }
    }

    public void setSmapLastJavaLineNumber(int number) {
        this.lastJavaLineNumber = number;
    }

    public void writeSmapLine() {
        if (this.smapHasOutstandingLine) {
            this.smapData.append("" + this.firstEglLineNumber);
            if (this.currentFile != null) {
                if (this.smapFiles.indexOf(this.currentFile) < 0) {
                    this.smapFiles.add(this.currentFile);
                }
                this.smapData.append("#" + (this.smapFiles.indexOf(this.currentFile) + 1));
            } else {
                this.smapData.append("#1");
            }
            this.smapData.append(":" + this.firstJavaLineNumber);
            if (this.firstJavaLineNumber != this.lastJavaLineNumber) {
                this.smapData.append("," + (this.lastJavaLineNumber - this.firstJavaLineNumber + 1));
            }
            this.smapData.append("\n");
            this.lastJavaLineNumber = 0;
        }
        this.smapHasOutstandingLine = false;
    }

    public void handleValidationError(Element obj) {
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1001", (Object)obj, (String[])details, (Annotation)obj.getAnnotation("EGL_Location"));
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }

    public void handleValidationError(Annotation obj) {
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1002", (Object)obj, (String[])details, (Annotation)this.getLastStatementLocation());
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }

    public void handleValidationError(Type obj) {
        String[] details = new String[]{obj.getEClass().getETypeSignature()};
        EGLMessage message = EGLMessage.createEGLMessage((Map)this.getMessageMapping(), (int)1, (String)"1003", (Object)obj, (String[])details, (Annotation)this.getLastStatementLocation());
        this.getMessageRequestor().addMessage((IGenerationResultsMessage)message);
    }
}

