/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.utils;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.utils.EGLProjectFileUtility;
import org.eclipse.edt.ide.rui.internal.Activator;
import org.eclipse.edt.ide.rui.utils.IWorkingCopyGenerationOperationNotifier;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationOperation;
import org.eclipse.edt.ide.rui.utils.WorkingCopyGenerationResult;
import org.eclipse.edt.ide.ui.internal.EGLUI;

public class JavaScriptPreviewGenerator {
    protected List _eglProjectPath = null;
    protected IFile _file = null;
    protected IPath _buildDescriptorPath = null;
    protected String _buildDescriptorName = null;
    protected WorkingCopyGenerationResult _generationResult = new WorkingCopyGenerationResult();

    public JavaScriptPreviewGenerator(IFile file) {
        this._file = file;
        try {
            this.initializeEGLProjectPath();
            this.initalizeBuildDescriptor();
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error creating JavaScript Preview Generator", (Throwable)ex));
        }
    }

    protected String createEGLIRPath() {
        StringBuffer eglPath = new StringBuffer();
        for (Object obj : this._eglProjectPath) {
            if (obj instanceof String) {
                eglPath.append((String)obj);
                eglPath.append(File.pathSeparator);
                continue;
            }
            EGLProject eglProject = (EGLProject)obj;
            boolean isBinaryProject = new EGLProjectFileUtility().isBinaryProject(eglProject.getProject());
            if (!isBinaryProject) {
                String outputLocation = "EGLbin";
                try {
                    outputLocation = eglProject.getOutputLocation().lastSegment();
                }
                catch (EGLModelException eGLModelException) {}
                eglPath.append(eglProject.getResource().getLocation().append(outputLocation).toOSString());
                eglPath.append(File.pathSeparator);
            }
            eglPath.append(eglProject.getResource().getLocation().toOSString());
            eglPath.append(File.pathSeparator);
        }
        return eglPath.toString();
    }

    public WorkingCopyGenerationResult generateJavaScript(IPath outputDirectory) {
        this._generationResult.clear();
        try {
            IEGLFile modelFile = (IEGLFile)EGLCore.create((IFile)this._file);
            IEGLFile sharedWorkingCopy = (IEGLFile)modelFile.getSharedWorkingCopy(null, EGLUI.getBufferFactory(), null);
            try {
                try {
                    sharedWorkingCopy.reconcile(true, null);
                    WorkingCopyGenerationOperation genOp = new WorkingCopyGenerationOperation(this._file, this._generationResult, this._generationResult, this._buildDescriptorPath, this._buildDescriptorName, outputDirectory, this.createEGLIRPath(), new IWorkingCopyGenerationOperationNotifier(){

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }
                    });
                    genOp.generate();
                }
                catch (Exception exception) {
                    this._generationResult.setHasError(true);
                    sharedWorkingCopy.destroy();
                }
            }
            finally {
                sharedWorkingCopy.destroy();
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui", "Error generating JavaScript", (Throwable)e));
        }
        return this._generationResult;
    }

    private void initalizeBuildDescriptor() {
    }

    protected void initializeEGLProjectPath() throws EGLModelException {
        IProject project = this._file.getProject();
        this._eglProjectPath = Util.getEGLProjectPath((IProject)project, (boolean)true, (boolean)true);
    }
}

