/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.iterators.ArrayIterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProjectWizardPage
extends WizardPage {
    private IJavaProject javaProject;
    private String destinationLabel;
    private Table projectTable;
    private TableViewer projectTableViewer;
    private static String SELECT_PROJECT_PAGE_NAME = "SelectJavaProject";
    private static int PROJECT_NAME_COLUMN_INDEX = 0;

    public JavaProjectWizardPage(IJavaProject javaProject) {
        super(SELECT_PROJECT_PAGE_NAME);
        this.javaProject = javaProject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.buildLabel(composite, this.destinationLabel);
        this.projectTable = this.buildProjectTable(composite, this.buildProjectTableSelectionListener());
        this.projectTableViewer = this.buildProjectTableViewer(this.projectTable, this.buildProjectTableLabelProvider(), this.buildProjectTableContentProvider());
        this.fillProjectList();
        this.setControl((Control)composite);
        this.setTableSelection(this.javaProject);
        this.validate();
    }

    private SelectionListener buildProjectTableSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaProjectWizardPage.this.selectedProjectChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public String toString() {
                return "PromptProjectWizardPage project table selection listener";
            }
        };
    }

    protected void selectedProjectChanged() {
        TableItem item;
        String projectName;
        if (this.projectTable.getSelectionIndex() != -1 && !StringTools.stringIsEmpty((String)(projectName = (item = this.projectTable.getItem(this.projectTable.getSelectionIndex())).getText(0)))) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.setJavaProject(JavaCore.create((IProject)project));
            this.validate();
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setDestinationLabel(String destinationLabel) {
        this.destinationLabel = destinationLabel;
    }

    protected void setTableSelection(IJavaProject javaProject) {
        if (javaProject != null) {
            String projectName = javaProject.getProject().getName();
            TableItem[] tableItemArray = this.projectTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getText(0).equals(projectName)) {
                    this.projectTable.setSelection(item);
                }
                ++n2;
            }
        }
    }

    protected void fillProjectList() {
        this.projectTableViewer.setInput((Object)this.getSortedJavaProjectsNames());
    }

    private void validate() {
        this.setPageComplete(this.projectTable.getSelectionIndex() != -1);
    }

    private void setJavaProject(IJavaProject project) {
        this.javaProject = project;
    }

    private String[] getSortedJavaProjectsNames() {
        return (String[])ArrayTools.sort((Object[])this.getJavaProjectsNames());
    }

    private String[] getJavaProjectsNames() {
        return (String[])ArrayTools.array((Iterable)new TransformationIterable<IProject, String>(this.getJavaProjects()){

            protected String transform(IProject project) {
                return project.getName();
            }
        }, (Object[])new String[0]);
    }

    protected Iterable<IProject> getJavaProjects() {
        return new FilteringIterable<IProject>((Iterable)CollectionTools.collection(this.getProjects())){

            protected boolean accept(IProject next) {
                try {
                    return next.hasNature("org.eclipse.jdt.core.javanature");
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
        };
    }

    protected Iterator<IProject> getProjects() {
        return new ArrayIterator((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
    }

    private ITableLabelProvider buildProjectTableLabelProvider() {
        return new ProjectTableLabelProvider();
    }

    private IStructuredContentProvider buildProjectTableContentProvider() {
        return new ProjectTableContentProvider();
    }

    private Label buildLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        return label;
    }

    private Table buildProjectTable(Composite parent, SelectionListener listener) {
        TableViewer tableViewer = new TableViewer(parent, 268438020);
        Table table = tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.addSelectionListener(listener);
        return table;
    }

    private TableViewer buildProjectTableViewer(Table parent, ITableLabelProvider labelProvider, IStructuredContentProvider contentProvider) {
        TableViewer tableViewer = new TableViewer(parent);
        tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        tableViewer.setContentProvider((IContentProvider)contentProvider);
        return tableViewer;
    }

    private final class ProjectTableContentProvider
    implements IStructuredContentProvider {
        private ProjectTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (String[])inputElement;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ProjectTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ProjectTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            assert (element instanceof String);
            String projectName = (String)element;
            if (columnIndex == PROJECT_NAME_COLUMN_INDEX) {
                return projectName;
            }
            return null;
        }
    }
}

