/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.eglarpackager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class CheckboxTreeAndListGroup
implements ICheckStateListener,
ITreeViewerListener {
    private Object fRoot;
    private Object fCurrentTreeSelection;
    private List fExpandedTreeNodes = new ArrayList();
    private Map fCheckedStateStore = new HashMap(9);
    private List fWhiteCheckedTreeItems = new ArrayList();
    private List fListeners = new ArrayList();
    private ITreeContentProvider fTreeContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private ILabelProvider fListLabelProvider;
    private CheckboxTreeViewer fTreeViewer;

    public CheckboxTreeAndListGroup(Composite parent, Object rootObject, ITreeContentProvider treeContentProvider, ILabelProvider treeLabelProvider, ILabelProvider listLabelProvider, int style, int width, int height) {
        this.fRoot = rootObject;
        this.fTreeContentProvider = treeContentProvider;
        this.fTreeLabelProvider = treeLabelProvider;
        this.fListLabelProvider = listLabelProvider;
        this.createContents(parent, width, height, style);
    }

    private void addToHierarchyToCheckedStore(Object treeElement) {
        Object parent;
        if (!this.fCheckedStateStore.containsKey(treeElement)) {
            this.fCheckedStateStore.put(treeElement, new ArrayList());
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.addToHierarchyToCheckedStore(parent);
        }
    }

    protected boolean areAllChildrenWhiteChecked(Object treeElement) {
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (!this.fWhiteCheckedTreeItems.contains(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void checkNewTreeElements(Object[] elements) {
        int i = 0;
        while (i < elements.length) {
            Object currentElement = elements[i];
            boolean checked = this.fCheckedStateStore.containsKey(currentElement);
            this.fTreeViewer.setChecked(currentElement, checked);
            this.fTreeViewer.setGrayed(currentElement, checked && !this.fWhiteCheckedTreeItems.contains(currentElement));
            ++i;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.notifyCheckStateChangeListeners(event);
            }
        });
    }

    protected void createContents(Composite parent, int width, int height, int style) {
        Composite composite = new Composite(parent, style);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createTreeViewer(composite, width / 2, height);
        this.initialize();
    }

    protected void createTreeViewer(Composite parent, int width, int height) {
        Tree tree = new Tree(parent, 2080);
        GridData data = new GridData(1808);
        data.heightHint = height;
        tree.setLayoutData((Object)data);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object treeElement) {
        List checked = (List)this.fCheckedStateStore.get(treeElement);
        if (checked != null && !checked.isEmpty()) {
            return true;
        }
        Object[] children = this.getTreeChildren(treeElement);
        int i = 0;
        while (i < children.length) {
            if (this.fCheckedStateStore.containsKey(children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object treeElement) {
        return this.areAllChildrenWhiteChecked(treeElement);
    }

    public void expandAll() {
        this.fTreeViewer.expandAll();
    }

    public Iterator getAllCheckedListItems() {
        ArrayList<Object> ret = new ArrayList<Object>();
        Object[] obj = this.fTreeViewer.getCheckedElements();
        if (obj instanceof Object[]) {
            Object[] selects;
            Object[] objectArray = selects = obj;
            int n = selects.length;
            int n2 = 0;
            while (n2 < n) {
                Object temp = objectArray[n2];
                ret.add(temp);
                ++n2;
            }
        }
        return ret.iterator();
    }

    public Set getAllCheckedTreeItems() {
        return new HashSet(this.fCheckedStateStore.keySet());
    }

    public int getCheckedElementCount() {
        return this.fCheckedStateStore.size();
    }

    public Tree getTree() {
        return this.fTreeViewer.getTree();
    }

    public void addTreeFilter(ViewerFilter filter) {
        this.fTreeViewer.addFilter(filter);
    }

    protected void grayCheckHierarchy(Object treeElement) {
        Object parent;
        if (this.fCheckedStateStore.containsKey(treeElement)) {
            return;
        }
        this.fCheckedStateStore.put(treeElement, new ArrayList());
        if (this.determineShouldBeWhiteChecked(treeElement)) {
            this.setWhiteChecked(treeElement, true);
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.grayCheckHierarchy(parent);
        }
    }

    public void initialCheckListItem(Object element) {
        Object parent;
        this.fCurrentTreeSelection = parent = this.fTreeContentProvider.getParent(element);
        this.listItemChecked(element, true, false);
        this.updateHierarchy(parent);
    }

    public void initialCheckTreeItem(Object element) {
        this.treeItemChecked(element, true);
    }

    protected void initialize() {
        this.fTreeViewer.setInput(this.fRoot);
    }

    protected void listItemChecked(Object listElement, boolean state, boolean updatingFromSelection) {
        List checkedListItems = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
        if (state) {
            if (checkedListItems == null) {
                this.grayCheckHierarchy(this.fCurrentTreeSelection);
                checkedListItems = (List)this.fCheckedStateStore.get(this.fCurrentTreeSelection);
            }
            checkedListItems.add(listElement);
        } else {
            checkedListItems.remove(listElement);
            if (checkedListItems.isEmpty()) {
                this.ungrayCheckHierarchy(this.fCurrentTreeSelection);
            }
        }
        if (updatingFromSelection) {
            this.updateHierarchy(this.fCurrentTreeSelection);
        }
    }

    protected void notifyCheckStateChangeListeners(CheckStateChangedEvent event) {
        Iterator listenersEnum = this.fListeners.iterator();
        while (listenersEnum.hasNext()) {
            ((ICheckStateListener)listenersEnum.next()).checkStateChanged(event);
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.fListeners.remove(listener);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.fListeners.add(listener);
    }

    public void setAllSelections(final boolean selection) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.setTreeChecked(CheckboxTreeAndListGroup.this.fRoot, selection);
            }
        });
    }

    public void setListProviders(IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
    }

    public void setRoot(Object newRoot) {
        this.fRoot = newRoot;
        this.initialize();
    }

    protected void setTreeChecked(Object treeElement, boolean state) {
        this.fTreeViewer.setAllChecked(state);
    }

    public void setTreeProviders(ITreeContentProvider contentProvider, ILabelProvider labelProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setTreeComparator(ViewerComparator sorter) {
        this.fTreeViewer.setComparator(sorter);
    }

    protected void setWhiteChecked(Object treeElement, boolean isWhiteChecked) {
        if (isWhiteChecked) {
            if (!this.fWhiteCheckedTreeItems.contains(treeElement)) {
                this.fWhiteCheckedTreeItems.add(treeElement);
            }
        } else {
            this.fWhiteCheckedTreeItems.remove(treeElement);
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Object item = event.getElement();
        if (!this.fExpandedTreeNodes.contains(item)) {
            this.fExpandedTreeNodes.add(item);
            this.checkNewTreeElements(this.getTreeChildren(item));
        }
    }

    protected void treeItemChecked(Object treeElement, boolean state) {
        Object parent = this.fTreeContentProvider.getParent(treeElement);
        if (parent == null) {
            return;
        }
        this.fTreeViewer.setChecked(treeElement, true);
    }

    protected void ungrayCheckHierarchy(Object treeElement) {
        Object parent;
        if (!this.determineShouldBeAtLeastGrayChecked(treeElement)) {
            this.fCheckedStateStore.remove(treeElement);
        }
        if ((parent = this.fTreeContentProvider.getParent(treeElement)) != null) {
            this.ungrayCheckHierarchy(parent);
        }
    }

    protected void updateHierarchy(Object treeElement) {
        this.fTreeViewer.setChecked(treeElement, true);
    }

    public void updateSelections(final Map items) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                CheckboxTreeAndListGroup.this.handleUpdateSelection(items);
            }
        });
    }

    protected Object[] filter(ViewerFilter[] filters, Object[] elements) {
        if (filters != null) {
            ArrayList<Object> filtered = new ArrayList<Object>(elements.length);
            int i = 0;
            while (i < elements.length) {
                boolean add = true;
                int j = 0;
                while (j < filters.length) {
                    add = filters[j].select(null, null, elements[i]);
                    if (!add) break;
                    ++j;
                }
                if (add) {
                    filtered.add(elements[i]);
                }
                ++i;
            }
            return filtered.toArray();
        }
        return elements;
    }

    private Object[] getTreeChildren(Object element) {
        return this.filter(this.fTreeViewer.getFilters(), this.fTreeContentProvider.getChildren(element));
    }

    public Set getWhiteCheckedTreeItems() {
        return new HashSet(this.fWhiteCheckedTreeItems);
    }

    private void handleUpdateSelection(Map items) {
        for (Object key : items.keySet()) {
            List selections = (List)items.get(key);
            if (selections.size() == 0) {
                this.fCheckedStateStore.remove(key);
                continue;
            }
            this.fCheckedStateStore.put(key, selections);
            Object parent = this.fTreeContentProvider.getParent(key);
            if (parent == null) continue;
            this.addToHierarchyToCheckedStore(parent);
        }
        for (Object key : items.keySet()) {
            this.updateHierarchy(key);
        }
    }

    public boolean isTreeItemGreyChecked(Object object) {
        return this.fTreeViewer.getGrayed(object);
    }

    public void expandTreeToLevel(Object object, int level) {
        this.fTreeViewer.expandToLevel(object, level);
    }

    public void setTreeSelection(ISelection selection) {
        this.fTreeViewer.setSelection(selection);
    }
}

