/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.PluginImages;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.wizards.EGLDDBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLElementWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizard;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.RestBindingWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.SQLDatabaseBindingWizardPage;
import org.eclipse.edt.ide.ui.wizards.EGLDDBindingConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPackageConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public class EGLDDBindingWizard
extends EGLPartWizard {
    protected final int PATH_WS_GEN = 1;
    protected final int PATH_WS_USE = 2;
    protected final int PATH_EGL = 3;
    protected final int PATH_NATIVE = 4;
    protected final int PATH_REST = 5;
    protected final int PATH_SQL = 6;
    protected int fPagePath = 5;
    protected IWizardPage[] PAGES_WS_GEN;
    protected IWizardPage[] PAGES_WS_USE;
    protected IWizardPage[] PAGES_EGL;
    protected IWizardPage[] PAGES_NATIVE;
    protected IWizardPage[] PAGES_REST;
    protected IWizardPage[] PAGES_SQL;
    private Object fNewBinding;

    public EGLDDBindingWizard() {
        this.setDefaultPageImageDescriptor(PluginImages.DESC_WIZBAN_EXTERNALSERVICE);
    }

    public void init(IWorkbench workbench, IProject proj, EGLDeploymentRoot root) {
        this.getEGLDDBindingConfiguration().init(workbench, proj, root);
        this.setWindowTitle(NewWizardMessages.EGLDDBindingWizTitle);
    }

    @Override
    public EGLPackageConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new EGLDDBindingConfiguration();
        }
        return this.configuration;
    }

    @Override
    public EGLPackageConfiguration getConfiguration(String pageName) {
        EGLDDBindingConfiguration eglddConfig = this.getEGLDDBindingConfiguration();
        if (pageName.equals("WIZPAGENAME_EGLBindingWizardPage")) {
            return eglddConfig.getBindingEGLConfiguration();
        }
        if (pageName.equals("WIZPAGENAME_RestBindingWizardPage")) {
            return eglddConfig.getBindingRestConfiguration();
        }
        if (pageName.equals("WIZPAGENAME_SQLDatabaseBindingWizardPage")) {
            return eglddConfig.getBindingSQLConfiguration();
        }
        return super.getConfiguration(pageName);
    }

    private EGLDDBindingConfiguration getEGLDDBindingConfiguration() {
        return (EGLDDBindingConfiguration)this.getConfiguration();
    }

    public boolean canFinish() {
        switch (this.fPagePath) {
            case 1: {
                return this.canPagePathFinish(this.PAGES_WS_GEN);
            }
            case 2: {
                return this.canPagePathFinish(this.PAGES_WS_USE);
            }
            case 3: {
                return this.canPagePathFinish(this.PAGES_EGL);
            }
            case 4: {
                return this.canPagePathFinish(this.PAGES_NATIVE);
            }
            case 5: {
                return this.canPagePathFinish(this.PAGES_REST);
            }
            case 6: {
                return this.canPagePathFinish(this.PAGES_SQL);
            }
        }
        return super.canFinish();
    }

    @Override
    public void addPages() {
        EGLDDBindingWizardPage page1 = new EGLDDBindingWizardPage("WIZPAGENAME_EGLDDBindingWizardPage");
        RestBindingWizardPage page7 = new RestBindingWizardPage("WIZPAGENAME_RestBindingWizardPage");
        SQLDatabaseBindingWizardPage page8 = new SQLDatabaseBindingWizardPage("WIZPAGENAME_SQLDatabaseBindingWizardPage");
        this.PAGES_REST = new IWizardPage[]{page1, page7};
        this.PAGES_SQL = new IWizardPage[]{page1, page8};
        this.addPage((IWizardPage)page1);
        this.addPage((IWizardPage)page7);
        this.addPage((IWizardPage)page8);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return this.updatePagePathAndNextPage(page);
    }

    public IWizardPage updatePagePathAndNextPage(IWizardPage currentPage) {
        String currPageName = currentPage.getName();
        IWizardPage nextPage = null;
        if (currPageName.equals("WIZPAGENAME_EGLDDBindingWizardPage")) {
            int bindingType = this.getEGLDDBindingConfiguration().getBindingType();
            if (bindingType != 0) {
                if (bindingType == 2) {
                    nextPage = this.getPage("WIZPAGENAME_EGLBindingWizardPage");
                    this.fPagePath = 3;
                } else if (bindingType != 3) {
                    if (bindingType == 1) {
                        nextPage = this.getPage("WIZPAGENAME_RestBindingWizardPage");
                        this.fPagePath = 5;
                    } else if (bindingType == 4) {
                        nextPage = this.getPage("WIZPAGENAME_SQLDatabaseBindingWizardPage");
                        this.fPagePath = 6;
                    }
                }
            }
        } else if (currPageName.equals("WIZPAGENAME_EGLBindingWizardPage")) {
            nextPage = null;
            this.fPagePath = 3;
        } else if (currPageName.equals("WIZPAGENAME_RestBindingWizardPage")) {
            nextPage = null;
            this.fPagePath = 5;
        } else {
            nextPage = super.getNextPage(currentPage);
        }
        if (nextPage instanceof EGLElementWizardPage) {
            ((EGLElementWizardPage)nextPage).updateControlValues();
        }
        return nextPage;
    }

    @Override
    public boolean performFinish() {
        try {
            this.executeFinishOperations();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), null, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                EGLLogger.log((Object)this, e);
            }
            return false;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
            return false;
        }
        return true;
    }

    private void executeFinishOperations() throws InvocationTargetException, InterruptedException {
        this.fNewBinding = this.getEGLDDBindingConfiguration().executeAddBinding((IRunnableContext)this.getContainer());
    }

    public Object getNewBinding() {
        return this.fNewBinding;
    }
}

