/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.edt.ide.ui.internal.IUIHelpConstants;
import org.eclipse.edt.ide.ui.internal.record.NewRecordWizardMessages;
import org.eclipse.edt.ide.ui.internal.wizards.EGLPartWizardPage;
import org.eclipse.edt.ide.ui.internal.wizards.NewWizardMessages;
import org.eclipse.edt.ide.ui.templates.ITemplate;
import org.eclipse.edt.ide.ui.templates.TemplateManager;
import org.eclipse.edt.ide.ui.templates.wizards.TemplateWizardNode;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public abstract class EGLTemplateWizardPage
extends EGLPartWizardPage
implements ISelectionChangedListener,
IDoubleClickListener {
    protected TableViewer templateViewer;
    protected Text descriptionText;

    public EGLTemplateWizardPage(String pageName) {
        super(pageName);
    }

    protected abstract String getTemplateID();

    protected void createTemplateArea(Composite container, int nColumns) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, IUIHelpConstants.EGL_NEW_RECORD_TEMPLATE_SELECTION_PAGE);
        Group ownerInfo = new Group(container, 0);
        ownerInfo.setText(NewWizardMessages.ProjectWizardMainPage_1);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns;
        ownerInfo.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 2, true, false);
        gridData.horizontalSpan = nColumns;
        ownerInfo.setLayoutData((Object)gridData);
        int templateCol = nColumns % 2;
        int descriptionCol = nColumns - templateCol;
        Label label = new Label((Composite)ownerInfo, 0);
        label.setText(NewRecordWizardMessages.TemplateSelectionPage_templatesLabel);
        GridData gd = new GridData(256);
        gd.horizontalSpan = templateCol;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)ownerInfo, 0);
        label.setText(NewRecordWizardMessages.TemplateSelectionPage_descriptionLabel);
        gd = new GridData(256);
        gd.horizontalSpan = descriptionCol;
        label.setLayoutData((Object)gd);
        this.templateViewer = new TableViewer((Composite)ownerInfo, 2048);
        Table control = this.templateViewer.getTable();
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 250;
        data.horizontalSpan = templateCol;
        control.setLayoutData((Object)data);
        String templateID = this.getTemplateID();
        ITemplate[] templates = TemplateManager.getInstance().getTemplates(templateID);
        this.templateViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.templateViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.templateViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.templateViewer.setInput((Object)templates);
        this.templateViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.descriptionText = new Text((Composite)ownerInfo, 2632);
        data = new GridData(1808);
        this.descriptionText.setLayoutData((Object)data);
        data.horizontalSpan = descriptionCol;
        this.descriptionText.setBackground(control.getBackground());
        this.descriptionText.setForeground(control.getForeground());
        if (templates != null) {
            int i = 0;
            while (i < templates.length) {
                if (templates[i].isDefault()) {
                    this.templateViewer.setSelection((ISelection)new StructuredSelection(new Object[]{templates[i]}), true);
                }
                ++i;
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            this.handleSelectedTemplate();
            this.setTemplateDescription(((ITemplate)o).getDescription());
        }
        this.validateTemplatePage();
    }

    protected void validateTemplatePage() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            boolean b;
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            this.handleSelectedTemplate();
            String templateID = ((ITemplate)o).getCodeTemplateId();
            boolean bl = b = wizNode != null && wizNode.isContentCreated() && wizNode.getWizard() != null && wizNode.getWizard().canFinish() || templateID != null;
            b = template.hasWizard() ? b && this.isPageComplete() : b && this.validateEGLPartName();
            this.setPageComplete(b);
        } else {
            this.setPageComplete(false);
        }
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.validateEGLPartName();
    }

    protected void handleSelectedTemplate() {
        Object o = ((IStructuredSelection)this.templateViewer.getSelection()).getFirstElement();
        if (o instanceof ITemplate) {
            ITemplate template = (ITemplate)o;
            TemplateWizardNode wizNode = (TemplateWizardNode)template.getWizardNode();
            if (wizNode != null) {
                wizNode.setParentWizard(this.getWizard());
                this.setSelectedNode(wizNode);
            } else {
                this.setSelectedNode(null);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.validateTemplatePage();
        }
    }

    private void setTemplateDescription(String text) {
        this.descriptionText.setText(text != null ? text : "");
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.validateEGLPartName();
    }

    private boolean validateEGLPartName() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateName(this.getFileConfiguration().getFileName(), 1);
        return status.isOK();
    }

    public void doubleClick(DoubleClickEvent event) {
        if (event.getSource() == this.templateViewer) {
            if (this.getSelectedNode() != null) {
                IWizard wiz = this.getWizard();
                WizardDialog d = (WizardDialog)wiz.getContainer();
                d.showPage(this.getNextPage());
            } else if (this.getWizard().canFinish() && this.getWizard().performFinish()) {
                this.getWizard().getContainer().getShell().close();
            }
        }
    }

    private class TreeContentProvider
    implements IStructuredContentProvider {
        private TreeContentProvider() {
        }

        public Object[] getElements(Object input) {
            return (ITemplate[])input;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public class TreeLabelProvider
    implements ILabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ITemplate && ((ITemplate)element).getIcon() != null) {
                return ((ITemplate)element).getIcon().createImage();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ITemplate) {
                return ((ITemplate)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

