/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingRestConfiguration;
import org.eclipse.edt.ide.ui.wizards.BindingSQLDatabaseConfiguration;
import org.eclipse.edt.ide.ui.wizards.EGLPartConfiguration;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IWorkbench;

public class EGLDDBindingConfiguration
extends EGLPartConfiguration {
    public static final int BINDINGTYPE_WEB = 0;
    public static final int BINDINGTYPE_REST = 1;
    public static final int BINDINGTYPE_EGL = 2;
    public static final int BINDINGTYPE_NATIVE = 3;
    public static final int BINDINGTYPE_SQL = 4;
    private int fBindingType = 1;
    private BindingEGLConfiguration fBindingEGLConfig;
    private BindingRestConfiguration fBindingRestConfig;
    private BindingSQLDatabaseConfiguration fBindingSQLConfig;
    private IWorkbench fWorkbench;
    private IProject fProj;
    private EGLDeploymentRoot fDeploymentRoot;

    public void init(IWorkbench workbench, IProject proj, EGLDeploymentRoot root) {
        this.fWorkbench = workbench;
        this.fProj = proj;
        this.fDeploymentRoot = root;
    }

    public int getBindingType() {
        return this.fBindingType;
    }

    public void setBindingType(int bindingType) {
        this.fBindingType = bindingType;
    }

    public EGLDeploymentRoot getDeploymentRoot() {
        return this.fDeploymentRoot;
    }

    public BindingEGLConfiguration getBindingEGLConfiguration() {
        if (this.fBindingEGLConfig == null) {
            this.fBindingEGLConfig = new BindingEGLConfiguration(this.fDeploymentRoot, this.fProj);
        }
        return this.fBindingEGLConfig;
    }

    public BindingRestConfiguration getBindingRestConfiguration() {
        if (this.fBindingRestConfig == null) {
            this.fBindingRestConfig = new BindingRestConfiguration(this.fDeploymentRoot, this.fProj);
        }
        return this.fBindingRestConfig;
    }

    public BindingSQLDatabaseConfiguration getBindingSQLConfiguration() {
        if (this.fBindingSQLConfig == null) {
            this.fBindingSQLConfig = new BindingSQLDatabaseConfiguration(this.fDeploymentRoot, this.fProj);
        }
        return this.fBindingSQLConfig;
    }

    private Bindings getBindings() {
        Deployment deployment = this.fDeploymentRoot.getDeployment();
        Bindings bindings = deployment.getBindings();
        if (bindings == null) {
            bindings = DeploymentFactory.eINSTANCE.createBindings();
            deployment.setBindings(bindings);
        }
        return bindings;
    }

    public Object executeAddBinding(IRunnableContext runnableContext) throws InvocationTargetException, InterruptedException {
        Bindings bindings = this.getBindings();
        Object newBinding = null;
        if (this.fBindingType == 1) {
            newBinding = this.fBindingRestConfig.executeAddRestBinding(bindings);
        } else if (this.fBindingType == 4) {
            newBinding = this.fBindingSQLConfig.executeAddSQLDatabaseBinding(bindings);
        }
        return newBinding;
    }
}

