/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.internal.core.java;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.edt.debug.core.IEGLValue;
import org.eclipse.edt.debug.core.java.IEGLJavaValue;
import org.eclipse.edt.debug.core.java.IEGLJavaVariable;
import org.eclipse.edt.debug.core.java.SMAPVariableInfo;
import org.eclipse.edt.debug.internal.core.java.EGLJavaDebugElement;
import org.eclipse.edt.debug.internal.core.java.EGLJavaFunctionVariable;
import org.eclipse.edt.debug.internal.core.java.EGLJavaStackFrame;
import org.eclipse.edt.debug.internal.core.java.EGLJavaVariable;
import org.eclipse.edt.debug.internal.core.java.VariableUtil;
import org.eclipse.jdt.debug.core.IJavaValue;

public class EGLJavaFunctionValue
extends EGLJavaDebugElement
implements IEGLJavaValue {
    private final EGLJavaStackFrame frame;
    protected final IEGLJavaVariable parentVariable;
    protected IVariable[] children;

    public EGLJavaFunctionValue(EGLJavaStackFrame frame, EGLJavaFunctionVariable parentVariable) {
        super(frame.getDebugTarget());
        this.frame = frame;
        this.parentVariable = parentVariable;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (this.children != null) {
            return this.children;
        }
        if (this.frame.getSMAP().length() == 0) {
            this.children = this.frame.getJavaStackFrame().getLocalVariables();
        } else {
            List<IEGLJavaVariable> newEGLVariables = VariableUtil.filterAndWrapVariables((IVariable[])this.frame.getJavaStackFrame().getLocalVariables(), this.parentVariable.getEGLStackFrame(), false, this);
            this.children = newEGLVariables.toArray(new EGLJavaVariable[newEGLVariables.size()]);
        }
        return this.children;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IValue.class || adapter == IEGLValue.class || adapter == IEGLJavaValue.class || adapter == EGLJavaFunctionValue.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getReferenceTypeName() throws DebugException {
        return "";
    }

    public String getValueString() throws DebugException {
        return "";
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    @Override
    public Object getJavaDebugElement() {
        return this.frame;
    }

    @Override
    public String computeDetail() {
        return "";
    }

    @Override
    public IJavaValue getJavaValue() {
        return null;
    }

    @Override
    public IEGLJavaVariable getParentVariable() {
        return this.parentVariable;
    }

    @Override
    public SMAPVariableInfo[] getSMAPVariableInfos() throws DebugException {
        return this.frame.getSMAPVariableInfos();
    }
}

