/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import com.ibm.icu.util.StringTokenizer;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.edt.compiler.internal.interfaces.IGenerationMessageRequestor;
import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.IGenerator;
import org.eclipse.edt.ide.core.Logger;
import org.eclipse.edt.ide.core.internal.generation.GenerationRequest;
import org.eclipse.edt.ide.core.internal.generation.IEGLPartWrapper;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfo;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.ide.core.internal.utils.StringOutputBuffer;
import org.eclipse.edt.ide.core.internal.utils.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.InvalidPartTypeException;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.PartNotFoundException;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class GeneratePartsOperation {
    private static final Object lock = new Object();
    private ArrayList<GenerationRequest> genRequestList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGenerationRequest(GenerationRequest request) {
        ArrayList<GenerationRequest> arrayList = this.genRequestList;
        synchronized (arrayList) {
            this.genRequestList.add(request);
        }
    }

    public void generate(GenerationRequest request) {
        this.addGenerationRequest(request);
        Job generationJob = this.createGenerationJob(true, false);
        generationJob.schedule();
    }

    public void generate(GenerationRequest[] requests, boolean respectBuildBeforeGenerate, boolean runInBackground) {
        int i = 0;
        while (i < requests.length) {
            this.addGenerationRequest(requests[i]);
            ++i;
        }
        Job generationJob = this.createGenerationJob(respectBuildBeforeGenerate, runInBackground);
        generationJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IEGLPartWrapper[] parts, boolean respectBuildBeforeGenerate, boolean runInBackground) {
        GenerationRequest gr = new GenerationRequest(parts);
        ArrayList<GenerationRequest> arrayList = this.genRequestList;
        synchronized (arrayList) {
            this.genRequestList.add(gr);
        }
        Job generationJob = this.createGenerationJob(respectBuildBeforeGenerate, runInBackground);
        generationJob.schedule();
    }

    private Job createGenerationJob(boolean respectBuildBeforeGenerate, boolean runInBackground) {
        boolean build;
        if (respectBuildBeforeGenerate && !ResourcesPlugin.getWorkspace().isAutoBuilding() && (build = false)) {
            try {
                ResourcesPlugin.getWorkspace().build(10, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        Job generationJob = new Job(CoreIDEPluginStrings.GeneratePartsOperation_JobName){

            public boolean shouldRun() {
                return super.shouldRun() && !GeneratePartsOperation.this.isWorkbenchClosing();
            }

            public IStatus run(IProgressMonitor monitor) {
                WorkspaceModifyOperation modifyOperation = new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        GeneratePartsOperation.this.generateParts(monitor);
                    }
                };
                try {
                    modifyOperation.run(monitor);
                }
                catch (InvocationTargetException e) {
                    Logger.log((Object)this, "GeneratePartsOperation.createGenerationJob():  InvocationTargetException", e);
                }
                catch (InterruptedException e) {
                    Logger.log((Object)this, "GeneratePartsOperation.createGenerationJob():  InterruptedException", e);
                }
                return Status.OK_STATUS;
            }
        };
        generationJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        generationJob.setUser(!runInBackground);
        generationJob.setSystem(false);
        generationJob.setPriority(30);
        return generationJob;
    }

    protected static IGenerationMessageRequestor createMessageRequestor() {
        return new IGenerationMessageRequestor(){
            ArrayList<IGenerationResultsMessage> list = new ArrayList();
            boolean error = false;

            public void addMessage(IGenerationResultsMessage message) {
                this.list.add(message);
                if (message.isError()) {
                    this.error = true;
                }
            }

            public void addMessages(List<IGenerationResultsMessage> list) {
                Iterator<IGenerationResultsMessage> i = list.iterator();
                while (i.hasNext()) {
                    this.addMessage(i.next());
                }
            }

            public List<IGenerationResultsMessage> getMessages() {
                return this.list;
            }

            public boolean isError() {
                return this.error;
            }

            public void clear() {
                this.error = false;
                this.list = new ArrayList();
            }
        };
    }

    protected boolean isWorkbenchClosing() {
        try {
            return PlatformUI.getWorkbench().isClosing();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void generateParts(IProgressMonitor monitor) {
        var2_2 = GeneratePartsOperation.lock;
        synchronized (var2_2) {
            genRequest = null;
            partList = null;
            block10: while (true) {
                var5_5 = this.genRequestList;
                synchronized (var5_5) {
                    if (this.genRequestList.size() <= 0) {
                        break;
                    }
                    genRequest = this.genRequestList.remove(0);
                }
                if (genRequest == null) continue;
                partList = genRequest.getGenerationUnits();
                if (monitor != null) {
                    monitor.beginTask(CoreIDEPluginStrings.GeneratePartsOperation_TaskName, partList.length * 2);
                }
                i = 0;
                while (true) {
                    if (i >= partList.length) continue block10;
                    if (this.isWorkbenchClosing()) continue block10;
                    if (monitor != null) {
                        monitor.worked(1);
                        if (monitor.isCanceled()) ** break;
                    }
                    partFile = partList[i].getPartPath();
                    partName = partList[i].getPartName();
                    if (monitor != null) {
                        monitor.subTask(CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.GeneratePartsOperation_SubTaskName, (Object)partName));
                    }
                    messageRequestor = GeneratePartsOperation.createMessageRequestor();
                    project = this.getProject(partFile);
                    if (project == null || !project.exists()) {
                        message = EGLMessage.createEGLValidationErrorMessage((String)"4615", null, (String)partFile);
                        messageRequestor.addMessage((IGenerationResultsMessage)message);
                    } else {
                        part = null;
                        try {
                            environment = ProjectEnvironmentManager.getInstance().getProjectEnvironment(project);
                            packageName = EGLCore.create(project).isBinary() != false ? this.getPackageName(partFile, environment) : this.getPackageName(partFile, ProjectInfoManager.getInstance().getProjectInfo(project));
                            part = environment.findPart(InternUtil.intern((String[])packageName), InternUtil.intern((String)partName));
                            if (part != null && !part.hasCompileErrors().booleanValue() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(partFile))) != null && file.exists()) {
                                this.invokeGenerators(file, part, messageRequestor);
                            }
                        }
                        catch (PartNotFoundException e) {
                            this.buildPartNotFoundMessage(e, messageRequestor, partName);
                        }
                        catch (RuntimeException e) {
                            this.handleRuntimeException(e, messageRequestor, partName, new HashSet<E>());
                        }
                        catch (Exception e) {
                            this.handleUnknownException(e, messageRequestor);
                        }
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ++i;
                }
                break;
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected void handleRuntimeException(RuntimeException e, IGenerationMessageRequestor messageRequestor, String partName, HashSet seen) {
        if (seen.contains(e)) {
            this.handleUnknownException(e, messageRequestor);
            return;
        }
        seen.add(e);
        Throwable cause = e.getCause();
        if (cause instanceof PartNotFoundException) {
            this.buildPartNotFoundMessage((PartNotFoundException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof InvalidPartTypeException) {
            this.buildInvalidPartTypeMessage((InvalidPartTypeException)cause, messageRequestor, partName);
            return;
        }
        if (cause instanceof RuntimeException) {
            this.handleRuntimeException((RuntimeException)cause, messageRequestor, partName, seen);
            return;
        }
        this.handleUnknownException(e, messageRequestor);
    }

    protected void handleUnknownException(Exception e, IGenerationMessageRequestor messageRequestor) {
        this.buildExceptionMessage(e, messageRequestor);
        GeneratePartsOperation.buildStackTraceMessages(e, messageRequestor);
        Logger.log(this, "GeneratePartsOperation.generateParts():  Error during generation", e);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasError(IFile file) {
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding()) {
            return false;
        }
        if (file == null || !file.exists()) {
            return false;
        }
        try {
            IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            if (markers == null) {
                return false;
            }
            int i = 0;
            while (true) {
                if (i >= markers.length) {
                    return false;
                }
                int severity = markers[i].getAttribute("severity", 0);
                if (severity >= 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void buildPartNotFoundMessage(PartNotFoundException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage((IGenerationResultsMessage)message);
    }

    protected void buildInvalidPartTypeMessage(InvalidPartTypeException e, IGenerationMessageRequestor result, String partName) {
        EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9001", null, (String[])new String[]{partName, e.getMessage()});
        result.addMessage((IGenerationResultsMessage)message);
    }

    private void invokeGenerators(IFile file, Part part, IGenerationMessageRequestor req) throws Exception {
        IGenerator[] generators = ProjectSettingsUtility.getGenerators((IResource)file);
        if (generators.length != 0) {
            ProjectIREnvironment env = ProjectEnvironmentManager.getInstance().getProjectEnvironment(file.getProject()).getIREnvironment();
            int i = 0;
            while (i < generators.length) {
                generators[i].generate(file.getFullPath().toString(), (Part)part.clone(), (IEnvironment)env, req);
                ++i;
            }
        }
    }

    public void buildExceptionMessage(Exception e, IGenerationMessageRequestor result) {
        String text = e.getMessage();
        if (text != null) {
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9998", null, (String)text);
            result.addMessage((IGenerationResultsMessage)message);
        }
    }

    public static void buildStackTraceMessages(Throwable e, IGenerationMessageRequestor result) {
        StringOutputBuffer buffer = new StringOutputBuffer();
        PrintWriter writer = new PrintWriter(buffer);
        e.printStackTrace(writer);
        writer.flush();
        String text = buffer.toString();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r\f");
        while (tokenizer.hasMoreElements()) {
            char[] token = tokenizer.nextToken().toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int i = 0;
            while (i < token.length) {
                if (token[i] == '\t') {
                    stringBuffer.append("      ");
                } else {
                    stringBuffer.append(token[i]);
                }
                ++i;
            }
            EGLMessage message = EGLMessage.createEGLValidationErrorMessage((String)"9999", null, (String)stringBuffer.toString());
            result.addMessage((IGenerationResultsMessage)message);
        }
    }

    protected String[] getPackageName(String filename, ProjectInfo projectInfo) {
        Path path = new Path(filename);
        path = path.removeFirstSegments(1);
        path = path.removeLastSegments(1);
        String[] retVal = Util.pathToStringArray((IPath)path);
        while (retVal.length > 0) {
            if (projectInfo.hasPackage(InternUtil.intern((String[])retVal))) break;
            path = path.removeFirstSegments(1);
            retVal = Util.pathToStringArray((IPath)path);
        }
        return retVal;
    }

    protected String[] getPackageName(String filename, ProjectEnvironment env) {
        Path path = new Path(filename);
        path = path.removeFirstSegments(1);
        path = path.removeLastSegments(1);
        String[] retVal = Util.pathToStringArray((IPath)path);
        while (retVal.length > 0) {
            if (env.hasPackage(InternUtil.intern((String[])retVal))) break;
            path = path.removeFirstSegments(1);
            retVal = Util.pathToStringArray((IPath)path);
        }
        return retVal;
    }

    protected IProject getProject(String filename) {
        Path path = new Path(filename);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        return project;
    }
}

