/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.egl.lookup.EglLookupDelegate;
import org.eclipse.edt.mof.impl.Bootstrap;
import org.eclipse.edt.mof.serialization.CachingObjectStore;
import org.eclipse.edt.mof.serialization.Environment;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;
import org.eclipse.edt.mof.serialization.ProxyEObject;
import org.eclipse.edt.mof.serialization.SerializationException;

public class ProjectIREnvironment
extends Environment {
    private boolean systemPartsInitialized;

    public void reset() {
        super.reset();
        this.registerLookupDelegate("egl", (IEnvironment.LookupDelegate)new EglLookupDelegate());
        this.systemPartsInitialized = false;
    }

    public void initSystemEnvironment(ISystemEnvironment environment) {
        if (this.systemPartsInitialized) {
            return;
        }
        this.systemPartsInitialized = true;
        Bootstrap.initialize((IEnvironment)this);
        Map systemMap = environment.getStores();
        for (Map.Entry entry : systemMap.entrySet()) {
            String scheme = (String)entry.getKey();
            List stores = (List)entry.getValue();
            for (ObjectStore store : stores) {
                this.registerObjectStore(scheme, store);
            }
        }
    }

    public EObject get(String key) {
        String scheme = this.getKeySchemeFromKey(key);
        List stores = (List)this.objectStores.get(scheme);
        if (stores != null) {
            for (ObjectStore store : stores) {
                EObject value;
                if (!(store instanceof CachingObjectStore) || (value = ((CachingObjectStore)store).getFromCache(key)) == null) continue;
                return value;
            }
        }
        return super.get(key);
    }

    public void remove(String key) {
        super.remove(key);
        String scheme = this.getKeySchemeFromKey(key);
        List stores = (List)this.objectStores.get(scheme);
        if (stores != null) {
            for (ObjectStore store : stores) {
                if (!(store instanceof CachingObjectStore)) continue;
                store.remove(key);
            }
        }
    }

    protected void save(String key, EObject object, ObjectStore store) throws SerializationException {
        if (store instanceof CachingObjectStore) {
            String storeKey = this.getDelegateForKey(key).normalizeKey(key);
            store.put(storeKey, object);
            this.updateProxyReferences(storeKey, object);
            this.objectCache.remove(storeKey);
        } else if (object instanceof ProxyEObject || !this.storeInObjectStoreCache(key, object)) {
            super.save(key, object, store);
        }
    }

    protected boolean storeInObjectStoreCache(String key, EObject object) {
        String scheme = this.getKeySchemeFromKey(key);
        List stores = (List)this.objectStores.get(scheme);
        if (stores != null) {
            String storeKey = this.getDelegateForKey(key).normalizeKey(key);
            for (ObjectStore nextStore : stores) {
                if (!(nextStore instanceof CachingObjectStore) || !nextStore.containsKey(key)) continue;
                this.updateProxyReferences(storeKey, object);
                ((CachingObjectStore)nextStore).addToCache(storeKey, object);
                this.objectCache.remove(storeKey);
                return true;
            }
        }
        return false;
    }
}

