/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.PackageBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IBindingEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.mof2binding.Mof2Binding;
import org.eclipse.edt.ide.core.internal.compiler.SystemEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.IWorkingCopyBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.partinfo.IPartOrigin;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;
import org.eclipse.edt.mof.egl.utils.InternUtil;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class WorkingCopyProjectEnvironment
implements IBindingEnvironment {
    private PackageBinding rootPackageBinding = new PackageBinding(ProjectEnvironment.defaultPackage, null, (IEnvironment)this);
    private final IProject project;
    private WorkingCopyProjectBuildPathEntry declaringProjectBuildPathEntry;
    private IWorkingCopyBuildPathEntry[] buildPathEntries;
    private Mof2Binding converter;
    private ProjectIREnvironment irEnvironment;

    public WorkingCopyProjectEnvironment(IProject project) {
        this.project = project;
        this.converter = new Mof2Binding((IBindingEnvironment)this);
    }

    public void setIREnvironment(ProjectIREnvironment environment) {
        this.irEnvironment = environment;
    }

    public ProjectIREnvironment getIREnvironment() {
        return this.irEnvironment;
    }

    public Mof2Binding getConverter() {
        return this.converter;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPartOrigin getPartOrigin(String[] packageName, String partName) {
        IPartOrigin retVal = this.declaringProjectBuildPathEntry.getPartOrigin(packageName, partName);
        return retVal;
    }

    public void setProjectBuildPathEntries(IWorkingCopyBuildPathEntry[] projectBuildPathEntries) {
        this.buildPathEntries = projectBuildPathEntries;
        if (this.buildPathEntries != null) {
            int i = 0;
            while (i < this.buildPathEntries.length) {
                ObjectStore[] stores = this.buildPathEntries[i].getObjectStores();
                int j = 0;
                while (j < stores.length) {
                    this.irEnvironment.registerObjectStore(stores[j].getKeyScheme(), stores[j]);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected void setDeclaringProjectBuildPathEntry(WorkingCopyProjectBuildPathEntry entry) {
        this.declaringProjectBuildPathEntry = entry;
    }

    public IPartBinding getPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getPartBinding(packageName, partName);
    }

    public IPartBinding getNewPartBinding(String[] packageName, String caseSensitiveInternedPartName, int kind) {
        IPartBinding binding = this.declaringProjectBuildPathEntry.getNewPartBinding(packageName, caseSensitiveInternedPartName, kind);
        if (binding != null && binding != IBinding.NOT_FOUND_BINDING) {
            binding.setEnvironment((IEnvironment)this);
        }
        return binding;
    }

    public boolean hasPackage(String[] packageName) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPackage(packageName)) {
                return true;
            }
            ++i;
        }
        return this.getSystemEnvironment().hasPackage(packageName);
    }

    public IPackageBinding getRootPackage() {
        return this.rootPackageBinding;
    }

    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        int i = 0;
        while (i < this.buildPathEntries.length) {
            int partType = this.buildPathEntries[i].hasPart(packageName, caseInsensitiveInternedPartName);
            if (partType != 1) {
                IPartBinding result = PartBinding.newPartBinding((int)partType, (String[])packageName, (String)caseSensitiveInternedPartName);
                result.setEnvironment(this.buildPathEntries[i].getRealizingEnvironment());
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getPartBinding(packageName, caseInsensitiveInternedPartName);
    }

    public void clear() {
        this.buildPathEntries = null;
        this.rootPackageBinding = new PackageBinding(ProjectEnvironment.defaultPackage, null, (IEnvironment)this);
        this.converter = new Mof2Binding((IBindingEnvironment)this);
    }

    public WorkingCopyProjectBuildPathEntry getDeclaringProjectBuildPathEntry() {
        return this.declaringProjectBuildPathEntry;
    }

    public ISystemEnvironment getSystemEnvironment() {
        return SystemEnvironmentManager.findSystemEnvironment(this.getProject(), null);
    }

    public ICompiler getCompiler() {
        return ProjectSettingsUtility.getCompiler(this.getProject());
    }

    public IPartBinding getCachedPartBinding(String[] packageName, String partName) {
        IPartBinding result = null;
        int i = 0;
        while (i < this.buildPathEntries.length) {
            result = this.buildPathEntries[i].getCachedPartBinding(packageName, partName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return this.getSystemEnvironment().getCachedPartBinding(packageName, partName);
    }

    public void addPartBindingToCache(IPartBinding partBinding) {
        int i = 0;
        while (i < this.buildPathEntries.length) {
            if (this.buildPathEntries[i].hasPart(partBinding.getPackageName(), partBinding.getCaseSensitiveName()) != 1) {
                this.buildPathEntries[i].addPartBindingToCache(partBinding);
                break;
            }
            ++i;
        }
    }
}

