/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.CreatePackageFragmentOperation;
import org.eclipse.edt.ide.core.internal.model.DeletePackageFragmentRootOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.EGLPathEntry;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.MovePackageFragmentRootOperation;
import org.eclipse.edt.ide.core.internal.model.Openable;
import org.eclipse.edt.ide.core.internal.model.OpenableElementInfo;
import org.eclipse.edt.ide.core.internal.model.PackageFragment;
import org.eclipse.edt.ide.core.internal.model.PackageFragmentRootInfo;
import org.eclipse.edt.ide.core.internal.model.SourceMapper;
import org.eclipse.edt.ide.core.internal.model.Util;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public class PackageFragmentRoot
extends Openable
implements IPackageFragmentRoot {
    protected static final char ATTACHMENT_PROPERTY_DELIMITER = '*';
    public static final String NO_SOURCE_ATTACHMENT = "";
    protected Object resource;

    protected PackageFragmentRoot(IResource resource, IEGLProject project, String name) {
        super(3, project, name);
        this.resource = resource;
    }

    protected boolean computeChildren(OpenableElementInfo info) throws EGLModelException {
        try {
            IResource resource = this.getResource();
            if (resource.getType() == 2 || resource.getType() == 4) {
                ArrayList vChildren = new ArrayList(5);
                char[][] exclusionPatterns = this.fullExclusionPatternChars();
                this.computeFolderChildren((IContainer)resource, NO_SOURCE_ATTACHMENT, vChildren, exclusionPatterns);
                IEGLElement[] children = new IEGLElement[vChildren.size()];
                vChildren.toArray(children);
                info.setChildren(children);
            }
        }
        catch (EGLModelException e) {
            info.setChildren(new IEGLElement[0]);
            throw e;
        }
        return true;
    }

    protected void computeFolderChildren(IContainer folder, String prefix, ArrayList vChildren, char[][] exclusionPatterns) throws EGLModelException {
        IPackageFragment pkg = this.getPackageFragment(prefix);
        vChildren.add(pkg);
        try {
            EGLProject javaProject = (EGLProject)this.getEGLProject();
            IResource[] members = folder.members();
            int i = 0;
            int max = members.length;
            while (i < max) {
                IResource member = members[i];
                String memberName = member.getName();
                if (member.getType() == 2 && Util.isValidFolderNameForPackage(memberName) && !Util.isExcluded(member, exclusionPatterns) && javaProject.contains(member)) {
                    String newPrefix = prefix.length() == 0 ? memberName : String.valueOf(prefix) + "." + memberName;
                    this.computeFolderChildren((IContainer)((IFolder)member), newPrefix, vChildren, exclusionPatterns);
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            throw new EGLModelException(e, 969);
        }
        catch (CoreException e) {
            throw new EGLModelException(e);
        }
    }

    @Override
    public void copy(IPath destination, int updateResourceFlags, int updateModelFlags, IEGLPathEntry sibling, IProgressMonitor monitor) throws EGLModelException {
    }

    @Override
    protected OpenableElementInfo createElementInfo() {
        return new PackageFragmentRootInfo();
    }

    @Override
    public IPackageFragment createPackageFragment(String name, boolean force, IProgressMonitor monitor) throws EGLModelException {
        CreatePackageFragmentOperation op = new CreatePackageFragmentOperation(this, name, force);
        op.runOperation(monitor);
        return this.getPackageFragment(name);
    }

    protected int determineKind(IResource underlyingResource) throws EGLModelException {
        IEGLPathEntry[] entries = ((EGLProject)this.getEGLProject()).getExpandedEGLPath(true);
        int i = 0;
        while (i < entries.length) {
            IEGLPathEntry entry = entries[i];
            if (entry.getPath().equals((Object)underlyingResource.getFullPath())) {
                return entry.getContentKind();
            }
            ++i;
        }
        return 1;
    }

    @Override
    public void delete(int updateResourceFlags, int updateModelFlags, IProgressMonitor monitor) throws EGLModelException {
        int resourceUpdateFlags = 2;
        int eCoreUpdateFlags = 6;
        DeletePackageFragmentRootOperation op = new DeletePackageFragmentRootOperation(this, resourceUpdateFlags, eCoreUpdateFlags);
        op.runOperation(monitor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageFragmentRoot)) {
            return false;
        }
        PackageFragmentRoot other = (PackageFragmentRoot)o;
        return this.getEGLModel().equals(other.getEGLModel()) && this.resource.equals(other.resource) && this.fOccurrenceCount == other.fOccurrenceCount;
    }

    @Override
    public boolean exists() {
        return super.exists() && this.isOnEGLPath();
    }

    char[][] fullExclusionPatternChars() {
        EGLPathEntry entry;
        block5: {
            block4: {
                try {
                    if (!this.isOpen() || this.getKind() == 1) break block4;
                    return null;
                }
                catch (EGLModelException eGLModelException) {
                    return null;
                }
            }
            entry = (EGLPathEntry)this.getRawEGLPathEntry();
            if (entry != null) break block5;
            return null;
        }
        return entry.fullExclusionPatternChars();
    }

    @Override
    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws EGLModelException {
        ((PackageFragmentRootInfo)info).setRootKind(this.determineKind(underlyingResource));
        return this.computeChildren(info);
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '/';
    }

    @Override
    public String getHandleMemento() {
        IResource resource = this.getResource();
        IPath path = resource != null ? (this.getResource().getProject().equals((Object)this.getEGLProject().getProject()) ? resource.getProjectRelativePath() : resource.getFullPath()) : this.getPath();
        StringBuffer buff = new StringBuffer(((EGLElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(path.toString());
        return buff.toString();
    }

    @Override
    public int getKind() throws EGLModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getRootKind();
    }

    @Override
    public Object[] getNonEGLResources() throws EGLModelException {
        return ((PackageFragmentRootInfo)this.getElementInfo()).getNonEGLResources(this.getEGLProject(), this.getResource(), this);
    }

    @Override
    public IPackageFragment getPackageFragment(String packageName) {
        ArrayList<String> pkgs = new ArrayList<String>();
        char[][] compoundName = Util.toCompoundChars(packageName);
        StringBuffer buffer = new StringBuffer(packageName.length());
        int i = 0;
        int length = compoundName.length;
        while (i < length) {
            pkgs.add(String.valueOf(CharOperation.trim((char[])compoundName[i])));
            ++i;
        }
        packageName = buffer.toString();
        return this.getPackageFragment(pkgs.toArray(new String[pkgs.size()]));
    }

    public PackageFragment getPackageFragment(String[] pkgName) {
        return new PackageFragment(this, pkgName);
    }

    protected String getPackageName(IFolder folder) throws EGLModelException {
        IPath myPath = this.getPath();
        IPath pkgPath = folder.getFullPath();
        int mySegmentCount = myPath.segmentCount();
        int pkgSegmentCount = pkgPath.segmentCount();
        StringBuffer name = new StringBuffer(NO_SOURCE_ATTACHMENT);
        int i = mySegmentCount;
        while (i < pkgSegmentCount) {
            if (i > mySegmentCount) {
                name.append('.');
            }
            name.append(pkgPath.segment(i));
            ++i;
        }
        return name.toString();
    }

    @Override
    public IPath getPath() {
        return this.getResource().getFullPath();
    }

    @Override
    public IEGLPathEntry getRawEGLPathEntry() throws EGLModelException {
        IEGLPathEntry rawEntry = null;
        IEGLProject project = this.getEGLProject();
        project.getResolvedEGLPath(true);
        EGLModelManager.PerProjectInfo perProjectInfo = EGLModelManager.getEGLModelManager().getPerProjectInfoCheckExistence(project.getProject());
        if (perProjectInfo != null && perProjectInfo.resolvedPathToRawEntries != null) {
            rawEntry = (IEGLPathEntry)perProjectInfo.resolvedPathToRawEntries.get(this.getPath());
        }
        return rawEntry;
    }

    @Override
    public IResource getResource() {
        return (IResource)this.resource;
    }

    @Override
    public IResource getUnderlyingResource() throws EGLModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getResource();
    }

    @Override
    public int hashCode() {
        return this.resource.hashCode();
    }

    @Override
    public boolean isArchive() {
        return false;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isOnEGLPath() {
        if (this.getElementType() == 2) {
            return true;
        }
        IPath path = this.getPath();
        try {
            IEGLProject project = this.getEGLProject();
            IEGLPathEntry[] classpath = project.getResolvedEGLPath(true);
            int i = 0;
            int length = classpath.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                IEGLPathEntry entry = classpath[i];
                if (entry.getPath().equals((Object)path)) {
                    return true;
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return false;
    }

    @Override
    public void move(IPath destination, int updateResourceFlags, int updateModelFlags, IEGLPathEntry sibling, IProgressMonitor monitor) throws EGLModelException {
        int resourceUpdateFlags = 34;
        int eCoreUpdateFlags = 30;
        MovePackageFragmentRootOperation op = new MovePackageFragmentRootOperation(this, destination, resourceUpdateFlags, eCoreUpdateFlags, sibling);
        op.runOperation(monitor);
    }

    @Override
    protected void openWhenClosed(IProgressMonitor pm) throws EGLModelException {
        if (!this.resourceExists() || !this.isOnEGLPath()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public void refreshChildren() {
        try {
            OpenableElementInfo info = (OpenableElementInfo)this.getElementInfo();
            this.computeChildren(info);
        }
        catch (EGLModelException eGLModelException) {}
    }

    @Override
    public IEGLElement rootedAt(IEGLProject project) {
        return new PackageFragmentRoot(this.getResource(), project, this.fName);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (this.getElementName().length() == 0) {
            buffer.append("[project root]");
        } else {
            IPath path = this.getPath();
            if (this.getEGLProject().getElementName().equals(path.segment(0))) {
                buffer.append(path.removeFirstSegments(1).makeRelative());
            } else {
                buffer.append(path);
            }
        }
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    public SourceMapper getSourceMapper() {
        SourceMapper mapper;
        try {
            PackageFragmentRootInfo rootInfo = (PackageFragmentRootInfo)this.getElementInfo();
            mapper = rootInfo.getSourceMapper();
            IPath sourcePath = this.getSourceAttachmentPath();
            if (mapper == null) {
                IPath rootPath = this.getSourceAttachmentRootPath();
                mapper = this.createSourceMapper(sourcePath, rootPath);
                rootInfo.setSourceMapper(mapper);
            } else if (sourcePath == null || !sourcePath.equals((Object)mapper.getSourcePath())) {
                IPath rootPath = this.getSourceAttachmentRootPath();
                mapper = this.createSourceMapper(sourcePath, rootPath);
                rootInfo.setSourceMapper(mapper);
            }
        }
        catch (EGLModelException eGLModelException) {
            mapper = null;
        }
        catch (CoreException coreException) {
            mapper = null;
        }
        return mapper;
    }

    public IPath getSourceAttachmentPath() throws CoreException {
        IPath sourceAttachmentPath;
        if (this.getKind() != 2) {
            return null;
        }
        IPath path = this.getPath();
        String serverPathString = PackageFragmentRoot.getSourceAttachmentProperty(path);
        if (serverPathString != null) {
            int index = serverPathString.lastIndexOf(42);
            if (index < 0) {
                return new Path(serverPathString);
            }
            String serverSourcePathString = serverPathString.substring(0, index);
            return new Path(serverSourcePathString);
        }
        IEGLPathEntry entry = ((EGLProject)this.getParent()).getEGLPathEntryFor(path);
        if (entry != null && (sourceAttachmentPath = entry.getSourceAttachmentPath()) != null) {
            return sourceAttachmentPath;
        }
        entry = this.findSourceAttachmentRecommendation();
        if (entry != null && (sourceAttachmentPath = entry.getSourceAttachmentPath()) != null) {
            return sourceAttachmentPath;
        }
        return null;
    }

    private IEGLPathEntry findSourceAttachmentRecommendation() {
        try {
            IEGLPathEntry entry;
            IPath rootPath = this.getPath();
            EGLProject parentProject = (EGLProject)this.getEGLProject();
            try {
                Object target;
                entry = parentProject.getEGLPathEntryFor(rootPath);
                if (entry != null && (target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), entry.getSourceAttachmentPath(), true)) != null) {
                    return entry;
                }
            }
            catch (EGLModelException eGLModelException) {}
            IEGLModel model = this.getEGLModel();
            IEGLProject[] eglProjects = model.getEGLProjects();
            int i = 0;
            int max = eglProjects.length;
            while (i < max) {
                EGLProject eglProject = (EGLProject)eglProjects[i];
                if (eglProject != parentProject) {
                    try {
                        Object target;
                        entry = eglProject.getEGLPathEntryFor(rootPath);
                        if (entry != null && (target = EGLModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), entry.getSourceAttachmentPath(), true)) != null) {
                            return entry;
                        }
                    }
                    catch (EGLModelException eGLModelException) {}
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
        return null;
    }

    public static String getSourceAttachmentProperty(IPath path) throws CoreException {
        Map rootPathToAttachments = EGLModelManager.getEGLModelManager().rootPathToAttachments;
        String property = (String)rootPathToAttachments.get(path);
        if (property == null) {
            property = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(PackageFragmentRoot.getSourceAttachmentPropertyName(path));
            if (property == null) {
                rootPathToAttachments.put(path, NO_SOURCE_ATTACHMENT);
                return null;
            }
            rootPathToAttachments.put(path, property);
            return property;
        }
        if (property.equals(NO_SOURCE_ATTACHMENT)) {
            return null;
        }
        return property;
    }

    private static QualifiedName getSourceAttachmentPropertyName(IPath path) {
        return new QualifiedName(EGLCore.PLUGIN_ID, "sourceattachment: " + path.toOSString());
    }

    public IPath getSourceAttachmentRootPath() throws CoreException {
        IPath sourceAttachmentRootPath;
        if (this.getKind() != 2) {
            return null;
        }
        IPath path = this.getPath();
        String serverPathString = PackageFragmentRoot.getSourceAttachmentProperty(path);
        if (serverPathString != null) {
            int index = serverPathString.lastIndexOf(42);
            if (index == -1) {
                return null;
            }
            String serverRootPathString = NO_SOURCE_ATTACHMENT;
            if (index != serverPathString.length() - 1) {
                serverRootPathString = serverPathString.substring(index + 1);
            }
            return new Path(serverRootPathString);
        }
        IEGLPathEntry entry = ((EGLProject)this.getParent()).getEGLPathEntryFor(path);
        if (entry != null && (sourceAttachmentRootPath = entry.getSourceAttachmentRootPath()) != null) {
            return sourceAttachmentRootPath;
        }
        entry = this.findSourceAttachmentRecommendation();
        if (entry != null && (sourceAttachmentRootPath = entry.getSourceAttachmentRootPath()) != null) {
            return sourceAttachmentRootPath;
        }
        return null;
    }

    SourceMapper createSourceMapper(IPath sourcePath, IPath rootPath) {
        SourceMapper mapper = new SourceMapper(sourcePath, rootPath == null ? null : rootPath.toOSString(), this.getEGLProject().getOptions(true));
        return mapper;
    }
}

