/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.edt.ide.core.internal.model.index.IIndex;
import org.eclipse.edt.ide.core.internal.model.indexing.EGLReadWriteMonitor;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexManager;
import org.eclipse.edt.ide.core.internal.model.indexing.IndexRequest;
import org.eclipse.edt.ide.core.internal.model.search.processing.JobManager;

abstract class AddFileToIndex
extends IndexRequest {
    IFile resource;

    public AddFileToIndex(IFile resource, IPath indexPath, IndexManager manager) {
        super(indexPath, manager);
        this.resource = resource;
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        IIndex index = this.manager.getIndex(this.indexPath, true, true);
        if (index == null) {
            return true;
        }
        EGLReadWriteMonitor monitor = this.manager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterWrite();
            if (!this.indexDocument(index)) {
                return false;
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> failed to index " + this.resource + " because of the following exception:");
                e.printStackTrace();
            }
            return false;
        }
        finally {
            monitor.exitWrite();
        }
        return true;
    }

    protected abstract boolean indexDocument(IIndex var1) throws IOException;

    public String toString() {
        return "indexing " + this.resource.getFullPath();
    }
}

