/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.generators;

import org.eclipse.edt.gen.deployment.util.CommonUtilities;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.Parameter;

public class DeploymentDescUtil {
    private static final String indent1 = "    ";
    private static final String indent2 = "        ";
    private static final String indent3 = "            ";
    private static final String indent4 = "                ";

    public static String convertToBindXML(DeploymentDesc desc) {
        StringBuffer buf = new StringBuffer();
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buf.append("<egldd>\n");
        buf.append(indent1);
        buf.append("<bindings>\n");
        for (Binding binding : desc.getBindings()) {
            buf.append(DeploymentDescUtil.toBindXML(binding));
        }
        buf.append(indent1);
        buf.append("</bindings>\n");
        buf.append(indent1);
        buf.append("<includes>\n");
        for (String include : desc.getIncludes()) {
            buf.append(DeploymentDescUtil.toIncludeXML(include));
        }
        buf.append(indent1);
        buf.append("</includes>\n");
        buf.append("</egldd>\n");
        return buf.toString();
    }

    public static String toBindXML(Binding binding) {
        StringBuilder builder = new StringBuilder(indent2);
        builder.append("<binding name=\"");
        if (binding.getName() != null) {
            builder.append(binding.getName());
        }
        builder.append("\"");
        if (binding.getType() != null) {
            builder.append(" type=\"").append(binding.getType());
            builder.append("\"");
        }
        if (binding.getUri() != null) {
            builder.append(" uri=\"").append(binding.getUri());
            builder.append("\"");
        }
        builder.append(" useURI=\"").append(String.valueOf(binding.isUseURI()));
        builder.append("\">\n");
        builder.append(indent3);
        builder.append("<parameters>\n");
        for (Parameter parameter : binding.getParameters()) {
            builder.append(DeploymentDescUtil.toBindXML(parameter));
        }
        builder.append(indent3);
        builder.append("</parameters>\n");
        builder.append(indent2);
        builder.append("</binding>\n");
        return builder.toString();
    }

    public static String toBindXML(Parameter parameter) {
        StringBuilder builder = new StringBuilder(indent4);
        builder.append("<parameter name=\"");
        if (parameter.getName() != null) {
            builder.append(parameter.getName());
        }
        builder.append("\"");
        if (parameter.getType() != null) {
            builder.append(" type=\"");
            builder.append(parameter.getType());
            builder.append("\"");
        }
        if (parameter.getValue() != null) {
            builder.append(" value=\"").append(parameter.getValue());
            builder.append("\"");
        }
        builder.append("/>\n");
        return builder.toString();
    }

    public static String toIncludeXML(String include) {
        StringBuilder builder = new StringBuilder(indent2);
        builder.append("<include location=\"");
        builder.append(String.valueOf(CommonUtilities.toIncludeDDName((String)include)) + "\"");
        builder.append("/>\n");
        return builder.toString();
    }
}

