/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.CompoundExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.ConcurrentFixedCache;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.parsing.JPQLParseTree;
import org.eclipse.persistence.internal.jpa.parsing.jpql.JPQLParser;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DoesExistQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.UpdateObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.changesets.ChangeRecord;

public class DescriptorQueryManager
implements Cloneable,
Serializable {
    protected transient InsertObjectQuery insertQuery;
    protected transient UpdateObjectQuery updateQuery;
    protected transient ReadObjectQuery readObjectQuery;
    protected transient ReadAllQuery readAllQuery;
    protected transient DeleteObjectQuery deleteQuery;
    protected DoesExistQuery doesExistQuery;
    protected ClassDescriptor descriptor;
    protected boolean includeTenantCriteria = true;
    protected boolean hasCustomMultipleTableJoinExpression;
    protected transient String additionalCriteria;
    protected transient Expression additionalJoinExpression;
    protected transient Expression multipleTableJoinExpression;
    protected transient Map queries = new LinkedHashMap(5);
    protected transient Map tablesJoinExpressions;
    protected transient ConcurrentFixedCache cachedUpdateCalls = new ConcurrentFixedCache(10);
    protected transient ConcurrentFixedCache cachedExpressionQueries = new ConcurrentFixedCache(20);
    public static final int NoTimeout = 0;
    public static final int DefaultTimeout = -1;
    protected int queryTimeout;

    public DescriptorQueryManager() {
        this.setDoesExistQuery(new DoesExistQuery());
        this.setQueryTimeout(-1);
    }

    public void setExpressionQueryCacheMaxSize(int maxSize) {
        this.cachedExpressionQueries = new ConcurrentFixedCache(maxSize);
    }

    public int getExpressionQueryCacheMaxSize() {
        return this.cachedExpressionQueries.getMaxSize();
    }

    public void addQuery(String name, DatabaseQuery query) {
        query.setName(name);
        this.addQuery(query);
    }

    public synchronized void addQuery(DatabaseQuery query) {
        Vector queriesByName;
        if (query instanceof ObjectLevelReadQuery && ((ObjectLevelReadQuery)query).getReferenceClassName() == null) {
            ((ObjectLevelReadQuery)query).setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                ((ObjectLevelReadQuery)query).setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException exception) {
                // empty catch block
            }
            query.setDescriptor(this.getDescriptor());
        }
        if ((queriesByName = (Vector)this.getQueries().get(query.getName())) == null) {
            queriesByName = NonSynchronizedVector.newInstance();
            this.getQueries().put(query.getName(), queriesByName);
        } else {
            int i;
            int argumentTypesSize = 0;
            if (query.getArguments() != null) {
                argumentTypesSize = query.getArguments().size();
            }
            ArrayList<String> argumentTypes = new ArrayList<String>(argumentTypesSize);
            for (i = 0; i < argumentTypesSize; ++i) {
                argumentTypes.add(query.getArgumentTypeNames().get(i));
            }
            for (i = 0; i < queriesByName.size(); ++i) {
                DatabaseQuery currentQuery = (DatabaseQuery)queriesByName.get(i);
                if (!((Object)argumentTypes).equals(currentQuery.getArgumentTypeNames())) continue;
                queriesByName.set(i, query);
                return;
            }
        }
        queriesByName.add(query);
    }

    public void assumeExistenceForDoesExist() {
        this.getDoesExistQuery().assumeExistenceForDoesExist();
    }

    public void assumeNonExistenceForDoesExist() {
        this.getDoesExistQuery().assumeNonExistenceForDoesExist();
    }

    public void checkCacheForDoesExist() {
        this.getDoesExistQuery().checkCacheForDoesExist();
    }

    public void checkDatabaseForDoesExist() {
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public Object clone() {
        DescriptorQueryManager manager = null;
        try {
            manager = (DescriptorQueryManager)super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.setQueries(new LinkedHashMap(this.getQueries().size()));
        Iterator iterator = this.queries.values().iterator();
        while (iterator.hasNext()) {
            for (DatabaseQuery initialQuery : (Vector)iterator.next()) {
                DatabaseQuery clonedQuery = (DatabaseQuery)initialQuery.clone();
                clonedQuery.setDescriptor(manager.getDescriptor());
                manager.addQuery(clonedQuery);
            }
        }
        manager.setDoesExistQuery((DoesExistQuery)this.getDoesExistQuery().clone());
        if (this.getReadAllQuery() != null) {
            manager.setReadAllQuery((ReadAllQuery)this.getReadAllQuery().clone());
        }
        if (this.getReadObjectQuery() != null) {
            manager.setReadObjectQuery((ReadObjectQuery)this.getReadObjectQuery().clone());
        }
        if (this.getUpdateQuery() != null) {
            manager.setUpdateQuery((UpdateObjectQuery)this.getUpdateQuery().clone());
        }
        if (this.getInsertQuery() != null) {
            manager.setInsertQuery((InsertObjectQuery)this.getInsertQuery().clone());
        }
        if (this.getDeleteQuery() != null) {
            manager.setDeleteQuery((DeleteObjectQuery)this.getDeleteQuery().clone());
        }
        return manager;
    }

    public boolean containsQuery(String queryName) {
        return this.queries.containsKey(queryName);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Iterator queryVectors = this.getQueries().values().iterator();
        while (queryVectors.hasNext()) {
            Iterator queries = ((Vector)queryVectors.next()).iterator();
            while (queries.hasNext()) {
                ((DatabaseQuery)queries.next()).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.getReadObjectQuery() != null) {
            this.getReadObjectQuery().convertClassNamesToClasses(classLoader);
        }
        if (this.getReadAllQuery() != null) {
            this.getReadAllQuery().convertClassNamesToClasses(classLoader);
        }
    }

    public Expression getAdditionalJoinExpression() {
        return this.additionalJoinExpression;
    }

    public DeleteObjectQuery getDeleteQuery() {
        return this.deleteQuery;
    }

    public String getDeleteSQLString() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getSQLString();
    }

    protected ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public DoesExistQuery getDoesExistQuery() {
        return this.doesExistQuery;
    }

    public String getDoesExistSQLString() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getSQLString();
    }

    public String getExistenceCheck() {
        if (this.getDoesExistQuery().shouldAssumeExistenceForDoesExist()) {
            return "Assume existence";
        }
        if (this.getDoesExistQuery().shouldAssumeNonExistenceForDoesExist()) {
            return "Assume non-existence";
        }
        if (this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            return "Check cache";
        }
        if (this.getDoesExistQuery().shouldCheckDatabaseForDoesExist()) {
            return "Check database";
        }
        return "Check cache";
    }

    public InsertObjectQuery getInsertQuery() {
        return this.insertQuery;
    }

    public String getInsertSQLString() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getSQLString();
    }

    public Expression getMultipleTableJoinExpression() {
        return this.multipleTableJoinExpression;
    }

    public Map getQueries() {
        return this.queries;
    }

    public Vector getAllQueries() {
        Vector allQueries = new Vector();
        Iterator vectors = this.getQueries().values().iterator();
        while (vectors.hasNext()) {
            allQueries.addAll((Vector)vectors.next());
        }
        return allQueries;
    }

    public void setAllQueries(Vector vector) {
        Enumeration enumtr = vector.elements();
        while (enumtr.hasMoreElements()) {
            this.addQuery((DatabaseQuery)enumtr.nextElement());
        }
    }

    public void setQueries(Map map) {
        this.queries = map;
    }

    public DatabaseQuery getQuery(String queryName) {
        return this.getQuery(queryName, null);
    }

    public DatabaseQuery getQuery(String name, Vector arguments) {
        DatabaseQuery query = this.getLocalQuery(name, arguments);
        if (query == null) {
            DatabaseQuery parentQuery = this.getQueryFromParent(name, arguments);
            if (parentQuery != null && parentQuery.isReadQuery()) {
                parentQuery = (DatabaseQuery)parentQuery.clone();
                ((ObjectLevelReadQuery)parentQuery).setReferenceClass(this.descriptor.getJavaClass());
                this.addQuery(name, parentQuery);
            }
            return parentQuery;
        }
        return query;
    }

    public DatabaseQuery getLocalQuery(String name, Vector arguments) {
        Vector queries = (Vector)this.getQueries().get(name);
        if (queries == null) {
            return null;
        }
        if (queries.size() == 1) {
            return (DatabaseQuery)queries.firstElement();
        }
        int argumentTypesSize = 0;
        if (arguments != null) {
            argumentTypesSize = arguments.size();
        }
        NonSynchronizedVector argumentTypes = NonSynchronizedVector.newInstance(argumentTypesSize);
        for (int i = 0; i < argumentTypesSize; ++i) {
            ((Vector)argumentTypes).addElement(arguments.elementAt(i).getClass());
        }
        return this.getLocalQueryByArgumentTypes(name, argumentTypes);
    }

    public DatabaseQuery getLocalQueryByArgumentTypes(String name, List argumentTypes) {
        List queries = (List)this.getQueries().get(name);
        if (queries == null) {
            return null;
        }
        if (queries.size() == 1) {
            return (DatabaseQuery)queries.get(0);
        }
        for (DatabaseQuery query : queries) {
            if (!Helper.areTypesAssignable(query.getArgumentTypes(), argumentTypes)) continue;
            return query;
        }
        return null;
    }

    protected DatabaseQuery getQueryFromParent(String name, Vector arguments) {
        InheritancePolicy inheritancePolicy;
        ClassDescriptor parent;
        ClassDescriptor descriptor = this.descriptor;
        if (descriptor.hasInheritance() && (parent = (inheritancePolicy = descriptor.getInheritancePolicy()).getParentDescriptor()) != null) {
            return parent.getQueryManager().getQuery(name, arguments);
        }
        return null;
    }

    public ReadAllQuery getReadAllQuery() {
        return this.readAllQuery;
    }

    public String getReadAllSQLString() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getSQLString();
    }

    public ReadObjectQuery getReadObjectQuery() {
        return this.readObjectQuery;
    }

    public String getReadObjectSQLString() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getSQLString();
    }

    public UpdateObjectQuery getUpdateQuery() {
        return this.updateQuery;
    }

    public String getUpdateSQLString() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getSQLString();
    }

    public boolean hasAdditionalCriteria() {
        return this.additionalCriteria != null;
    }

    public boolean hasCustomMultipleTableJoinExpression() {
        return this.hasCustomMultipleTableJoinExpression;
    }

    public boolean hasDeleteQuery() {
        return this.deleteQuery != null;
    }

    public boolean hasDoesExistQuery() {
        return this.doesExistQuery != null;
    }

    public boolean hasInsertQuery() {
        return this.insertQuery != null;
    }

    public boolean hasReadAllQuery() {
        return this.readAllQuery != null;
    }

    public boolean hasReadObjectQuery() {
        return this.readObjectQuery != null;
    }

    public boolean hasUpdateQuery() {
        return this.updateQuery != null;
    }

    private void populateQueries() {
        if (this.getInsertQuery() != null) {
            this.getInsertQuery().setDescriptor(this.descriptor);
        }
        if (this.getUpdateQuery() != null) {
            this.getUpdateQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadObjectQuery() != null) {
            this.getReadObjectQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadObjectQuery().setDescriptor(this.descriptor);
        }
        if (this.getDeleteQuery() != null) {
            this.getDeleteQuery().setDescriptor(this.descriptor);
        }
        if (this.getReadAllQuery() != null) {
            this.getReadAllQuery().setReferenceClass(this.getDescriptor().getJavaClass());
            this.getReadAllQuery().setDescriptor(this.descriptor);
        }
        Iterator it = this.getAllQueries().iterator();
        while (it.hasNext()) {
            ((DatabaseQuery)it.next()).setDescriptor(this.descriptor);
        }
    }

    public boolean includeTenantCriteria() {
        return this.includeTenantCriteria;
    }

    public void initialize(AbstractSession session) {
        this.initializeQueryTimeout(session);
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getMultipleTableJoinExpression() != null) {
            this.setAdditionalJoinExpression(this.getMultipleTableJoinExpression().and(this.getAdditionalJoinExpression()));
        }
        if (this.getDescriptor().isAggregateCollectionDescriptor()) {
            return;
        }
        if (!this.hasReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            this.setReadObjectQuery(readObjectQuery);
        }
        this.getReadObjectQuery().setName("readObject");
        if (!this.hasInsertQuery()) {
            this.setInsertQuery(new InsertObjectQuery());
        }
        this.getInsertQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateInsertRow(session));
        if (!this.getDescriptor().usesFieldLocking()) {
            if (!this.hasDeleteQuery()) {
                this.setDeleteQuery(new DeleteObjectQuery());
            }
            this.getDeleteQuery().setModifyRow(new DatabaseRecord());
        }
        if (this.hasUpdateQuery()) {
            this.getUpdateQuery().setModifyRow(this.getDescriptor().getObjectBuilder().buildTemplateUpdateRow(session));
        }
    }

    public void initializeQueryTimeout(AbstractSession session) {
        if (this.getQueryTimeout() == -1 && this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().getParentDescriptor() != null) {
            this.setQueryTimeout(this.getParentDescriptorQueryManager().getQueryTimeout());
        }
        if (this.getQueryTimeout() == -1) {
            this.setQueryTimeout(0);
        }
    }

    public DescriptorQueryManager getParentDescriptorQueryManager() {
        return this.descriptor.getInheritancePolicy().getParentDescriptor().getQueryManager();
    }

    public void postDelete(DeleteObjectQuery query) {
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        if (!builder.isSimple()) {
            List<DatabaseMapping> mappings = builder.getRelationshipMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                mappings.get(index).postDelete(query);
            }
        }
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        if (this.additionalCriteria != null || this.descriptor.hasTenantDiscriminatorFields()) {
            if (this.additionalCriteria != null) {
                if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasView()) {
                    throw DescriptorException.additionalCriteriaNotSupportedWithInheritanceViews(this.getDescriptor());
                }
                String jpql = "select this from " + this.descriptor.getAlias() + " this where " + this.additionalCriteria.trim();
                JPQLParseTree parseTree = JPQLParser.buildParseTree(jpql);
                parseTree.setClassLoader(session.getLoader());
                DatabaseQuery databaseQuery = parseTree.createDatabaseQuery();
                databaseQuery.setJPQLString(jpql);
                parseTree.populateQuery(databaseQuery, session);
                parseTree.addParametersToQuery(databaseQuery);
                this.updatePropertyParameterExpression(databaseQuery.getSelectionCriteria());
                this.additionalJoinExpression = databaseQuery.getSelectionCriteria().and(this.additionalJoinExpression);
            }
            if (this.descriptor.hasTenantDiscriminatorFields() && this.includeTenantCriteria) {
                ExpressionBuilder builder = new ExpressionBuilder();
                for (DatabaseField discriminatorField : this.descriptor.getTenantDiscriminatorFields().keySet()) {
                    String property = this.descriptor.getTenantDiscriminatorFields().get(discriminatorField);
                    DatabaseField newField = new DatabaseField();
                    newField.setName(property, session.getPlatform());
                    Expression tenantIdExpression = builder.and(builder.getField(discriminatorField).equal(builder.getProperty(newField)));
                    if (this.additionalJoinExpression == null) {
                        this.additionalJoinExpression = tenantIdExpression;
                        continue;
                    }
                    this.additionalJoinExpression = this.additionalJoinExpression.and(tenantIdExpression);
                }
            }
            if (this.additionalJoinExpression != null) {
                this.additionalJoinExpression = this.additionalJoinExpression.rebuildOn(new ExpressionBuilder());
            }
        }
    }

    protected void updatePropertyParameterExpression(Expression exp) {
        if (exp.isCompoundExpression()) {
            this.updatePropertyParameterExpression(((CompoundExpression)exp).getFirstChild());
            this.updatePropertyParameterExpression(((CompoundExpression)exp).getSecondChild());
        } else if (exp.isFunctionExpression()) {
            for (Expression e : ((FunctionExpression)exp).getChildren()) {
                this.updatePropertyParameterExpression(e);
            }
        } else if (exp.isSubSelectExpression()) {
            ReportQuery subSelectQuery = ((SubSelectExpression)exp).getSubQuery();
            for (ReportItem item : subSelectQuery.getItems()) {
                this.updatePropertyParameterExpression(item.getAttributeExpression());
            }
        }
        if (exp.isParameterExpression()) {
            ((ParameterExpression)exp).setIsProperty(true);
        }
    }

    public void postInsert(WriteObjectQuery query) {
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        if (!builder.isSimple()) {
            List<DatabaseMapping> mappings = builder.getRelationshipMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                mappings.get(index).postInsert(query);
            }
        }
    }

    public void postUpdate(WriteObjectQuery query) {
        block4: {
            ObjectBuilder builder = this.descriptor.getObjectBuilder();
            if (builder.isSimple()) break block4;
            ObjectChangeSet changeSet = query.getObjectChangeSet();
            if (changeSet != null && !changeSet.isNew()) {
                List<ChangeRecord> changeRecords = changeSet.getChanges();
                int size = changeRecords.size();
                for (int index = 0; index < size; ++index) {
                    org.eclipse.persistence.internal.sessions.ChangeRecord record = (org.eclipse.persistence.internal.sessions.ChangeRecord)changeRecords.get(index);
                    record.getMapping().postUpdate(query);
                }
            } else {
                List<DatabaseMapping> mappings = builder.getRelationshipMappings();
                int size = mappings.size();
                for (int index = 0; index < size; ++index) {
                    mappings.get(index).postUpdate(query);
                }
            }
        }
    }

    public void preDelete(DeleteObjectQuery query) {
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        if (!builder.isSimple()) {
            List<DatabaseMapping> mappings = builder.getRelationshipMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                mappings.get(index).preDelete(query);
            }
        }
    }

    public void preInitialize(AbstractSession session) {
        if (this.getDescriptor().isAggregateDescriptor()) {
            return;
        }
        if (this.getDescriptor().isChildDescriptor()) {
            DescriptorQueryManager parentQueryManager = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getQueryManager();
            if (!this.hasInsertQuery() && parentQueryManager.hasInsertQuery()) {
                this.setInsertQuery((InsertObjectQuery)parentQueryManager.getInsertQuery().clone());
            }
            if (!this.hasUpdateQuery() && parentQueryManager.hasUpdateQuery()) {
                this.setUpdateQuery((UpdateObjectQuery)parentQueryManager.getUpdateQuery().clone());
            }
            if (!this.hasDeleteQuery() && parentQueryManager.hasDeleteQuery()) {
                this.setDeleteQuery((DeleteObjectQuery)parentQueryManager.getDeleteQuery().clone());
            }
            if (!this.hasReadObjectQuery() && parentQueryManager.hasReadObjectQuery()) {
                this.setReadObjectQuery((ReadObjectQuery)parentQueryManager.getReadObjectQuery().clone());
            }
            if (!this.hasReadAllQuery() && parentQueryManager.hasReadAllQuery()) {
                this.setReadAllQuery((ReadAllQuery)parentQueryManager.getReadAllQuery().clone());
            }
            if (!this.getDoesExistQuery().isUserDefined() && this.getDoesExistQuery().shouldCheckCacheForDoesExist()) {
                this.setDoesExistQuery((DoesExistQuery)parentQueryManager.getDoesExistQuery().clone());
            }
        }
    }

    public void preInsert(WriteObjectQuery query) {
        ObjectBuilder builder = this.descriptor.getObjectBuilder();
        if (!builder.isSimple()) {
            List<DatabaseMapping> mappings = builder.getRelationshipMappings();
            int size = mappings.size();
            for (int index = 0; index < size; ++index) {
                mappings.get(index).preInsert(query);
            }
        }
    }

    public void preUpdate(WriteObjectQuery query) {
        block4: {
            ObjectBuilder builder = this.descriptor.getObjectBuilder();
            if (builder.isSimple()) break block4;
            ObjectChangeSet changeSet = query.getObjectChangeSet();
            if (changeSet != null && !changeSet.isNew()) {
                List<ChangeRecord> changeRecords = changeSet.getChanges();
                int size = changeRecords.size();
                for (int index = 0; index < size; ++index) {
                    org.eclipse.persistence.internal.sessions.ChangeRecord record = (org.eclipse.persistence.internal.sessions.ChangeRecord)changeRecords.get(index);
                    record.getMapping().preUpdate(query);
                }
            } else {
                List<DatabaseMapping> mappings = builder.getRelationshipMappings();
                int size = mappings.size();
                for (int index = 0; index < size; ++index) {
                    mappings.get(index).preUpdate(query);
                }
            }
        }
    }

    public void removeQuery(String queryName) {
        this.queries.remove(queryName);
    }

    public void removeQuery(String queryName, Vector argumentTypes) {
        Vector queries = (Vector)this.getQueries().get(queryName);
        if (queries == null) {
            return;
        }
        DatabaseQuery query = null;
        Enumeration enumtr = queries.elements();
        while (enumtr.hasMoreElements() && !Helper.areTypesAssignable(argumentTypes, (query = (DatabaseQuery)enumtr.nextElement()).getArgumentTypes())) {
        }
        if (query != null) {
            queries.remove(query);
        }
    }

    public void setAdditionalCriteria(String additionalCriteria) {
        this.additionalCriteria = additionalCriteria;
    }

    public void setAdditionalJoinExpression(Expression additionalJoinExpression) {
        this.additionalJoinExpression = additionalJoinExpression;
    }

    public void setDeleteQuery(DeleteObjectQuery query) {
        this.deleteQuery = query;
        if (query == null) {
            return;
        }
        query.setIsUserDefined(true);
        query.setDescriptor(this.getDescriptor());
        if (query.isCallQuery()) {
            query.setIsFullRowRequired(true);
        }
    }

    public void setDeleteSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setSQLString(sqlString);
        this.setDeleteQuery(query);
    }

    public void setDeleteCall(Call call) {
        if (call == null) {
            return;
        }
        DeleteObjectQuery query = new DeleteObjectQuery();
        query.setCall(call);
        this.setDeleteQuery(query);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
        this.populateQueries();
    }

    public void setDoesExistQuery(DoesExistQuery query) {
        this.doesExistQuery = query;
        if (query == null) {
            return;
        }
        this.doesExistQuery.setIsUserDefined(true);
        this.doesExistQuery.setDescriptor(this.getDescriptor());
    }

    public void setDoesExistSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        this.getDoesExistQuery().setSQLString(sqlString);
        this.getDoesExistQuery().checkDatabaseForDoesExist();
    }

    public void setDoesExistCall(Call call) {
        if (call == null) {
            return;
        }
        this.getDoesExistQuery().setCall(call);
    }

    public void setExistenceCheck(String token) throws DescriptorException {
        if (token.equals("Check cache")) {
            this.checkCacheForDoesExist();
        } else if (token.equals("Check database")) {
            this.checkDatabaseForDoesExist();
        } else if (token.equals("Assume existence")) {
            this.assumeExistenceForDoesExist();
        } else if (token.equals("Assume non-existence")) {
            this.assumeNonExistenceForDoesExist();
        } else {
            throw DescriptorException.setExistenceCheckingNotUnderstood(token, this.getDescriptor());
        }
    }

    protected void setHasCustomMultipleTableJoinExpression(boolean hasCustomMultipleTableJoinExpression) {
        this.hasCustomMultipleTableJoinExpression = hasCustomMultipleTableJoinExpression;
    }

    public void setInsertQuery(InsertObjectQuery insertQuery) {
        this.insertQuery = insertQuery;
        if (insertQuery == null) {
            return;
        }
        this.insertQuery.setIsUserDefined(true);
        this.insertQuery.setDescriptor(this.getDescriptor());
    }

    public void setIncludeTenantCriteria(boolean includeTenantCriteria) {
        this.includeTenantCriteria = includeTenantCriteria;
    }

    public void setInsertCall(Call call) {
        if (call == null) {
            return;
        }
        InsertObjectQuery query = new InsertObjectQuery();
        query.setCall(call);
        this.setInsertQuery(query);
    }

    public void setInsertSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        InsertObjectQuery query = new InsertObjectQuery();
        query.setSQLString(sqlString);
        this.setInsertQuery(query);
    }

    public Call getInsertCall() {
        if (this.getInsertQuery() == null) {
            return null;
        }
        return this.getInsertQuery().getDatasourceCall();
    }

    public Call getUpdateCall() {
        if (this.getUpdateQuery() == null) {
            return null;
        }
        return this.getUpdateQuery().getDatasourceCall();
    }

    public Call getDeleteCall() {
        if (this.getDeleteQuery() == null) {
            return null;
        }
        return this.getDeleteQuery().getDatasourceCall();
    }

    public Call getReadObjectCall() {
        if (this.getReadObjectQuery() == null) {
            return null;
        }
        return this.getReadObjectQuery().getDatasourceCall();
    }

    public Call getReadAllCall() {
        if (this.getReadAllQuery() == null) {
            return null;
        }
        return this.getReadAllQuery().getDatasourceCall();
    }

    public Call getDoesExistCall() {
        if (this.getDoesExistQuery() == null) {
            return null;
        }
        return this.getDoesExistQuery().getDatasourceCall();
    }

    public Map getTablesJoinExpressions() {
        if (this.tablesJoinExpressions == null) {
            this.tablesJoinExpressions = new HashMap();
        }
        return this.tablesJoinExpressions;
    }

    public void setInternalMultipleTableJoinExpression(Expression multipleTableJoinExpression) {
        this.multipleTableJoinExpression = multipleTableJoinExpression;
    }

    public void setMultipleTableJoinExpression(Expression multipleTableJoinExpression) {
        this.multipleTableJoinExpression = multipleTableJoinExpression;
        this.setHasCustomMultipleTableJoinExpression(true);
    }

    public void setReadAllQuery(ReadAllQuery query) {
        this.readAllQuery = query;
        if (query == null) {
            return;
        }
        this.readAllQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readAllQuery.setDescriptor(this.getDescriptor());
            this.readAllQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readAllQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadAllSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        ReadAllQuery query = new ReadAllQuery();
        query.setSQLString(sqlString);
        this.setReadAllQuery(query);
    }

    public void setReadAllCall(Call call) {
        if (call == null) {
            return;
        }
        ReadAllQuery query = new ReadAllQuery();
        query.setCall(call);
        this.setReadAllQuery(query);
    }

    public void setReadObjectQuery(ReadObjectQuery query) {
        this.readObjectQuery = query;
        if (query == null) {
            return;
        }
        this.readObjectQuery.setIsUserDefined(true);
        if (this.getDescriptor() != null) {
            this.readObjectQuery.setDescriptor(this.getDescriptor());
            this.readObjectQuery.setReferenceClassName(this.getDescriptor().getJavaClassName());
            try {
                this.readObjectQuery.setReferenceClass(this.getDescriptor().getJavaClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
        }
    }

    public void setReadObjectSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setSQLString(sqlString);
        this.setReadObjectQuery(query);
    }

    public void setReadObjectCall(Call call) {
        if (call == null) {
            return;
        }
        ReadObjectQuery query = new ReadObjectQuery();
        query.setCall(call);
        this.setReadObjectQuery(query);
    }

    public void setUpdateQuery(UpdateObjectQuery updateQuery) {
        this.updateQuery = updateQuery;
        if (updateQuery == null) {
            return;
        }
        this.updateQuery.setIsUserDefined(true);
        this.updateQuery.setDescriptor(this.getDescriptor());
    }

    public void setUpdateSQLString(String sqlString) {
        if (sqlString == null) {
            return;
        }
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setSQLString(sqlString);
        this.setUpdateQuery(query);
    }

    public void setUpdateCall(Call call) {
        if (call == null) {
            return;
        }
        UpdateObjectQuery query = new UpdateObjectQuery();
        query.setCall(call);
        this.setUpdateQuery(query);
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getUpdateCallCacheSize() {
        return this.cachedUpdateCalls.getMaxSize();
    }

    public void setUpdateCallCacheSize(int updateCallCacheSize) {
        this.cachedUpdateCalls.setMaxSize(updateCallCacheSize);
    }

    public Vector getCachedUpdateCalls(Vector updateFields) {
        return (Vector)this.cachedUpdateCalls.get(updateFields);
    }

    public void putCachedUpdateCalls(Vector updateFields, Vector updateCalls) {
        Vector vectorToCache = updateCalls;
        if (!updateCalls.isEmpty()) {
            int updateCallsSize = updateCalls.size();
            vectorToCache = new NonSynchronizedVector(updateCallsSize);
            for (int i = 0; i < updateCallsSize; ++i) {
                DatasourceCall updateCall = (DatasourceCall)updateCalls.get(i);
                DatasourceCall clonedUpdateCall = (DatasourceCall)updateCall.clone();
                clonedUpdateCall.setQuery(null);
                vectorToCache.add(clonedUpdateCall);
            }
        }
        this.cachedUpdateCalls.put(updateFields, vectorToCache);
    }

    public DatabaseQuery getCachedExpressionQuery(DatabaseQuery query) {
        return (DatabaseQuery)this.cachedExpressionQueries.get(query);
    }

    public void putCachedExpressionQuery(DatabaseQuery query) {
        this.cachedExpressionQueries.put(query, query);
    }
}

