/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.eis.mappings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.mappings.EISMapping;
import org.eclipse.persistence.eis.mappings.EISOneToManyMappingHelper;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.EISOneToManyQueryBasedValueHolder;
import org.eclipse.persistence.internal.oxm.XPathEngine;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.w3c.dom.Element;

public class EISOneToManyMapping
extends CollectionMapping
implements EISMapping {
    protected boolean isForeignKeyRelationship = false;
    protected transient List targetForeignKeyFields;
    protected transient List sourceForeignKeyFields = new ArrayList(1);
    protected transient Map sourceForeignKeysToTargetKeys;
    protected XMLField foreignKeyGroupingElement;

    public EISOneToManyMapping() {
        this.targetForeignKeyFields = new ArrayList(1);
        this.sourceForeignKeysToTargetKeys = new HashMap(2);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    public boolean isEISMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField sourceForeignKeyField, DatabaseField targetKeyField) {
        this.getSourceForeignKeyFields().add(sourceForeignKeyField);
        this.getTargetForeignKeyFields().add(targetKeyField);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String sourceForeignKeyFieldName, String targetKeyFieldName) {
        this.addForeignKeyField(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetKeyFieldName));
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean isForeignKeyRelationship) {
        this.isForeignKeyRelationship = isForeignKeyRelationship;
    }

    public XMLField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public void setForeignKeyGroupingElement(String xpath) {
        this.setForeignKeyGroupingElement(new XMLField(xpath));
    }

    public boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    public void setDeleteAllCall(Call call) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setCall(call);
        this.setDeleteAllQuery(deleteAllQuery);
        this.setHasCustomDeleteAllQuery(true);
    }

    public void setForeignKeyGroupingElement(XMLField field) {
        this.foreignKeyGroupingElement = field;
    }

    public List getSourceForeignKeyFields() {
        return this.sourceForeignKeyFields;
    }

    public void setSourceForeignKeyFields(List fields) {
        this.sourceForeignKeyFields = fields;
        if (fields != null && fields.size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public List getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public void setTargetForeignKeyFields(List fields) {
        this.targetForeignKeyFields = fields;
    }

    public Map getSourceForeignKeysToTargetKeys() {
        return this.sourceForeignKeysToTargetKeys;
    }

    public void setSourceForeignKeysToTargetKeys(Map sourceToTargetKeyFields) {
        this.sourceForeignKeysToTargetKeys = sourceToTargetKeyFields;
        if (sourceToTargetKeyFields != null && sourceToTargetKeyFields.keySet() != null && sourceToTargetKeyFields.keySet().size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean hasInverseConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (!this.hasCustomSelectionQuery()) {
            throw DescriptorException.operationNotSupported("customSelectionQueryRequired");
        }
        if (this.getForeignKeyGroupingElement() == null && this.getSourceForeignKeysToTargetKeys().size() > 1) {
            throw EISException.groupingElementRequired();
        }
        if (this.getForeignKeyGroupingElement() != null) {
            DatabaseField field = this.getDescriptor().buildField(this.getForeignKeyGroupingElement());
            this.setForeignKeyGroupingElement((XMLField)field);
        }
        this.initializeSourceForeignKeysToTargetKeys();
        this.initializeDeleteAllQuery();
    }

    protected void initializeSourceForeignKeysToTargetKeys() throws DescriptorException {
        DatabaseField field;
        int i;
        if (this.getSourceForeignKeyFields().size() != this.getTargetForeignKeyFields().size()) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        for (i = 0; i < this.getTargetForeignKeyFields().size(); ++i) {
            field = this.getReferenceDescriptor().buildField((DatabaseField)this.getTargetForeignKeyFields().get(i));
            this.getTargetForeignKeyFields().set(i, field);
        }
        for (i = 0; i < this.getSourceForeignKeyFields().size(); ++i) {
            field = this.getReferenceDescriptor().buildField((DatabaseField)this.getSourceForeignKeyFields().get(i));
            this.getSourceForeignKeyFields().set(i, field);
            this.getSourceForeignKeysToTargetKeys().put(field, this.getTargetForeignKeyFields().get(i));
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
        }
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isForeignKeyRelationship()) {
            return super.shouldObjectModifyCascadeToParts(query);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        return true;
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        if (this.hasCustomDeleteAllQuery()) {
            this.deleteAll(query, referenceObjects);
        } else {
            ContainerPolicy cp = this.getContainerPolicy();
            Object iter = cp.iteratorFor(referenceObjects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        }
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        } else {
            this.deleteAll(query);
        }
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            UnitOfWorkChangeSet uowChangeSet;
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            if (query.getSession().isUnitOfWork() && (uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet()) != null) {
                writeQuery.setObjectChangeSet((ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object));
            }
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    public Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSet;
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object targetElement = null;
            targetElement = mergeManager.shouldMergeChangesIntoDistributedCache() ? objectChangeSet.getTargetVersionOfSourceObject(mergeManager, mergeManager.getSession(), true) : objectChangeSet.getUnitOfWorkClone();
            mergeManager.mergeChanges(targetElement, objectChangeSet, targetSession);
        }
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    public Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        ObjectBuilder objectBuilder = session.getDescriptor(element).getObjectBuilder();
        return objectBuilder.createObjectChangeSet(element, (UnitOfWorkChangeSet)owner.getUOWChangeSet(), session);
    }

    protected Object buildElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return ((ObjectChangeSet)changeSet).getTargetVersionOfSourceObject(mergeManager, targetSession);
    }

    public Object buildElementFromElement(Object element, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            UnitOfWorkChangeSet uowChangeSet;
            ObjectChangeSet objectChangeSet = null;
            if (mergeManager.getSession().isUnitOfWork() && (uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)mergeManager.getSession()).getUnitOfWorkChangeSet()) != null) {
                objectChangeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(element);
            }
            Object mergeElement = mergeManager.getObjectToMerge(element, this.referenceDescriptor, targetSession);
            mergeManager.mergeChanges(mergeElement, objectChangeSet, targetSession);
        }
        return mergeManager.getTargetVersionOfSourceObject(element, this.referenceDescriptor, targetSession);
    }

    public Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)changeSet;
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
        return this.buildElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    public Object clone() {
        EISOneToManyMapping clone = (EISOneToManyMapping)super.clone();
        clone.setSourceForeignKeysToTargetKeys((Map)((HashMap)this.getSourceForeignKeysToTargetKeys()).clone());
        return clone;
    }

    protected Vector collectFields() {
        if (this.isForeignKeyRelationship()) {
            if (this.getForeignKeyGroupingElement() != null) {
                Vector<XMLField> fields = new Vector<XMLField>(1);
                fields.addElement(this.getForeignKeyGroupingElement());
                return fields;
            }
            return NO_FIELDS;
        }
        return NO_FIELDS;
    }

    public boolean compareElements(Object element1, Object element2, AbstractSession session) {
        Object primaryKey2;
        if (!this.isForeignKeyRelationship()) {
            return false;
        }
        Object primaryKey1 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(element1, session);
        if (!primaryKey1.equals(primaryKey2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(element2, session))) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return session.compareObjects(element1, element2);
        }
        return true;
    }

    public boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return !this.getContainerPolicy().compareKeys(element, session);
    }

    public boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        return element1 == element2;
    }

    public ChangeRecord compareForChange(Object clone, Object backup, ObjectChangeSet owner, AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getAttributeValueFromObject(clone) != null && !this.isAttributeValueInstantiatedOrChanged(clone)) {
                return null;
            }
            return new EISOneToManyMappingHelper(this).compareForChange(clone, backup, owner, session);
        }
        return super.compareForChange(clone, backup, owner, session);
    }

    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        if (this.isForeignKeyRelationship()) {
            return new EISOneToManyMappingHelper(this).compareObjects(object1, object2, session);
        }
        return super.compareObjects(object1, object2, session);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        new EISOneToManyMappingHelper(this).simpleAddToCollectionChangeRecord(referenceKey, changeSetToAdd, changeSet, session);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        new EISOneToManyMappingHelper(this).simpleRemoveFromCollectionChangeRecord(referenceKey, changeSetToRemove, changeSet, session);
    }

    protected void deleteAll(DeleteObjectQuery query, Object referenceObjects) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(referenceObjects, query.getSession()));
    }

    protected void deleteAll(DeleteObjectQuery query) throws DatabaseException {
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        this.deleteAll(query, referenceObjects);
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    protected XMLRecord extractKeyRowFromReferenceObject(Object object, AbstractSession session, XMLRecord parentRecord) {
        Element newNode = XPathEngine.getInstance().createUnownedElement(parentRecord.getDOM(), this.getForeignKeyGroupingElement());
        DOMRecord result = new DOMRecord(newNode);
        result.setSession(session);
        for (int i = 0; i < this.getSourceForeignKeyFields().size(); ++i) {
            DatabaseField fkField = (DatabaseField)this.getSourceForeignKeyFields().get(i);
            if (object == null) {
                ((AbstractRecord)result).add(fkField, null);
                continue;
            }
            DatabaseField pkField = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(fkField);
            Object value = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, pkField, session);
            ((AbstractRecord)result).add(fkField, value);
        }
        return result;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, CacheKey cacheKey, AbstractSession executionSession, boolean isTargetProtected, Boolean[] wasCacheUsed) throws DatabaseException {
        if (this.descriptor.isProtectedIsolation()) {
            if (this.isCacheable && isTargetProtected && cacheKey != null) {
                Object cached = cacheKey.getObject();
                if (cached != null) {
                    if (wasCacheUsed != null) {
                        wasCacheUsed[0] = Boolean.TRUE;
                    }
                    return this.getAttributeValueFromObject(cached);
                }
            } else if (!this.isCacheable && !isTargetProtected && cacheKey != null) {
                return this.indirectionPolicy.buildIndirectObject(new ValueHolder(null));
            }
        }
        if (((EISDescriptor)this.getDescriptor()).getDataFormat() == "xml") {
            ((XMLRecord)row).setSession(executionSession);
        }
        ReadQuery targetQuery = this.getSelectionQuery();
        if (!this.isForeignKeyRelationship) {
            if (targetQuery.isObjectLevelReadQuery() && (sourceQuery.shouldCascadeAllParts() || sourceQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || sourceQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                ((ObjectLevelReadQuery)targetQuery).setShouldRefreshIdentityMapResult(sourceQuery.shouldRefreshIdentityMapResult());
                targetQuery.setCascadePolicy(sourceQuery.getCascadePolicy());
                targetQuery.setQueryId(sourceQuery.getQueryId());
                if (targetQuery.shouldMaintainCache()) {
                    targetQuery.setShouldMaintainCache(sourceQuery.shouldMaintainCache());
                }
            }
            return this.getIndirectionPolicy().valueFromQuery(targetQuery, row, sourceQuery.getSession());
        }
        if (this.getIndirectionPolicy().usesIndirection()) {
            EISOneToManyQueryBasedValueHolder valueholder = new EISOneToManyQueryBasedValueHolder(this, targetQuery, row, sourceQuery.getSession());
            return valueholder;
        }
        Vector subRows = this.getForeignKeyRows(row);
        if (subRows == null) {
            return null;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object results = cp.containerInstance(subRows.size());
        for (int i = 0; i < subRows.size(); ++i) {
            Iterator<Object> iter;
            XMLRecord subRow = (XMLRecord)subRows.elementAt(i);
            subRow.setSession(executionSession);
            Object object = this.getIndirectionPolicy().valueFromQuery(targetQuery, subRow, sourceQuery.getSession());
            if (object instanceof Collection) {
                iter = ((Collection)object).iterator();
                while (iter.hasNext()) {
                    cp.addInto(iter.next(), results, executionSession);
                }
                continue;
            }
            if (object instanceof Map) {
                iter = ((Map)object).values().iterator();
                while (iter.hasNext()) {
                    cp.addInto(iter.next(), results, executionSession);
                }
                continue;
            }
            cp.addInto(object, results, executionSession);
        }
        if (cp.sizeFor(results) == 0) {
            return null;
        }
        return results;
    }

    public Vector getForeignKeyRows(AbstractRecord row) {
        Vector subRows = new Vector();
        if (this.getForeignKeyGroupingElement() == null) {
            Object values;
            if (this.getSourceForeignKeyFields().size() > 0 && (values = row.getValues((DatabaseField)this.getSourceForeignKeyFields().get(0))) != null) {
                if (values instanceof Vector) {
                    int valuesSize = ((Vector)values).size();
                    for (int j = 0; j < valuesSize; ++j) {
                        DOMRecord newRecord = new DOMRecord("test");
                        newRecord.setSession(((XMLRecord)row).getSession());
                        ((AbstractRecord)newRecord).put(this.getSourceForeignKeyFields().get(0), ((Vector)values).get(j));
                        subRows.add(newRecord);
                    }
                } else {
                    DOMRecord newRecord = new DOMRecord("test");
                    newRecord.setSession(((XMLRecord)row).getSession());
                    ((AbstractRecord)newRecord).put(this.getSourceForeignKeyFields().get(0), values);
                    subRows.add(newRecord);
                }
            }
        } else {
            subRows = (Vector)row.getValues(this.getForeignKeyGroupingElement());
        }
        return subRows;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (!this.isForeignKeyRelationship) {
            return;
        }
        if (this.getSourceForeignKeysToTargetKeys() == null || this.getSourceForeignKeysToTargetKeys().size() == 0) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        AbstractRecord referenceRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (referenceRow != null) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), referenceRow.getValues(this.getForeignKeyGroupingElement()));
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                DatabaseField foreignKeyField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
                row.put(foreignKeyField, referenceRow.getValues(foreignKeyField));
            }
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object attributeValue = this.getRealCollectionAttributeValueFromObject(object, session);
        Vector<XMLRecord> nestedRows = new Vector<XMLRecord>(cp.sizeFor(attributeValue));
        if (this.getForeignKeyGroupingElement() != null) {
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                XMLRecord nestedRow = this.extractKeyRowFromReferenceObject(cp.next(iter, session), session, (XMLRecord)row);
                nestedRows.addElement(nestedRow);
            }
            row.add(this.getForeignKeyGroupingElement(), nestedRows);
        } else {
            DatabaseField singleField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
            DatabaseField pkField = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(singleField);
            Object iter = cp.iteratorFor(attributeValue);
            while (cp.hasNext(iter)) {
                Object singleValue = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(cp.next(iter, session), pkField, session);
                row.add(singleField, singleValue);
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsert(object, row, session);
        }
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, row, session);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord row) throws DescriptorException {
        Object collection2;
        Object collection1;
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        AbstractSession session = writeQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(collection1 = this.getRealCollectionAttributeValueFromObject(writeQuery.getObject(), session), collection2 = this.getRealCollectionAttributeValueFromObject(writeQuery.getBackupClone(), session), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), row, session, DatabaseMapping.WriteType.UPDATE);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session, DatabaseMapping.WriteType writeType) {
        if (this.isForeignKeyRelationship()) {
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            this.writeFromObjectIntoRow(object, row, session, writeType);
        } else {
            super.writeFromObjectIntoRowWithChangeRecord(changeRecord, row, session, writeType);
        }
    }

    public void writeInsertFieldsIntoRow(AbstractRecord row, AbstractSession session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                row.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                row.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeInsertFieldsIntoRow(row, session);
        }
    }

    public void setSelectionSQLString(String sqlString) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    public void setSelectionCriteria(Expression anExpression) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionCriteria");
    }

    public void setUsesBatchReading(boolean usesBatchReading) {
        throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
    }

    public boolean shouldUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "shouldUseBatchReading");
    }

    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }

    public void dontUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "dontUseBatchReading");
    }

    public void addAscendingOrdering(String queryKeyName) {
        throw DescriptorException.invalidMappingOperation(this, "addAscendingOrdering");
    }

    public void addDescendingOrdering(String queryKeyName) {
        throw DescriptorException.invalidMappingOperation(this, "addDescendingOrdering");
    }

    public void setDeleteAllSQLString(String sqlString) {
        throw DescriptorException.invalidMappingOperation(this, "setDeleteAllSQLString");
    }
}

