/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.sequencing.DatabaseSessionConnectionHandler;
import org.eclipse.persistence.internal.sequencing.PreallocationHandler;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sequencing.SequencingConnectionHandler;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sequencing.SequencingServer;
import org.eclipse.persistence.internal.sequencing.ServerSessionConnectionHandler;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ExternalConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SequencingManager
implements SequencingHome,
SequencingServer,
SequencingControl {
    private DatabaseSessionImpl ownerSession;
    private SequencingConnectionHandler connectionHandler;
    private PreallocationHandler preallocationHandler;
    private int whenShouldAcquireValueForAll;
    private Vector connectedSequences;
    boolean atLeastOneSequenceShouldUseTransaction;
    boolean atLeastOneSequenceShouldUsePreallocation;
    private static final int NOPREALLOCATION = 0;
    private static final int PREALLOCATION_NOTRANSACTION = 1;
    private static final int PREALLOCATION_TRANSACTION_NOACCESSOR = 2;
    private static final int PREALLOCATION_TRANSACTION_ACCESSOR = 3;
    private static final int NUMBER_OF_STATES = 4;
    private State[] states;
    private Map<String, ConcurrencyManager> locks;
    private SequencingCallbackFactory callbackFactory;
    private SequencingServer server;
    private Sequencing seq;
    private boolean shouldUseSeparateConnection;
    private Login login;
    private int minPoolSize = -1;
    private int maxPoolSize = -1;
    private int initialPoolSize = -1;
    private ConnectionPool connectionPool;

    public SequencingManager(DatabaseSessionImpl ownerSession) {
        this.ownerSession = ownerSession;
    }

    protected DatabaseSessionImpl getOwnerSession() {
        return this.ownerSession;
    }

    protected void createConnectionHandler() {
        boolean isServerSession = this.getOwnerSession().isServerSession();
        if (this.getLogin() == null) {
            Login login = isServerSession ? ((ServerSession)this.getOwnerSession()).getReadConnectionPool().getLogin() : this.getOwnerSession().getDatasourceLogin();
            this.setLogin(login);
        }
        if (this.getLogin() != null && this.getLogin().shouldUseExternalTransactionController()) {
            throw ValidationException.invalidSequencingLogin();
        }
        if (isServerSession) {
            ConnectionPool pool = null;
            if (this.connectionPool == null) {
                if (this.getLogin().shouldUseExternalConnectionPooling()) {
                    pool = new ExternalConnectionPool("sequencing", this.getLogin(), (ServerSession)this.getOwnerSession());
                } else {
                    if (this.getMinPoolSize() == -1) {
                        this.setMinPoolSize(2);
                    }
                    if (this.getMaxPoolSize() == -1) {
                        this.setMinPoolSize(2);
                    }
                    if (this.getInitialPoolSize() == -1) {
                        this.setInitialPoolSize(1);
                    }
                    pool = new ConnectionPool("sequencing", this.getLogin(), this.getInitialPoolSize(), this.getMinPoolSize(), this.getMaxPoolSize(), (ServerSession)this.getOwnerSession());
                }
            } else {
                pool = this.connectionPool;
            }
            this.setConnectionHandler(new ServerSessionConnectionHandler(pool));
        } else {
            this.setConnectionHandler(new DatabaseSessionConnectionHandler(this.getOwnerSession(), this.getLogin()));
        }
    }

    @Override
    public SequencingControl getSequencingControl() {
        return this;
    }

    protected void setSequencing(Sequencing sequencing) {
        this.seq = sequencing;
    }

    @Override
    public Sequencing getSequencing() {
        return this.seq;
    }

    protected void setSequencingServer(SequencingServer server) {
        this.server = server;
    }

    @Override
    public SequencingServer getSequencingServer() {
        return this.server;
    }

    protected void setSequencingCallbackFactory(SequencingCallbackFactory callbackFactory) {
        this.callbackFactory = callbackFactory;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.callbackFactory != null;
    }

    @Override
    public boolean shouldUseSeparateConnection() {
        return this.shouldUseSeparateConnection;
    }

    @Override
    public void setShouldUseSeparateConnection(boolean shouldUseSeparateConnection) {
        this.shouldUseSeparateConnection = shouldUseSeparateConnection;
    }

    @Override
    public boolean isConnectedUsingSeparateConnection() {
        return this.isConnected() && this.getConnectionHandler() != null;
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinPoolSize(int size) {
        this.minPoolSize = size;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaxPoolSize(int size) {
        this.maxPoolSize = size;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    @Override
    public void setInitialPoolSize(int size) {
        this.initialPoolSize = size;
    }

    @Override
    public boolean isConnected() {
        return this.states != null;
    }

    protected SequencingConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    protected void setConnectionHandler(SequencingConnectionHandler handler) {
        this.connectionHandler = handler;
    }

    @Override
    public ConnectionPool getConnectionPool() {
        if (this.getConnectionHandler() != null && this.getConnectionHandler() instanceof ServerSessionConnectionHandler) {
            return ((ServerSessionConnectionHandler)this.getConnectionHandler()).getPool();
        }
        return this.connectionPool;
    }

    @Override
    public Object getNextValue(Class cls) {
        return this.getNextValue(this.getOwnerSession(), cls);
    }

    @Override
    public void initializePreallocated() {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated();
        }
    }

    @Override
    public void initializePreallocated(String seqName) {
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().initializePreallocated(seqName);
        }
    }

    protected void setLocks(Map locks) {
        this.locks = locks;
    }

    protected Map<String, ConcurrencyManager> getLocks() {
        return this.locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConcurrencyManager acquireLock(String sequenceName) {
        ConcurrencyManager manager = this.getLocks().get(sequenceName);
        if (manager == null) {
            Map<String, ConcurrencyManager> map = this.getLocks();
            synchronized (map) {
                manager = this.getLocks().get(sequenceName);
                if (manager == null) {
                    manager = new ConcurrencyManager();
                    this.getLocks().put(sequenceName, manager);
                }
            }
        }
        manager.acquire();
        return manager;
    }

    protected Sequence getSequence(Class cls) {
        String seqName = this.getOwnerSession().getDescriptor(cls).getSequenceNumberName();
        return this.getSequence(seqName);
    }

    protected void logDebugPreallocation(String seqName, Object firstSequenceValue, Vector sequences) {
        if (this.getOwnerSession().shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, sequences.size() + 1, firstSequenceValue, sequences.lastElement()};
            this.getOwnerSession().log(1, "sequencing", "sequencing_preallocation", args);
        }
    }

    protected void logDebugLocalPreallocation(AbstractSession writeSession, String seqName, Vector sequences, Accessor accessor) {
        if (writeSession.shouldLog(1, "sequencing")) {
            Object[] args = new Object[]{seqName, sequences.size(), sequences.firstElement(), sequences.lastElement()};
            writeSession.log(1, "sequencing", "sequencing_localPreallocation", args, accessor);
        }
    }

    @Override
    public void resetSequencing() {
        if (this.isConnected()) {
            this.onDisconnect();
            this.onConnect();
        }
    }

    @Override
    public void onConnect() {
        if (this.isConnected()) {
            return;
        }
        if (!this.getOwnerSession().getProject().usesSequencing()) {
            return;
        }
        this.onConnectInternal(null);
    }

    @Override
    public void onAddDescriptors(Collection descriptors) {
        if (!this.isConnected()) {
            this.onConnect();
            return;
        }
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        this.onConnectInternal(descriptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onConnectInternal(Collection descriptors) {
        boolean hasSequencingCallbackFactory;
        int nAlreadyConnectedSequences = 0;
        if (this.connectedSequences != null) {
            nAlreadyConnectedSequences = this.connectedSequences.size();
        }
        int whenShouldAcquireValueForAllOriginal = this.whenShouldAcquireValueForAll;
        boolean atLeastOneSequenceShouldUseTransactionOriginal = this.atLeastOneSequenceShouldUseTransaction;
        boolean atLeastOneSequenceShouldUsePreallocationOriginal = this.atLeastOneSequenceShouldUsePreallocation;
        this.onConnectSequences(descriptors);
        if (nAlreadyConnectedSequences == this.connectedSequences.size()) {
            return;
        }
        boolean onExceptionDisconnectPreallocationHandler = false;
        boolean onExceptionDisconnectConnectionHandler = false;
        boolean hasConnectionHandler = this.getConnectionHandler() != null;
        boolean hasPreallocationHandler = this.getPreallocationHandler() != null;
        try {
            if (!hasConnectionHandler) {
                if (!this.shouldUseSeparateConnection()) {
                    this.setConnectionHandler(null);
                } else if (this.atLeastOneSequenceShouldUseTransaction) {
                    if (this.getConnectionHandler() == null) {
                        this.createConnectionHandler();
                    }
                    if (this.getConnectionHandler() != null) {
                        this.getConnectionHandler().onConnect();
                        onExceptionDisconnectConnectionHandler = true;
                    }
                }
            }
            if (!hasPreallocationHandler && this.atLeastOneSequenceShouldUsePreallocation) {
                if (this.getPreallocationHandler() == null) {
                    this.createPreallocationHandler();
                }
                this.getPreallocationHandler().onConnect();
                onExceptionDisconnectPreallocationHandler = true;
            }
            this.initializeStates(nAlreadyConnectedSequences);
        }
        catch (RuntimeException ex) {
            try {
                try {
                    this.onDisconnectSequences(nAlreadyConnectedSequences);
                }
                catch (Exception ex2) {
                    Object var13_13 = null;
                    this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                    this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                    this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
                }
                Object var13_12 = null;
                this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.whenShouldAcquireValueForAll = whenShouldAcquireValueForAllOriginal;
                this.atLeastOneSequenceShouldUseTransaction = atLeastOneSequenceShouldUseTransactionOriginal;
                this.atLeastOneSequenceShouldUsePreallocation = atLeastOneSequenceShouldUsePreallocationOriginal;
                throw throwable;
            }
            if (!hasConnectionHandler && this.getConnectionHandler() != null) {
                if (onExceptionDisconnectConnectionHandler) {
                    this.getConnectionHandler().onDisconnect();
                }
                this.setConnectionHandler(null);
            }
            if (!hasPreallocationHandler && this.getPreallocationHandler() != null) {
                if (onExceptionDisconnectPreallocationHandler) {
                    this.getPreallocationHandler().onDisconnect();
                }
                this.clearPreallocationHandler();
            }
            throw ex;
        }
        if (this.atLeastOneSequenceShouldUsePreallocation && this.getLocks() == null) {
            this.setLocks(new ConcurrentHashMap(20));
        }
        if (!(hasSequencingCallbackFactory = this.isSequencingCallbackRequired())) {
            this.createSequencingCallbackFactory();
            if (this.getOwnerSession().hasExternalTransactionController()) {
                this.getOwnerSession().getExternalTransactionController().initializeSequencingListeners();
            }
        }
        if (descriptors == null) {
            if (this.getOwnerSession().isServerSession()) {
                this.setSequencingServer(this);
            }
            this.setSequencing(this);
        }
        this.logDebugSequencingConnected(nAlreadyConnectedSequences);
    }

    @Override
    public void onDisconnect() {
        if (!this.isConnected()) {
            return;
        }
        this.setSequencing(null);
        this.setSequencingServer(null);
        this.setSequencingCallbackFactory(null);
        if (this.getOwnerSession().hasExternalTransactionController() && !this.getOwnerSession().hasBroker()) {
            this.getOwnerSession().getExternalTransactionController().clearSequencingListeners();
        }
        this.setLocks(null);
        this.clearStates();
        if (this.getConnectionHandler() != null) {
            this.getConnectionHandler().onDisconnect();
            this.setConnectionHandler(null);
        }
        if (this.getPreallocationHandler() != null) {
            this.getPreallocationHandler().onDisconnect();
            this.clearPreallocationHandler();
        }
        this.onDisconnectSequences(0);
        this.getOwnerSession().log(1, "sequencing", "sequencing_disconnected");
    }

    protected PreallocationHandler getPreallocationHandler() {
        return this.preallocationHandler;
    }

    protected void createPreallocationHandler() {
        this.preallocationHandler = new PreallocationHandler();
    }

    protected void clearPreallocationHandler() {
        this.preallocationHandler = null;
    }

    protected void onConnectSequences(Collection descriptors) {
        boolean isConnected = this.isConnected();
        int nAlreadyConnectedSequences = 0;
        if (this.connectedSequences == null) {
            this.connectedSequences = new Vector();
        } else {
            nAlreadyConnectedSequences = this.connectedSequences.size();
        }
        boolean shouldUseTransaction = false;
        boolean shouldUsePreallocation = false;
        boolean shouldAcquireValueAfterInsert = false;
        if (descriptors == null) {
            descriptors = this.getOwnerSession().getDescriptors().values();
        }
        Iterator itDescriptors = descriptors.iterator();
        while (itDescriptors.hasNext()) {
            ClassDescriptor newDescriptor;
            ClassDescriptor descriptor;
            ClassDescriptor parentDescriptor = descriptor = (ClassDescriptor)itDescriptors.next();
            while (!parentDescriptor.usesSequenceNumbers() && parentDescriptor.isChildDescriptor() && (newDescriptor = this.getOwnerSession().getDescriptor(parentDescriptor.getInheritancePolicy().getParentClass())) != null && newDescriptor != parentDescriptor) {
                parentDescriptor = newDescriptor;
            }
            if (!parentDescriptor.usesSequenceNumbers()) continue;
            String seqName = parentDescriptor.getSequenceNumberName();
            Sequence sequence = this.getSequence(seqName);
            if (sequence == null) {
                sequence = new DefaultSequence(seqName);
                this.getOwnerSession().getDatasourcePlatform().addSequence(sequence, isConnected);
            }
            descriptor.setSequence(sequence);
            if (this.connectedSequences.contains(sequence)) continue;
            try {
                if (sequence instanceof DefaultSequence && !this.connectedSequences.contains(this.getDefaultSequence())) {
                    this.getDefaultSequence().onConnect(this.getOwnerSession().getDatasourcePlatform());
                    this.connectedSequences.add(nAlreadyConnectedSequences, this.getDefaultSequence());
                    shouldUseTransaction |= this.getDefaultSequence().shouldUseTransaction();
                    shouldUsePreallocation |= this.getDefaultSequence().shouldUsePreallocation();
                    shouldAcquireValueAfterInsert |= this.getDefaultSequence().shouldAcquireValueAfterInsert();
                }
                sequence.onConnect(this.getOwnerSession().getDatasourcePlatform());
                this.connectedSequences.addElement(sequence);
                shouldUseTransaction |= sequence.shouldUseTransaction();
                shouldUsePreallocation |= sequence.shouldUsePreallocation();
                shouldAcquireValueAfterInsert |= sequence.shouldAcquireValueAfterInsert();
            }
            catch (RuntimeException ex) {
                for (int i = this.connectedSequences.size() - 1; i >= nAlreadyConnectedSequences; --i) {
                    try {
                        Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                        sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                        continue;
                    }
                    catch (RuntimeException ex2) {
                        // empty catch block
                    }
                }
                if (nAlreadyConnectedSequences == 0) {
                    this.connectedSequences = null;
                }
                throw ex;
            }
        }
        if (nAlreadyConnectedSequences == 0) {
            if (shouldAcquireValueAfterInsert && !shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = 1;
            } else if (!shouldAcquireValueAfterInsert && shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = -1;
            }
        } else if (this.whenShouldAcquireValueForAll == 1) {
            if (!shouldAcquireValueAfterInsert || shouldUsePreallocation) {
                this.whenShouldAcquireValueForAll = 0;
            }
        } else if (this.whenShouldAcquireValueForAll == -1 && (shouldAcquireValueAfterInsert || !shouldUsePreallocation)) {
            this.whenShouldAcquireValueForAll = 0;
        }
        this.atLeastOneSequenceShouldUseTransaction |= shouldUseTransaction;
        this.atLeastOneSequenceShouldUsePreallocation |= shouldUsePreallocation;
    }

    protected void onDisconnectSequences(int nAlreadyConnectedSequences) {
        RuntimeException exception = null;
        for (int i = this.connectedSequences.size() - 1; i >= nAlreadyConnectedSequences; --i) {
            try {
                Sequence sequenceToDisconnect = (Sequence)this.connectedSequences.elementAt(i);
                sequenceToDisconnect.onDisconnect(this.getOwnerSession().getDatasourcePlatform());
                continue;
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (nAlreadyConnectedSequences == 0) {
            this.connectedSequences = null;
            this.whenShouldAcquireValueForAll = 0;
            this.atLeastOneSequenceShouldUseTransaction = false;
            this.atLeastOneSequenceShouldUsePreallocation = false;
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected void initializeStates(int nAlreadyConnectedSequences) {
        if (this.states == null) {
            this.states = new State[4];
        }
        int nSize = this.connectedSequences.size();
        for (int i = nAlreadyConnectedSequences; i < nSize; ++i) {
            Sequence sequence = (Sequence)this.connectedSequences.get(i);
            State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            if (state != null) continue;
            this.createState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        }
    }

    protected void clearStates() {
        this.states = null;
    }

    protected int getStateId(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            return 0;
        }
        if (!shouldUseTransaction) {
            return 1;
        }
        if (this.getConnectionHandler() == null) {
            return 2;
        }
        return 3;
    }

    protected State getState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        return this.states[this.getStateId(shouldUsePreallocation, shouldUseTransaction)];
    }

    protected void createState(boolean shouldUsePreallocation, boolean shouldUseTransaction) {
        if (!shouldUsePreallocation) {
            this.states[0] = new NoPreallocation_State();
        } else if (!shouldUseTransaction) {
            this.states[1] = new Preallocation_NoTransaction_State();
        } else if (this.getConnectionHandler() == null) {
            this.states[2] = new Preallocation_Transaction_NoAccessor_State();
        } else {
            this.states[3] = new Preallocation_Transaction_Accessor_State();
        }
    }

    protected void createSequencingCallbackFactory() {
        if (this.states[2] != null) {
            this.setSequencingCallbackFactory(this.states[2].getSequencingCallbackFactory());
        } else {
            this.setSequencingCallbackFactory(null);
        }
    }

    @Override
    public Object getNextValue(AbstractSession writeSession, Class cls) {
        Sequence sequence = this.getSequence(cls);
        State state = this.getState(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
        return state.getNextValue(sequence, writeSession);
    }

    protected void logDebugSequencingConnected(int nAlreadyConnectedSequences) {
        int i;
        Vector[] sequenceVectors = new Vector[4];
        int size = this.connectedSequences.size();
        for (i = nAlreadyConnectedSequences; i < size; ++i) {
            Sequence sequence = (Sequence)this.connectedSequences.get(i);
            int stateId = this.getStateId(sequence.shouldUsePreallocation(), sequence.shouldUseTransaction());
            Vector<Sequence> v = sequenceVectors[stateId];
            if (v == null) {
                sequenceVectors[stateId] = v = new Vector<Sequence>();
            }
            v.addElement(sequence);
        }
        for (i = 0; i < 4; ++i) {
            Vector v = sequenceVectors[i];
            if (v == null) continue;
            this.getOwnerSession().log(1, "sequencing", "sequencing_connected", this.states[i]);
            for (int j = 0; j < v.size(); ++j) {
                Sequence sequence = (Sequence)v.elementAt(j);
                Object[] args = new Object[]{sequence.getName(), Integer.toString(sequence.getPreallocationSize()), Integer.toString(sequence.getInitialValue())};
                this.getOwnerSession().log(1, "sequencing", "sequence_without_state", args);
            }
        }
    }

    public int getPreallocationSize() {
        return this.getDefaultSequence().getPreallocationSize();
    }

    public int getInitialValue() {
        return this.getDefaultSequence().getInitialValue();
    }

    @Override
    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    protected Sequence getDefaultSequence() {
        return this.getOwnerSession().getDatasourcePlatform().getDefaultSequence();
    }

    protected Sequence getSequence(String seqName) {
        return this.getOwnerSession().getDatasourcePlatform().getSequence(seqName);
    }

    @Override
    public void setConnectionPool(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    class NoPreallocation_State
    extends State {
        NoPreallocation_State() {
        }

        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            return sequence.getGeneratedValue(null, writeSession);
        }
    }

    class Preallocation_NoTransaction_State
    extends State {
        Preallocation_NoTransaction_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            String seqName = sequence.getName();
            if (sequence.getPreallocationSize() > 1) {
                ConcurrencyManager lock;
                Object sequenceValue;
                block5: {
                    Object e;
                    Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
                    sequenceValue = sequencesForName.poll();
                    if (sequenceValue != null) {
                        return sequenceValue;
                    }
                    lock = SequencingManager.this.acquireLock(seqName);
                    try {
                        sequenceValue = sequencesForName.poll();
                        if (sequenceValue == null) break block5;
                        e = sequenceValue;
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        lock.release();
                        throw throwable;
                    }
                    lock.release();
                    return e;
                }
                Vector sequences = sequence.getGeneratedVector(null, writeSession);
                sequenceValue = sequences.remove(0);
                SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                Object var9_10 = null;
                lock.release();
                return sequenceValue;
            }
            return sequence.getGeneratedVector(null, writeSession).firstElement();
        }
    }

    class Preallocation_Transaction_Accessor_State
    extends State {
        Preallocation_Transaction_Accessor_State() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            Throwable throwable4;
            Object lock2;
            String seqName = sequence.getName();
            if (sequence.getPreallocationSize() > 1) {
                ConcurrencyManager lock2;
                Object sequenceValue;
                block18: {
                    Object e;
                    Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
                    sequenceValue = sequencesForName.poll();
                    if (sequenceValue != null) {
                        return sequenceValue;
                    }
                    lock2 = SequencingManager.this.acquireLock(seqName);
                    try {
                        sequenceValue = sequencesForName.poll();
                        if (sequenceValue == null) break block18;
                        e = sequenceValue;
                        Object var13_14 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var13_16 = null;
                        lock2.release();
                        throw throwable2;
                    }
                    lock2.release();
                    return e;
                }
                Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
                try {
                    accessor.beginTransaction(writeSession);
                    try {
                        Vector sequences = sequence.getGeneratedVector(accessor, writeSession);
                        accessor.commitTransaction(writeSession);
                        sequenceValue = sequences.remove(0);
                        SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, sequences);
                        SequencingManager.this.logDebugPreallocation(seqName, sequenceValue, sequences);
                    }
                    catch (RuntimeException ex) {
                        try {
                            accessor.rollbackTransaction(writeSession);
                            throw ex;
                        }
                        catch (Exception rollbackException) {
                            // empty catch block
                        }
                        throw ex;
                    }
                    Object var11_20 = null;
                    SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                }
                catch (Throwable throwable3) {
                    Object var11_21 = null;
                    SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                    throw throwable3;
                }
                Object var13_15 = null;
                lock2.release();
                return sequenceValue;
            }
            Accessor accessor = SequencingManager.this.getConnectionHandler().acquireAccessor();
            accessor.beginTransaction(writeSession);
            try {
                Object sequenceValue = sequence.getGeneratedVector(accessor, writeSession).firstElement();
                accessor.commitTransaction(writeSession);
                lock2 = sequenceValue;
            }
            catch (RuntimeException ex) {
                try {
                    try {
                        accessor.rollbackTransaction(writeSession);
                        throw ex;
                    }
                    catch (Exception rollbackException) {
                        // empty catch block
                    }
                    throw ex;
                }
                catch (Throwable throwable4) {
                    Object var15_25 = null;
                    SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
                }
            }
            Object var15_24 = null;
            SequencingManager.this.getConnectionHandler().releaseAccessor(accessor);
            return lock2;
            throw throwable4;
        }
    }

    class Preallocation_Transaction_NoAccessor_State
    extends State
    implements SequencingCallbackFactory {
        Preallocation_Transaction_NoAccessor_State() {
        }

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return this;
        }

        public SequencingCallback createSequencingCallback() {
            return new SequencingCallbackImpl();
        }

        void afterCommitInternal(Map localSequences, Accessor accessor) {
            for (Map.Entry entry : localSequences.entrySet()) {
                String seqName = (String)entry.getKey();
                Vector localSequenceForName = (Vector)entry.getValue();
                if (localSequenceForName.isEmpty()) continue;
                SequencingManager.this.getPreallocationHandler().setPreallocated(seqName, localSequenceForName);
                localSequenceForName.clear();
            }
            if (accessor != null) {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null, accessor);
            } else {
                SequencingManager.this.getOwnerSession().log(1, "sequencing", "sequencing_afterTransactionCommitted", null);
            }
        }

        SequencingCallbackImpl getCallbackImpl(AbstractSession writeSession, Accessor accessor) {
            SequencingCallbackImpl seqCallbackImpl = writeSession.hasExternalTransactionController() ? (SequencingCallbackImpl)writeSession.getExternalTransactionController().getActiveSequencingCallback(SequencingManager.this.getOwnerSession(), this.getSequencingCallbackFactory()) : (SequencingCallbackImpl)accessor.getSequencingCallback(this.getSequencingCallbackFactory());
            return seqCallbackImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getNextValue(Sequence sequence, AbstractSession writeSession) {
            String seqName = sequence.getName();
            if (sequence.getPreallocationSize() > 1) {
                Object object;
                ConcurrencyManager lock;
                boolean keepLocked;
                block30: {
                    block29: {
                        block28: {
                            Vector localSequencesForName;
                            Queue sequencesForName = SequencingManager.this.getPreallocationHandler().getPreallocated(seqName);
                            Object sequenceValue = sequencesForName.poll();
                            if (sequenceValue != null) {
                                return sequenceValue;
                            }
                            keepLocked = false;
                            lock = null;
                            if (!SequencingManager.this.getOwnerSession().getDatasourceLogin().shouldUseExternalTransactionController() && !writeSession.isInTransaction()) {
                                block27: {
                                    Object e;
                                    block26: {
                                        lock = SequencingManager.this.acquireLock(seqName);
                                        try {
                                            sequenceValue = sequencesForName.poll();
                                            if (sequenceValue != null) {
                                                e = sequenceValue;
                                                Object var10_13 = null;
                                                if (keepLocked) return e;
                                                break block26;
                                            }
                                            writeSession.beginTransaction();
                                            keepLocked = true;
                                            break block27;
                                        }
                                        catch (Throwable throwable) {
                                            Object var10_15 = null;
                                            if (keepLocked) throw throwable;
                                            lock.release();
                                            throw throwable;
                                        }
                                    }
                                    lock.release();
                                    return e;
                                }
                                object = null;
                                if (!keepLocked) {
                                    lock.release();
                                }
                            }
                            if (!keepLocked) {
                                writeSession.beginTransaction();
                            }
                            try {
                                Accessor accessor = writeSession.getAccessor();
                                SequencingCallbackImpl seqCallbackImpl = this.getCallbackImpl(writeSession, accessor);
                                Map localSequences = seqCallbackImpl.getPreallocatedSequenceValues();
                                localSequencesForName = (Vector)localSequences.get(seqName);
                                if (localSequencesForName == null || localSequencesForName.isEmpty()) {
                                    localSequencesForName = sequence.getGeneratedVector(null, writeSession);
                                    localSequences.put(seqName, localSequencesForName);
                                    SequencingManager.this.logDebugLocalPreallocation(writeSession, seqName, localSequencesForName, accessor);
                                }
                            }
                            catch (RuntimeException ex) {
                                if (keepLocked) {
                                    lock.release();
                                }
                                try {
                                    writeSession.rollbackTransaction();
                                    throw ex;
                                }
                                catch (Exception rollbackException) {
                                    // empty catch block
                                }
                                throw ex;
                            }
                            try {
                                try {
                                    writeSession.commitTransaction();
                                }
                                catch (DatabaseException ex) {
                                    try {
                                        writeSession.rollbackTransaction();
                                        throw ex;
                                    }
                                    catch (Exception rollbackException) {
                                        // empty catch block
                                    }
                                    throw ex;
                                }
                                if (!localSequencesForName.isEmpty()) {
                                    sequenceValue = localSequencesForName.remove(0);
                                    object = sequenceValue;
                                    Object var13_23 = null;
                                    if (!keepLocked) return object;
                                    break block28;
                                }
                                sequenceValue = sequencesForName.poll();
                                if (sequenceValue != null) {
                                    object = sequenceValue;
                                    break block29;
                                }
                                object = this.getNextValue(sequence, writeSession);
                                break block30;
                            }
                            catch (Throwable throwable) {
                                Object var13_26 = null;
                                if (!keepLocked) throw throwable;
                                lock.release();
                                throw throwable;
                            }
                        }
                        lock.release();
                        return object;
                    }
                    Object var13_24 = null;
                    if (!keepLocked) return object;
                    lock.release();
                    return object;
                }
                Object var13_25 = null;
                if (!keepLocked) return object;
                lock.release();
                return object;
            }
            writeSession.beginTransaction();
            try {
                Object sequenceValue = sequence.getGeneratedVector(null, writeSession).firstElement();
                writeSession.commitTransaction();
                return sequenceValue;
            }
            catch (RuntimeException ex) {
                try {
                    writeSession.rollbackTransaction();
                    throw ex;
                }
                catch (Exception rollbackException) {
                    // empty catch block
                }
                throw ex;
            }
        }

        public class SequencingCallbackImpl
        implements SequencingCallback {
            Map localSequences = new HashMap();

            public void afterCommit(Accessor accessor) {
                Preallocation_Transaction_NoAccessor_State.this.afterCommitInternal(this.localSequences, accessor);
            }

            public Map getPreallocatedSequenceValues() {
                return this.localSequences;
            }
        }
    }

    static abstract class State {
        State() {
        }

        abstract Object getNextValue(Sequence var1, AbstractSession var2);

        SequencingCallbackFactory getSequencingCallbackFactory() {
            return null;
        }

        public String toString() {
            String name = this.getClass().getName();
            return name.substring(name.lastIndexOf(36) + 1);
        }
    }
}

