/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.ConstructorBinding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.QualifiedName;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLCompletionProposal;
import org.eclipse.edt.ide.ui.internal.contentassist.EGLProposalContextInformation;
import org.eclipse.edt.ide.ui.internal.contentassist.proposalhandlers.EGLAbstractProposalHandler;
import org.eclipse.jface.text.ITextViewer;

public class EGLFunctionSignatureProposalHandler
extends EGLAbstractProposalHandler {
    private Expression invocationTarget;

    public EGLFunctionSignatureProposalHandler(ITextViewer viewer, int documentOffset, Expression invocationTarget) {
        super(viewer, documentOffset, "");
        this.invocationTarget = invocationTarget;
    }

    public List getProposals() {
        ArrayList proposals = new ArrayList();
        OverloadedFunctionSet functionSet = (OverloadedFunctionSet)this.invocationTarget.getAttributeFromName(Name.OVERLOADED_FUNCTION_SET);
        if (functionSet != null) {
            for (IBinding nextFunc : functionSet.getNestedFunctionBindings()) {
                this.addProposal(proposals, nextFunc);
            }
        } else {
            this.addProposal(proposals, (IBinding)this.invocationTarget.resolveTypeBinding());
        }
        return proposals;
    }

    private void addProposal(List proposals, IBinding binding) {
        Object proposal = this.createProposal(binding);
        if (proposal != null) {
            proposals.add(proposal);
        }
    }

    private Object createProposal(IBinding binding) {
        if (Binding.isValidBinding((IBinding)binding)) {
            if (binding.isFunctionBinding()) {
                return this.createProposal((IFunctionBinding)binding);
            }
            if (binding.isDataBinding()) {
                IDataBinding dBinding = (IDataBinding)binding;
                switch (dBinding.getKind()) {
                    case 20: {
                        return this.createProposal((IFunctionBinding)dBinding.getType());
                    }
                    case 22: {
                        ConstructorBinding cBinding = (ConstructorBinding)dBinding;
                        return this.createProposal(cBinding.getCaseSensitiveName(), cBinding.getParameters(), null, cBinding.getDeclaringPart().getCaseSensitiveName());
                    }
                }
            } else if (binding.isTypeBinding()) {
                ITypeBinding tBinding = (ITypeBinding)binding;
                switch (tBinding.getKind()) {
                    case 27: {
                        DelegateBinding delBinding = (DelegateBinding)tBinding;
                        return this.createProposal(delBinding.getCaseSensitiveName(), delBinding.getParemeters(), delBinding.getReturnType(), this.getPackageName((IPartBinding)delBinding));
                    }
                }
            }
        }
        return null;
    }

    private Object createProposal(IFunctionBinding fBinding) {
        IPartBinding declarer = fBinding.getDeclarer();
        String declarerName = null;
        if (declarer == null) {
            if (this.invocationTarget instanceof QualifiedName) {
                declarerName = ((QualifiedName)this.invocationTarget).getQualifier().getCanonicalName();
            }
        } else {
            declarerName = declarer == fBinding ? this.getPackageName(declarer) : declarer.getCaseSensitiveName();
        }
        return this.createProposal(fBinding.getCaseSensitiveName(), fBinding.getParameters(), fBinding.getReturnType(), declarerName);
    }

    private Object createProposal(String funcName, List parameters, ITypeBinding returnType, String declarerName) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        String parameterList = this.getParameterListString(parameters);
        StringBuffer proposalSB = new StringBuffer();
        proposalSB.append(funcName);
        proposalSB.append("(");
        proposalSB.append(parameterList);
        proposalSB.append(")");
        if (returnType != null) {
            proposalSB.append(" ");
            proposalSB.append(StatementValidator.getTypeString((ITypeBinding)returnType));
        }
        proposalSB.append(" - ");
        proposalSB.append(declarerName);
        EGLCompletionProposal completionProposal = new EGLCompletionProposal(this.viewer, proposalSB.toString(), "", null, this.getDocumentOffset() - this.getPrefix().length(), 0, 0);
        EGLProposalContextInformation contextInformation = new EGLProposalContextInformation(completionProposal, this.getLParenOffsetAfter(this.invocationTarget.getOffset()) + 1, proposalSB.toString(), parameterList);
        completionProposal.setContextInformation(contextInformation);
        return completionProposal;
    }
}

