/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.edt.compiler.internal.util.Encoder;
import org.eclipse.edt.ide.internal.sql.util.EGLSQLUtility;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.edt.ide.ui.internal.deployment.ui.WebBindingDetailPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SQLDatabaseBindingDetailPage
extends WebBindingDetailPage {
    private Binding fSQLDatabaseBinding;
    private Button fUseURI;
    private Text fUri;
    private Button fUseDefinedInfo;
    private Text fDbms;
    private Text fSqlDB;
    private Text fUserId;
    private Text fSqlJDBCDriverClass;
    private Text fSqlPassword;
    private Text fDefaultSchema;
    private Text fConnLocation;
    private static final int indent = 20;
    protected Button btnPing;
    private List<Control> uriControls;
    private List<Control> definedControls;

    public SQLDatabaseBindingDetailPage() {
        this.nColumnSpan = 3;
        this.uriControls = new ArrayList<Control>();
        this.definedControls = new ArrayList<Control>();
    }

    @Override
    protected Composite createDetailSection(Composite parent, FormToolkit toolkit, int sectionStyle, int columnSpan) {
        return this.createSection(parent, toolkit, SOAMessages.SQLDatabaseBindingDetailSecTitle, SOAMessages.SQLDatabaseBindingDetailSecDescp, sectionStyle, columnSpan);
    }

    @Override
    protected void createDetailControls(FormToolkit toolkit, Composite parent) {
        this.createURIControls(toolkit, parent);
        this.createSQLControls(toolkit, parent);
    }

    private void createURIControls(FormToolkit toolkit, Composite parent) {
        toolkit.getBorderStyle();
        this.uriControls.clear();
        this.fUseURI = toolkit.createButton(parent, SOAMessages.SQLDatabaseBindingUseURILabel, 16);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        this.fUseURI.setLayoutData((Object)gd);
        this.fUseURI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Control c : SQLDatabaseBindingDetailPage.this.uriControls) {
                    c.setEnabled(true);
                }
                for (Control c : SQLDatabaseBindingDetailPage.this.definedControls) {
                    c.setEnabled(false);
                }
                SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUseURI(true);
            }
        });
        Label l = toolkit.createLabel(parent, SOAMessages.LabelURI);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.uriControls.add((Control)l);
        this.fUri = this.createTextControl(toolkit, parent);
        this.fUri.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUri(SQLDatabaseBindingDetailPage.this.fUri.getText());
            }
        });
        this.uriControls.add((Control)this.fUri);
        toolkit.setBorderStyle(0);
        l = toolkit.createLabel(parent, SOAMessages.LabelWorkspaceExample);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.uriControls.add((Control)l);
        Composite exampleComposite = toolkit.createComposite(parent);
        exampleComposite.setFont(parent.getFont());
        gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan - 1;
        exampleComposite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        exampleComposite.setLayout((Layout)layout);
        this.uriControls.add((Control)exampleComposite);
        Text example = toolkit.createText(exampleComposite, "workspace://myConnectionProfile", 12);
        example.setLayoutData((Object)new GridData(768));
        this.uriControls.add((Control)example);
        this.createSpacer(toolkit, parent, this.nColumnSpan);
    }

    private void createSQLControls(FormToolkit toolkit, Composite parent) {
        this.definedControls.clear();
        this.fUseDefinedInfo = toolkit.createButton(parent, SOAMessages.SqlDatabaseBindingSpecifyInfoLabel, 16);
        GridData gd = new GridData(768);
        gd.horizontalSpan = this.nColumnSpan;
        this.fUseDefinedInfo.setLayoutData((Object)gd);
        this.fUseDefinedInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Control c : SQLDatabaseBindingDetailPage.this.definedControls) {
                    c.setEnabled(true);
                }
                for (Control c : SQLDatabaseBindingDetailPage.this.uriControls) {
                    c.setEnabled(false);
                }
                SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding.setUseURI(false);
            }
        });
        Label l = toolkit.createLabel(parent, SOAMessages.LabelDbms);
        this.definedControls.add((Control)l);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.fDbms = this.createTextControl(toolkit, parent);
        this.fDbms.setEditable(false);
        this.fDbms.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "dbms", SQLDatabaseBindingDetailPage.this.fDbms.getText());
            }
        });
        this.definedControls.add((Control)this.fDbms);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlJDBCDriverClass);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlJDBCDriverClass = this.createTextControl(toolkit, parent);
        this.fSqlJDBCDriverClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlJDBCDriverClass", SQLDatabaseBindingDetailPage.this.fSqlJDBCDriverClass.getText());
            }
        });
        this.definedControls.add((Control)this.fSqlJDBCDriverClass);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlValidationConnectionURL);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlDB = this.createTextControl(toolkit, parent);
        this.fSqlDB.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlDB", SQLDatabaseBindingDetailPage.this.fSqlDB.getText());
            }
        });
        this.definedControls.add((Control)this.fSqlDB);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlID);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fUserId = this.createTextControl(toolkit, parent);
        this.fUserId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlID", SQLDatabaseBindingDetailPage.this.fUserId.getText());
            }
        });
        this.definedControls.add((Control)this.fUserId);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlPassword);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fSqlPassword = this.createTextControl(toolkit, parent);
        this.fSqlPassword.setEchoChar('*');
        this.fSqlPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlPassword", Encoder.encode((String)SQLDatabaseBindingDetailPage.this.fSqlPassword.getText()));
            }
        });
        this.definedControls.add((Control)this.fSqlPassword);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlSchema);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fDefaultSchema = this.createTextControl(toolkit, parent);
        this.fDefaultSchema.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "sqlSchema", SQLDatabaseBindingDetailPage.this.fDefaultSchema.getText());
            }
        });
        this.definedControls.add((Control)this.fDefaultSchema);
        l = toolkit.createLabel(parent, SOAMessages.LabelSqlJarLists);
        gd = new GridData();
        gd.horizontalIndent = 20;
        l.setLayoutData((Object)gd);
        this.definedControls.add((Control)l);
        this.fConnLocation = this.createTextControl(toolkit, parent);
        this.fConnLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EGLDDRootHelper.addOrUpdateParameter(EGLDDRootHelper.getParameters(SQLDatabaseBindingDetailPage.this.fSQLDatabaseBinding), "jarList", SQLDatabaseBindingDetailPage.this.fConnLocation.getText());
            }
        });
        this.definedControls.add((Control)this.fConnLocation);
        this.btnPing = new Button(parent, 0);
        this.btnPing.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLDatabaseBindingDetailPage.this.testConnection();
            }
        });
        GridData pingGD = new GridData(896);
        pingGD.horizontalSpan = 3;
        this.btnPing.setLayoutData((Object)pingGD);
        this.btnPing.setText(SOAMessages.SQLDatabaseBindingDetailPageTestConnection);
        this.definedControls.add((Control)this.btnPing);
    }

    protected void testConnection() {
        String vendorName = this.fDbms.getText();
        String profileProviderID = null;
        if (vendorName != null && vendorName.length() > 0) {
            profileProviderID = EGLSQLUtility.getConnectionProviderProfile((String)vendorName);
        }
        if (profileProviderID != null) {
            String profileDescription = "";
            String parentProfile = "";
            boolean isAutoConnect = false;
            ConnectionProfile profile = new ConnectionProfile(vendorName, profileDescription, profileProviderID, parentProfile, isAutoConnect);
            profile.setBaseProperties(this.getConnectionProfileProperties());
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)this.createTestConnectionRunnable((IConnectionProfile)profile));
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)SOAMessages.SQLDataBaseBindingTestConnectionNoVendorTitle, (String)NLS.bind((String)SOAMessages.SQLDataBaseBindingTestConnectionNoVendorMsg, (Object)(vendorName == null ? "" : vendorName)));
        }
    }

    private Properties getConnectionProfileProperties() {
        Properties copy = new Properties();
        copy.put("org.eclipse.datatools.connectivity.db.connectionProperties", "");
        copy.put("org.eclipse.datatools.connectivity.db.savePWD", (Object)false);
        if (this.fConnLocation.getText() != null) {
            copy.put("jarList", this.fConnLocation.getText().trim());
        }
        copy.put("org.eclipse.datatools.connectivity.db.username", this.fUserId.getText());
        copy.put("org.eclipse.datatools.connectivity.db.password", this.fSqlPassword.getText());
        copy.put("org.eclipse.datatools.connectivity.db.driverClass", this.fSqlJDBCDriverClass.getText());
        if (this.fSqlDB.getText() != null) {
            copy.put("org.eclipse.datatools.connectivity.db.URL", this.fSqlDB.getText().trim());
        }
        return copy;
    }

    protected Runnable createTestConnectionRunnable(IConnectionProfile profile) {
        PingJob pingJob = new PingJob(Display.getCurrent().getActiveShell(), profile);
        pingJob.schedule();
        return new Runnable((Job)pingJob){
            private final /* synthetic */ Job val$pingJob;
            {
                this.val$pingJob = job;
            }

            @Override
            public void run() {
                try {
                    this.val$pingJob.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }

    @Override
    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fSQLDatabaseBinding = ssel.size() == 1 ? (Binding)ssel.getFirstElement() : null;
        this.update();
    }

    @Override
    protected void update() {
        Parameters params;
        this.fNameText.setText(this.fSQLDatabaseBinding.getName() == null ? "" : this.fSQLDatabaseBinding.getName());
        String uri = this.fSQLDatabaseBinding.getUri();
        if (uri != null) {
            this.fUri.setText(this.fSQLDatabaseBinding.getUri());
        }
        if ((params = this.fSQLDatabaseBinding.getParameters()) != null) {
            String jarLists;
            String sqlpassword;
            String sqljdbcdriver;
            String sqlid;
            String sqldb;
            String dbms = EGLDDRootHelper.getParameterValue(params, "dbms");
            if (dbms != null) {
                this.fDbms.setText(dbms);
            }
            if ((sqldb = EGLDDRootHelper.getParameterValue(params, "sqlDB")) != null) {
                this.fSqlDB.setText(sqldb);
            }
            if ((sqlid = EGLDDRootHelper.getParameterValue(params, "sqlID")) != null) {
                this.fUserId.setText(sqlid);
            }
            if ((sqljdbcdriver = EGLDDRootHelper.getParameterValue(params, "sqlJDBCDriverClass")) != null) {
                this.fSqlJDBCDriverClass.setText(sqljdbcdriver);
            }
            if ((sqlpassword = EGLDDRootHelper.getParameterValue(params, "sqlPassword")) != null && sqlpassword.trim().length() > 0 && Encoder.isEncoded((String)sqlpassword)) {
                this.fSqlPassword.setText(Encoder.decode((String)sqlpassword));
            } else if (sqlpassword != null) {
                this.fSqlPassword.setText(sqlpassword);
            }
            String sqlschema = EGLDDRootHelper.getParameterValue(params, "sqlSchema");
            if (sqlschema != null) {
                this.fDefaultSchema.setText(sqlschema);
            }
            if ((jarLists = EGLDDRootHelper.getParameterValue(params, "jarList")) != null) {
                this.fConnLocation.setText(jarLists);
            }
        }
        if (this.fSQLDatabaseBinding.isUseURI()) {
            this.fUseURI.setSelection(true);
            this.fUseDefinedInfo.setSelection(false);
            for (Control c : this.definedControls) {
                c.setEnabled(false);
            }
        } else {
            this.fUseURI.setSelection(false);
            this.fUseDefinedInfo.setSelection(true);
            for (Control c : this.uriControls) {
                c.setEnabled(false);
            }
        }
    }

    @Override
    protected void HandleNameChanged() {
        this.fSQLDatabaseBinding.setName(this.fNameText.getText());
        this.refreshMainTableViewer();
    }
}

