/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.edt.compiler.ICompiler;
import org.eclipse.edt.compiler.tools.IRLoader;
import org.eclipse.edt.gen.CommandParameter;
import org.eclipse.edt.gen.CommandProcessor;
import org.eclipse.edt.gen.Generator;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.utils.LoadPartException;
import org.eclipse.edt.mof.serialization.IEnvironment;

public abstract class AbstractGeneratorCommand
extends CommandProcessor {
    private String templates = "";
    private String nativeTypes = "";
    private String primitiveTypes = "";
    private String EGLMessages = "";

    public AbstractGeneratorCommand() {
        String[] EGLMessageList;
        String[] primitiveTypeList;
        String[] nativeTypeList;
        String[] templateList;
        this.installParameter(true, "output", new String[]{"output", "out", "o"}, new String[1], "Output must identify the location to write the output");
        this.installParameter(true, "part", new String[]{"part", "p"}, new String[1], "Part must identify the part to be generated, which can contain an * for all matching parts");
        this.installParameter(true, "root", new String[]{"root", "r"}, new String[1], "Root must identify the root location to be used in generation");
        this.installParameter(false, "report", new String[]{"report"}, new Boolean[]{false, true}, "Report must be defined as true or false");
        String[] stringArray = templateList = this.getTemplatePath();
        int n = templateList.length;
        int n2 = 0;
        while (n2 < n) {
            String template = stringArray[n2];
            this.templates = String.valueOf(this.templates) + template + ";";
            ++n2;
        }
        String[] stringArray2 = nativeTypeList = this.getNativeTypePath();
        int n3 = nativeTypeList.length;
        n = 0;
        while (n < n3) {
            String nativeType = stringArray2[n];
            this.nativeTypes = String.valueOf(this.nativeTypes) + nativeType + ";";
            ++n;
        }
        String[] stringArray3 = primitiveTypeList = this.getPrimitiveTypePath();
        int n4 = primitiveTypeList.length;
        n3 = 0;
        while (n3 < n4) {
            String primitiveType = stringArray3[n3];
            this.primitiveTypes = String.valueOf(this.primitiveTypes) + primitiveType + ";";
            ++n3;
        }
        String[] stringArray4 = EGLMessageList = this.getEGLMessagePath();
        int n5 = EGLMessageList.length;
        n4 = 0;
        while (n4 < n5) {
            String EGLMessage2 = stringArray4[n4];
            this.EGLMessages = String.valueOf(this.EGLMessages) + EGLMessage2 + ";";
            ++n4;
        }
    }

    public String getTemplates() {
        return this.templates;
    }

    public String getNativeTypes() {
        return this.nativeTypes;
    }

    public String getPrimitiveTypes() {
        return this.primitiveTypes;
    }

    public String getEGLMessages() {
        return this.EGLMessages;
    }

    public abstract String[] getNativeTypePath();

    public abstract String[] getPrimitiveTypePath();

    public abstract String[] getEGLMessagePath();

    public abstract String[] getTemplatePath();

    /*
     * Exception decompiling
     */
    public void generate(String[] args, Generator generator, IEnvironment environment, ICompiler compiler) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void listAllFiles(File parent, List<File> files, String pattern) {
        if (parent.isDirectory()) {
            File[] children;
            File[] fileArray = children = parent.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isFile() && (child.getName().toLowerCase(Locale.ENGLISH).endsWith(".eglxml") || child.getName().toLowerCase(Locale.ENGLISH).endsWith(".ir"))) {
                    String name = child.getPath();
                    int prefixLength = pattern.indexOf("*");
                    if (name.length() >= prefixLength && name.substring(0, prefixLength).equalsIgnoreCase(pattern.substring(0, prefixLength)) && (pattern.length() <= prefixLength + 1 || name.toLowerCase(Locale.ENGLISH).endsWith(String.valueOf(pattern.substring(prefixLength + 1)) + ".eglxml") || name.toLowerCase(Locale.ENGLISH).endsWith(String.valueOf(pattern.substring(prefixLength + 1)) + ".ir"))) {
                        files.add(child);
                    }
                }
                this.listAllFiles(child, files, pattern);
                ++n2;
            }
        }
    }

    protected List<Part> loadEGLParts(ICompiler compiler) throws LoadPartException {
        ArrayList<Part> parts = new ArrayList<Part>();
        String rootName = (String)((CommandParameter)this.parameterMapping.get("root")).getValue();
        String partName = (String)((CommandParameter)this.parameterMapping.get("part")).getValue();
        if (partName.indexOf("*") >= 0) {
            String totalName = rootName.endsWith(File.separator) ? rootName : String.valueOf(rootName) + File.separator;
            totalName = partName.startsWith(File.separator) ? String.valueOf(totalName) + partName.substring(File.separator.length()) : String.valueOf(totalName) + partName;
            totalName = totalName.replace('\\', File.separatorChar);
            totalName = totalName.replace('/', File.separatorChar);
            totalName = totalName.replace('.', File.separatorChar);
            File irRootDirFile = new File(rootName);
            ArrayList<File> irfiles = new ArrayList<File>();
            this.listAllFiles(irRootDirFile, irfiles, totalName);
            for (File irfile : irfiles) {
                String irFileRelativePath = irfile.getAbsolutePath().substring(irRootDirFile.getAbsolutePath().length());
                if (irFileRelativePath.startsWith(File.separator)) {
                    irFileRelativePath = irFileRelativePath.substring(File.separator.length());
                }
                parts.add(IRLoader.loadEGLPart((String)rootName, (String)irFileRelativePath.substring(0, irFileRelativePath.lastIndexOf(".")).replace(File.separatorChar, '.'), null));
            }
        } else {
            parts.add(IRLoader.loadEGLPart((String)rootName, (String)partName, (ICompiler)compiler));
        }
        return parts;
    }

    protected void writeFile(Part part, Generator generator) throws Exception {
        int offset;
        String fileName = ((String)((CommandParameter)this.parameterMapping.get("output")).getValue()).replaceAll("\\\\", "/");
        if (!fileName.endsWith("/")) {
            fileName = String.valueOf(fileName) + "/";
        }
        if ((offset = (fileName = String.valueOf(fileName) + generator.getRelativeFileName(part)).lastIndexOf("/")) > 0) {
            new File(fileName.substring(0, offset)).mkdirs();
        }
        FileWriter writer = new FileWriter(fileName);
        writer.write(generator.getResult().toString());
        writer.close();
        generator.processFile(fileName);
    }
}

