/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.edt.debug.core.EGLPackageFragmentRootSourceContainer;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;

public abstract class EGLSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    protected void buildContainers(IEGLProject project, List allEntries, Set<IEGLProject> seen) {
        if (seen.contains(project)) {
            return;
        }
        seen.add(project);
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IEGLPathEntry[] entries = project.getResolvedEGLPath(true);
            int i = 0;
            while (i < entries.length) {
                switch (entries[i].getEntryKind()) {
                    case 2: {
                        IResource member = root.findMember(entries[i].getPath());
                        if (member == null || member.getType() != 4) break;
                        IProject p = (IProject)member;
                        try {
                            if (!p.hasNature(EGLCore.NATURE_ID)) break;
                            this.buildContainers(EGLCore.create((IProject)p), allEntries, seen);
                        }
                        catch (CoreException coreException) {}
                        break;
                    }
                    case 3: {
                        EGLPackageFragmentRootSourceContainer container;
                        IPackageFragmentRoot pkgRoot = project.getPackageFragmentRoot(entries[i].getPath());
                        if (pkgRoot != null) {
                            EGLPackageFragmentRootSourceContainer container2 = new EGLPackageFragmentRootSourceContainer(pkgRoot);
                            if (allEntries.contains((Object)container2)) break;
                            allEntries.add(container2);
                            break;
                        }
                        IResource member = root.findMember(entries[i].getPath());
                        if (member == null || member.getType() != 2 || allEntries.contains((Object)(container = new FolderSourceContainer((IContainer)((IFolder)member), true)))) break;
                        allEntries.add(container);
                        break;
                    }
                    case 1: {
                        EGLPackageFragmentRootSourceContainer container;
                        IPath sourcePath = entries[i].getSourceAttachmentPath();
                        if (sourcePath == null || sourcePath.isEmpty()) break;
                        IPackageFragmentRoot pkgRoot = project.getPackageFragmentRoot(entries[i].getPath());
                        if (pkgRoot != null) {
                            container = new EGLPackageFragmentRootSourceContainer(pkgRoot);
                            if (allEntries.contains((Object)container)) break;
                            allEntries.add(container);
                            break;
                        }
                        IResource file = root.findMember(sourcePath);
                        Object container3 = file != null && file.getType() == 1 ? new ArchiveSourceContainer((IFile)file, true) : new ExternalArchiveSourceContainer(sourcePath.toOSString(), true);
                        if (allEntries.contains(container3)) break;
                        allEntries.add(container3);
                    }
                }
                ++i;
            }
        }
        catch (EGLModelException eGLModelException) {}
    }
}

