/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.util;

import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.ui.internal.widgets.NullPostExecution;
import org.eclipse.jpt.common.ui.internal.widgets.PostExecution;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTUtil {
    public static void asyncExec(Runnable runnable) {
        SWTUtil.getStandardDisplay().asyncExec(runnable);
    }

    public static void attachDefaultValueHandler(Combo combo) {
        ComboHandler handler = new ComboHandler();
        combo.addFocusListener((FocusListener)handler);
        combo.addModifyListener((ModifyListener)handler);
    }

    public static String buildDisplayString(Class<?> nlsClass, Class<?> compositeClass, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append(compositeClass.getSimpleName());
        sb.append("_");
        sb.append(value.toString().toLowerCase(Locale.ENGLISH));
        return (String)ReflectionTools.getStaticFieldValue(nlsClass, (String)sb.toString());
    }

    public static final String buildDisplayString(Class<?> nlsClass, Object composite, Object value) {
        return SWTUtil.buildDisplayString(nlsClass, composite.getClass(), value);
    }

    private static <D1 extends Dialog, D2 extends D1> Runnable buildPostExecutionRunnable(final D1 dialog, final PostExecution<D2> postExecution) {
        return new Runnable(){

            public void run() {
                SWTUtil.setUserInterfaceActive(false);
                try {
                    postExecution.execute(dialog);
                }
                finally {
                    SWTUtil.setUserInterfaceActive(true);
                }
            }
        };
    }

    public static Shell getShell() {
        Shell shell = SWTUtil.getStandardDisplay().getActiveShell();
        if (shell == null) {
            shell = SWTUtil.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        if (shell == null) {
            shell = new Shell(SWTUtil.getStandardDisplay().getActiveShell());
        }
        return shell;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static int getTableHeightHint(Table table, int rows) {
        if (table.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            table.setFont(JFaceResources.getDialogFont());
        }
        int result = table.getItemHeight() * rows + table.getHeaderHeight();
        if (table.getLinesVisible()) {
            result += table.getGridLineWidth() * (rows - 1);
        }
        return result;
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static void reflow(Composite pane) {
        Composite composite = pane;
        while (composite != null) {
            composite.setRedraw(false);
            composite = composite.getParent();
            if (composite instanceof ScrolledForm || composite instanceof Shell) break;
        }
        for (composite = pane; composite != null; composite = composite.getParent()) {
            composite.layout(true);
            if (!(composite instanceof ScrolledForm)) continue;
            ((ScrolledForm)composite).reflow(true);
            break;
        }
        composite = pane;
        while (composite != null) {
            composite.setRedraw(true);
            composite = composite.getParent();
            if (composite instanceof ScrolledForm || composite instanceof Shell) break;
        }
    }

    public static void setUserInterfaceActive(boolean active) {
        Shell[] shells;
        Shell[] shellArray = shells = SWTUtil.getStandardDisplay().getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            shell.setEnabled(active);
            ++n2;
        }
    }

    public static <D1 extends Dialog, D2 extends D1> void show(final D1 dialog, final PostExecution<D2> postExecution) {
        try {
            Assert.isNotNull(dialog, (String)"The dialog cannot be null");
            Assert.isNotNull(postExecution, (String)"The PostExecution cannot be null");
        }
        catch (AssertionFailedException e) {
            SWTUtil.setUserInterfaceActive(true);
            throw e;
        }
        new Thread(){

            public void run() {
                SWTUtil.asyncExec(new Runnable(){

                    public void run() {
                        SWTUtil.showImp(dialog, postExecution);
                    }
                });
            }
        }.start();
    }

    public static void show(Dialog dialog) {
        SWTUtil.show(dialog, NullPostExecution.instance());
    }

    private static <D1 extends Dialog, D2 extends D1> void showImp(D1 dialog, PostExecution<D2> postExecution) {
        SWTUtil.setUserInterfaceActive(true);
        dialog.open();
        if (postExecution != NullPostExecution.instance()) {
            SWTUtil.asyncExec(SWTUtil.buildPostExecutionRunnable(dialog, postExecution));
        }
    }

    public static void syncExec(Runnable runnable) {
        SWTUtil.getStandardDisplay().syncExec(runnable);
    }

    public static boolean uiThread() {
        return SWTUtil.getStandardDisplay().getThread() == Thread.currentThread();
    }

    public static boolean uiThread(Viewer viewer) {
        return SWTUtil.uiThread((Widget)viewer.getControl());
    }

    public static boolean uiThread(Widget widget) {
        return widget.getDisplay().getThread() == Thread.currentThread();
    }

    private static class ComboHandler
    implements ModifyListener,
    FocusListener {
        private ComboHandler() {
        }

        public void focusGained(FocusEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.getSelectionIndex() == 0) {
                SWTUtil.asyncExec(new SelectText(combo));
            }
        }

        public void focusLost(FocusEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            Combo combo = (Combo)e.widget;
            if (combo.isFocusControl() && combo.getSelectionIndex() == 0) {
                SWTUtil.asyncExec(new ModifyText(combo));
            }
        }

        private class ModifyText
        implements Runnable {
            private final Combo combo;

            public ModifyText(Combo combo) {
                this.combo = combo;
            }

            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                if (text.length() == 0) {
                    text = this.combo.getItem(0);
                    this.combo.setText(text);
                }
                this.combo.setSelection(new Point(0, text.length()));
            }
        }

        private class SelectText
        implements Runnable {
            private final Combo combo;

            public SelectText(Combo combo) {
                this.combo = combo;
            }

            public void run() {
                if (this.combo.isDisposed()) {
                    return;
                }
                String text = this.combo.getText();
                this.combo.setSelection(new Point(0, text.length()));
            }
        }
    }
}

