/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.edt.compiler.AbstractProcessingQueue;
import org.eclipse.edt.compiler.EGL2IREnvironment;
import org.eclipse.edt.compiler.ISystemEnvironment;
import org.eclipse.edt.compiler.SDKContext;
import org.eclipse.edt.compiler.Util;
import org.eclipse.edt.compiler.binding.FileBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.BindingCreator;
import org.eclipse.edt.compiler.internal.core.lookup.EnvironmentScope;
import org.eclipse.edt.compiler.internal.core.lookup.FileScope;
import org.eclipse.edt.compiler.internal.core.lookup.FunctionContainerScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.compiler.internal.core.lookup.SystemScope;
import org.eclipse.edt.compiler.internal.egl2mof.Egl2Mof;
import org.eclipse.edt.compiler.internal.io.IRFileNameUtility;
import org.eclipse.edt.compiler.internal.sdk.compile.ASTManager;
import org.eclipse.edt.compiler.internal.sdk.compile.Compiler;
import org.eclipse.edt.compiler.internal.sdk.compile.DefaultSDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.DependencyInfo;
import org.eclipse.edt.compiler.internal.sdk.compile.IProcessor;
import org.eclipse.edt.compiler.internal.sdk.compile.ISDKProblemRequestorFactory;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathEntry;
import org.eclipse.edt.compiler.internal.sdk.compile.SourcePathInfo;
import org.eclipse.edt.compiler.internal.sdk.compile.TopLevelFunctionProcessor;
import org.eclipse.edt.compiler.internal.util.TopLevelFunctionInfo;
import org.eclipse.edt.mof.MofSerializable;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class Processor
extends AbstractProcessingQueue
implements IProcessor {
    private EGL2IREnvironment environment;
    private ISDKProblemRequestorFactory problemRequestorFactory;
    private ISystemEnvironment sysEnv;

    public Processor(IBuildNotifier notifier, ICompilerOptions compilerOptions, ISDKProblemRequestorFactory problemRequestorFactory, ISystemEnvironment sysEnv) {
        super(notifier, compilerOptions);
        this.problemRequestorFactory = problemRequestorFactory;
        if (problemRequestorFactory == null) {
            this.problemRequestorFactory = new DefaultSDKProblemRequestorFactory();
        }
        this.sysEnv = sysEnv;
    }

    public void setEnvironment(EGL2IREnvironment environment) {
        this.environment = environment;
    }

    @Override
    public boolean hasExceededMaxLoop() {
        return false;
    }

    @Override
    public IPartBinding level03Compile(String[] packageName, String caseSensitiveInternedPartName) {
        IPartBinding binding;
        String caseInsensitiveInternedPartName = InternUtil.intern((String)caseSensitiveInternedPartName);
        java.io.File declaringFile = SourcePathInfo.getInstance().getDeclaringFile(packageName, caseInsensitiveInternedPartName);
        Node partAST = ASTManager.getInstance().getAST(declaringFile, caseInsensitiveInternedPartName);
        if (partAST instanceof File) {
            File errorFile = ASTManager.getInstance().getFileAST(declaringFile);
            errorFile.accept(this.problemRequestorFactory.getSyntaxErrorRequestor(declaringFile));
        }
        if ((binding = new BindingCreator(this.environment, packageName, caseSensitiveInternedPartName, partAST).getPartBinding()).getKind() != 16 && binding.getKind() != 20) {
            System.out.println();
            System.out.println("Processing Part: " + caseInsensitiveInternedPartName);
        }
        binding.setEnvironment(this.environment);
        DependencyInfo dependencyInfo = new DependencyInfo();
        Scope scope = this.createPartScope(packageName, declaringFile, binding, dependencyInfo);
        IProblemRequestor problemRequestor = this.createProblemRequestor(declaringFile, partAST, binding);
        Compiler.getInstance().compilePart(partAST, binding, scope, dependencyInfo, problemRequestor, this.compilerOptions);
        TopLevelFunctionInfo[] functions = null;
        if (dependencyInfo.getFunctionContainerScope() != null) {
            functions = this.processTopLevelFunctions(dependencyInfo.getTopLevelFunctions(), dependencyInfo.getFunctionContainerScope(), dependencyInfo);
        }
        if (binding.getKind() != 16) {
            File fileAST = ASTManager.getInstance().getFileAST(declaringFile);
            MofSerializable part = this.createIRFromBoundAST2(partAST, declaringFile, functions, fileAST.getImportDeclarations(), problemRequestor);
            if (part == null) {
                System.out.println("Part is null!");
                return binding;
            }
            this.environment.save(part, true);
        }
        return binding;
    }

    private java.io.File getPackage(java.io.File path, String[] packageName) {
        java.io.File root = path;
        int i = 0;
        while (i < packageName.length) {
            java.io.File subFolder = new java.io.File(root, IRFileNameUtility.toIRFileName(packageName[i]));
            if (!subFolder.exists()) {
                subFolder.mkdir();
            }
            root = subFolder;
            ++i;
        }
        return root;
    }

    private Scope createPartScope(String[] packageName, java.io.File declaringFile, IPartBinding binding, IDependencyRequestor dependencyRequestor) {
        Scope scope;
        if (binding.getKind() == 16) {
            scope = new EnvironmentScope(this.environment, dependencyRequestor);
        } else {
            String fileName = Util.getFilePartName(declaringFile);
            IPartBinding fileBinding = this.environment.getPartBinding(packageName, fileName);
            scope = new SystemScope(new FileScope(new EnvironmentScope(this.environment, dependencyRequestor), (FileBinding)fileBinding, dependencyRequestor), this.sysEnv);
        }
        return scope;
    }

    private MofSerializable createIRFromBoundAST2(Node partAST, java.io.File declaringFile, TopLevelFunctionInfo[] functions, List imports, IProblemRequestor problemRequestor) {
        Egl2Mof generator = new Egl2Mof(this.environment);
        return (MofSerializable)generator.convert((Part)partAST, new SDKContext(declaringFile), problemRequestor);
    }

    private IProblemRequestor createProblemRequestor(java.io.File file, Node partAST, IPartBinding binding) {
        IProblemRequestor newRequestor = this.problemRequestorFactory.getProblemRequestor(file, binding.getName());
        if (binding.getKind() == 20) {
            newRequestor = this.problemRequestorFactory.getGenericTopLevelFunctionProblemRequestor(file, binding.getName(), ((TopLevelFunction)partAST).isContainerContextDependent());
        }
        return newRequestor;
    }

    @Override
    public IPartBinding level02Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return SourcePathEntry.getInstance().compileLevel2Binding(packageName, caseSensitiveInternedPartName);
    }

    @Override
    public IPartBinding level01Compile(String[] packageName, String caseSensitiveInternedPartName) {
        return this.environment.level01Compile(packageName, caseSensitiveInternedPartName);
    }

    @Override
    public IPartBinding getPartBindingFromCache(String[] packageName, String partName) {
        return SourcePathEntry.getInstance().getPartBindingFromCache(packageName, partName);
    }

    private TopLevelFunctionInfo[] processTopLevelFunctions(Set topLevelFunctions, FunctionContainerScope contextScope, DependencyInfo dependencyInfo) {
        TopLevelFunctionProcessor queue = new TopLevelFunctionProcessor(this.environment, contextScope, dependencyInfo, this.compilerOptions, this.problemRequestorFactory);
        Iterator iter = topLevelFunctions.iterator();
        while (iter.hasNext()) {
            IPartBinding cfr_ignored_0 = (IPartBinding)iter.next();
        }
        return queue.process();
    }

    @Override
    public void doAddPart(String[] packageName, String caseInsensitiveInternedPartName) {
        this.addPart(packageName, SourcePathInfo.getInstance().getCaseSensitivePartName(packageName, caseInsensitiveInternedPartName));
    }
}

