/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordFieldBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.ArrayType;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.NameType;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Record;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.StructureItem;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.builder.NullProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.DataBindingScope;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultBinder;
import org.eclipse.edt.compiler.internal.core.lookup.FlexibleRecordScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FlexibleRecordBindingFieldsCompletor
extends AbstractBinder {
    private FlexibleRecordBinding recordBinding;
    private String canonicalRecordName;
    private IProblemRequestor problemRequestor;
    private boolean visitingFirstItem = true;
    private Set definedNames = new HashSet();
    private Map fieldNamesToNodes = new HashMap();

    public FlexibleRecordBindingFieldsCompletor(Scope currentScope, FlexibleRecordBinding recordBinding, String canonicalRecordName, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, recordBinding, dependencyRequestor, compilerOptions);
        this.recordBinding = recordBinding;
        this.canonicalRecordName = canonicalRecordName;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(Record record) {
        return true;
    }

    @Override
    public boolean visit(SettingsBlock settingsBlock) {
        return false;
    }

    @Override
    public boolean visit(StructureItem structureItem) {
        FlexibleRecordFieldBinding fieldBinding;
        FlexibleRecordBinding flexBinding;
        ITypeBinding typeBinding = null;
        try {
            if (structureItem.hasType() && (typeBinding = this.bindType(structureItem.getType())).getBaseType().getKind() == 7) {
                flexBinding = (FlexibleRecordBinding)typeBinding.getBaseType();
                this.recordBinding.addReferencedRecord(flexBinding);
                if (this.loopExists(flexBinding)) {
                    this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5057, new String[]{typeBinding.getBaseType().getCaseSensitiveName()});
                    if (structureItem.getName() != null) {
                        structureItem.getName().setBinding(IBinding.NOT_FOUND_BINDING);
                    }
                    structureItem.getType().accept(new DefaultASTVisitor(){

                        @Override
                        public boolean visit(NameType nameType) {
                            nameType.getName().setBinding(IBinding.NOT_FOUND_BINDING);
                            return false;
                        }

                        @Override
                        public boolean visit(ArrayType arrayType) {
                            arrayType.setTypeBinding(null);
                            return false;
                        }
                    });
                    return false;
                }
            }
        }
        catch (ResolutionException e) {
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            if (structureItem.hasSettingsBlock()) {
                FlexibleRecordBindingFieldsCompletor.bindNamesToNotFound(structureItem.getSettingsBlock());
            }
            return false;
        }
        if (structureItem.hasLevel()) {
            if (this.visitingFirstItem) {
                this.problemRequestor.acceptProblem((Node)structureItem, 7875, new String[]{this.recordBinding.getSubType().getName()});
            } else {
                this.problemRequestor.acceptProblem((Node)structureItem, 5063, new String[]{this.getCanonicalName(structureItem)});
            }
        } else {
            this.visitingFirstItem = false;
        }
        if (structureItem.isFiller()) {
            fieldBinding = this.createField(structureItem, typeBinding);
            this.recordBinding.addField(fieldBinding);
            structureItem.accept(new FieldCompletor(this.currentScope, fieldBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            structureItem.setBinding(fieldBinding);
            return false;
        }
        if (structureItem.isEmbedded()) {
            if (typeBinding.getKind() == 7) {
                flexBinding = (FlexibleRecordBinding)typeBinding;
                if (!flexBinding.isValid()) {
                    flexBinding = (FlexibleRecordBinding)flexBinding.realize();
                }
                for (FlexibleRecordFieldBinding nextBinding : flexBinding.getDeclaredFields()) {
                    if (this.definedNames.contains(nextBinding.getName())) continue;
                    this.definedNames.add(nextBinding.getName());
                    this.recordBinding.addField(nextBinding);
                }
                return false;
            }
            if (typeBinding.getKind() == 6) {
                this.problemRequestor.acceptProblem(structureItem.getType(), 4026);
                return false;
            }
            this.problemRequestor.acceptProblem((Node)structureItem.getType(), 5060, new String[]{structureItem.getType().getCanonicalName()});
            return false;
        }
        if (!structureItem.hasType()) {
            this.problemRequestor.acceptProblem((Node)structureItem.getName(), 4035, new String[]{structureItem.getName().getCanonicalName()});
            typeBinding = PrimitiveTypeBinding.getInstance(Primitive.CHAR, 0);
        }
        if ((fieldBinding = this.createField(structureItem, typeBinding)) != null) {
            if (this.definedNames.contains(fieldBinding.getName())) {
                this.problemRequestor.acceptProblem((Node)structureItem.getName(), 3010, new String[]{structureItem.getName().getCanonicalName(), this.canonicalRecordName});
            } else {
                this.definedNames.add(fieldBinding.getName());
                this.recordBinding.addField(fieldBinding);
            }
            structureItem.accept(new FieldCompletor(this.currentScope, fieldBinding, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
        }
        return false;
    }

    public boolean loopExists(FlexibleRecordBinding recType) {
        if (recType.containsReferenceTo(this.recordBinding)) {
            return true;
        }
        return !recType.isValid && (recType = (FlexibleRecordBinding)recType.realize()).containsReferenceTo(this.recordBinding);
    }

    public FlexibleRecordFieldBinding createField(StructureItem structureItem, ITypeBinding typeBinding) {
        String fieldName = structureItem.isFiller() ? InternUtil.internCaseSensitive((String)"*") : structureItem.getName().getCaseSensitiveIdentifier();
        FlexibleRecordFieldBinding field = new FlexibleRecordFieldBinding(fieldName, this.recordBinding, typeBinding);
        if (!structureItem.isFiller()) {
            structureItem.getName().setBinding(field);
            this.fieldNamesToNodes.put(fieldName, structureItem.getName());
        }
        return field;
    }

    private String getCanonicalName(StructureItem sItem) {
        if (sItem.isEmbedded()) {
            return sItem.getType().getCanonicalName();
        }
        if (sItem.isFiller()) {
            return "*";
        }
        return sItem.getName().getCanonicalName();
    }

    public Node getNode(String fieldName) {
        return (Node)this.fieldNamesToNodes.get(fieldName);
    }

    public class FieldCompletor
    extends DefaultBinder {
        private FlexibleRecordFieldBinding fieldBinding;

        public FieldCompletor(Scope currentScope, FlexibleRecordFieldBinding fieldBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
            super(currentScope, fieldBinding.getDeclaringPart(), dependencyRequestor, problemRequestor, compilerOptions);
            this.fieldBinding = fieldBinding;
        }

        @Override
        public boolean visit(StructureItem structureItem) {
            if (structureItem.hasSettingsBlock()) {
                structureItem.getSettingsBlock().accept(this);
            }
            if (structureItem.hasInitializer()) {
                this.fieldBinding.setInitialValue(FieldCompletor.getConstantValue(structureItem.getInitializer(), NullProblemRequestor.getInstance(), true));
            }
            return false;
        }

        @Override
        public void endVisit(StructureItem structureItem) {
        }

        @Override
        public boolean visit(SettingsBlock settingsBlock) {
            DataBindingScope fieldScope = new DataBindingScope(this.currentScope, this.fieldBinding);
            AnnotationLeftHandScope annotationScope = new AnnotationLeftHandScope(fieldScope, this.fieldBinding, this.fieldBinding.getType(), this.fieldBinding, -1, this.fieldBinding.getDeclaringPart());
            settingsBlock.accept(new SettingsBlockAnnotationBindingsCompletor(new FlexibleRecordScope(this.currentScope, FlexibleRecordBindingFieldsCompletor.this.recordBinding), this.fieldBinding.getDeclaringPart(), annotationScope, this.dependencyRequestor, this.problemRequestor, this.compilerOptions));
            return false;
        }
    }
}

