/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FormGroupDataBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.StaticPartDataBinding;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;

public class FormGroupBinding
extends PartBinding {
    private transient FormGroupDataBinding staticFormGroupDataBinding;
    List nestedForms = Collections.EMPTY_LIST;
    List usedForms = Collections.EMPTY_LIST;

    public FormGroupBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    public List getForms() {
        ArrayList result = new ArrayList();
        result.addAll(this.realizeUsedForms());
        result.addAll(this.nestedForms);
        return result;
    }

    private List realizeUsedForms() {
        ArrayList<ITypeBinding> list = new ArrayList<ITypeBinding>();
        for (FormBinding form : this.usedForms) {
            list.add(this.realizeTypeBinding(form, this.getEnvironment()));
        }
        return list;
    }

    public void addUsedForm(ITypeBinding formBinding) {
        if (this.usedForms == Collections.EMPTY_LIST) {
            this.usedForms = new ArrayList();
        }
        this.usedForms.add(formBinding);
    }

    public void addNestedForm(ITypeBinding formBinding) {
        if (this.nestedForms == Collections.EMPTY_LIST) {
            this.nestedForms = new ArrayList();
        }
        this.nestedForms.add(formBinding);
    }

    @Override
    public int getKind() {
        return 9;
    }

    @Override
    public void clear() {
        super.clear();
        this.nestedForms = Collections.EMPTY_LIST;
        this.usedForms = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isStructurallyEqual(IPartBinding anotherPartBinding) {
        return false;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (FormBinding nextForm : this.getForms()) {
            if (nextForm.getName() != simpleName) continue;
            return nextForm.getStaticFormDataBinding();
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    public ITypeBinding findForm(String simpleName) {
        for (FormBinding nextForm : this.getForms()) {
            if (nextForm.getName() != simpleName) continue;
            return nextForm;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public boolean isDeclarablePart() {
        return false;
    }

    @Override
    public void setEnvironment(IEnvironment environment) {
        super.setEnvironment(environment);
        for (FormBinding form : this.nestedForms) {
            form.setEnvironment(environment);
        }
    }

    @Override
    public StaticPartDataBinding getStaticPartDataBinding() {
        return (StaticPartDataBinding)this.getStaticFormGroupDataBinding();
    }

    public IDataBinding getStaticFormGroupDataBinding() {
        if (this.staticFormGroupDataBinding == null) {
            this.staticFormGroupDataBinding = new FormGroupDataBinding(this.getCaseSensitiveName(), this, this);
        }
        return this.staticFormGroupDataBinding;
    }

    public List getNestedForms() {
        return this.nestedForms;
    }

    public List getUsedForms() {
        return this.usedForms;
    }

    @Override
    public ITypeBinding primGetNullableInstance() {
        return this;
    }
}

