/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.SettingsBlockAnnotationBindingsCompletor;
import org.eclipse.edt.compiler.core.ast.ConverseStatement;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.NestedFunction;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.TopLevelFunction;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.dependency.IDependencyRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.AnnotationLeftHandScope;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ResolutionException;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FunctionBindingCompletor
extends AbstractBinder {
    private FunctionBinding functionBinding;
    private IPartBinding partBinding;
    private IProblemRequestor problemRequestor;
    private Set definedParameters = new HashSet();
    private String canonicalFunctionName;

    public FunctionBindingCompletor(IPartBinding partBinding, Scope currentScope, FunctionBinding functionBinding, IDependencyRequestor dependencyRequestor, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        super(currentScope, partBinding, dependencyRequestor, compilerOptions);
        this.partBinding = partBinding;
        this.functionBinding = functionBinding;
        this.problemRequestor = problemRequestor;
    }

    @Override
    public boolean visit(NestedFunction function) {
        function.getName().setBinding(this.functionBinding);
        this.canonicalFunctionName = function.getName().getCanonicalName();
        this.functionBinding.setStatic(function.isStatic());
        this.functionBinding.setAbstract(function.isAbstract());
        this.functionBinding.setPrivate(function.isPrivate());
        function.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(NestedFunction function) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(FunctionBindingCompletor.this.currentScope, FunctionBindingCompletor.this.functionBinding, null, FunctionBindingCompletor.this.functionBinding, -1, FunctionBindingCompletor.this.functionBinding.getDeclarer());
                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(FunctionBindingCompletor.this.currentScope, FunctionBindingCompletor.this.functionBinding.getDeclarer(), scope, FunctionBindingCompletor.this.dependencyRequestor, FunctionBindingCompletor.this.problemRequestor, FunctionBindingCompletor.this.compilerOptions);
                settingsBlock.accept(blockCompletor);
                return false;
            }
        });
        if (function.hasReturnType()) {
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindType(function.getReturnType());
                if (this.checkReturnType(function.getReturnType(), typeBinding)) {
                    this.partBinding.getAnnotation(new String[]{"egl", "core"}, "I4GLItemsNullable");
                    this.functionBinding.setReturnType(typeBinding);
                    this.functionBinding.setReturnTypeIsSqlNullable(function.returnTypeIsSqlNullable());
                }
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            }
        }
        return true;
    }

    @Override
    public boolean visit(TopLevelFunction function) {
        function.getName().setBinding(this.functionBinding);
        this.canonicalFunctionName = function.getName().getCanonicalName();
        function.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(TopLevelFunction function) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                AnnotationLeftHandScope scope = new AnnotationLeftHandScope(FunctionBindingCompletor.this.currentScope, FunctionBindingCompletor.this.functionBinding, null, FunctionBindingCompletor.this.functionBinding, -1, FunctionBindingCompletor.this.functionBinding.getDeclarer());
                SettingsBlockAnnotationBindingsCompletor blockCompletor = new SettingsBlockAnnotationBindingsCompletor(FunctionBindingCompletor.this.currentScope, FunctionBindingCompletor.this.functionBinding.getDeclarer(), scope, FunctionBindingCompletor.this.dependencyRequestor, FunctionBindingCompletor.this.problemRequestor, FunctionBindingCompletor.this.compilerOptions);
                settingsBlock.accept(blockCompletor);
                return false;
            }
        });
        if (function.hasReturnType()) {
            ITypeBinding typeBinding = null;
            try {
                typeBinding = this.bindType(function.getReturnType());
            }
            catch (ResolutionException e) {
                this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
                return false;
            }
            if (this.checkReturnType(function.getReturnType(), typeBinding)) {
                this.functionBinding.setReturnType(typeBinding);
                this.functionBinding.setReturnTypeIsSqlNullable(function.returnTypeIsSqlNullable());
            }
        }
        this.functionBinding.setPrivate(function.isPrivate());
        return true;
    }

    @Override
    public void endVisit(TopLevelFunction function) {
        ((IPartBinding)((Object)this.functionBinding)).setValid(true);
    }

    private boolean checkReturnType(Type type, ITypeBinding typeBinding) {
        if (!typeBinding.isReference() && 17 != typeBinding.getKind() && 3 != typeBinding.getKind() && 7 != typeBinding.getKind() && 6 != typeBinding.getKind() && 19 != typeBinding.getKind() && typeBinding != DictionaryBinding.INSTANCE && typeBinding != ArrayDictionaryBinding.INSTANCE) {
            this.problemRequestor.acceptProblem((Node)type, 4914, new String[]{type.getCanonicalName(), this.canonicalFunctionName});
            return false;
        }
        if (this.partBinding != null && this.partBinding.getAnnotation(new String[]{"egl", "ui", "jasper"}, "JasperReport") != null && 17 != typeBinding.getKind() && 3 != typeBinding.getKind()) {
            this.problemRequestor.acceptProblem(type, 7711);
        }
        return true;
    }

    @Override
    public boolean visit(FunctionParameter functionParameter) {
        String parmName = functionParameter.getName().getIdentifier();
        Type parmType = functionParameter.getType();
        ITypeBinding typeBinding = null;
        try {
            typeBinding = this.bindType(parmType);
            if (this.currentScope.I4GLItemsNullableIsEnabled() && 3 == typeBinding.getBaseType().getKind()) {
                typeBinding = typeBinding.getNullableInstance();
            }
        }
        catch (ResolutionException e) {
            functionParameter.getName().setBinding(new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), this.partBinding, IBinding.NOT_FOUND_BINDING, this.functionBinding));
            this.problemRequestor.acceptProblem(e.getStartOffset(), e.getEndOffset(), 2, e.getProblemKind(), e.getInserts());
            return false;
        }
        FunctionParameterBinding funcParmBinding = new FunctionParameterBinding(functionParameter.getName().getCaseSensitiveIdentifier(), this.partBinding, typeBinding, this.functionBinding);
        functionParameter.getName().setBinding(funcParmBinding);
        if (!BindingUtilities.isValidDeclarationType(typeBinding)) {
            this.problemRequestor.acceptProblem((Node)parmType, 4902, new String[]{functionParameter.getName().getCanonicalName(), this.canonicalFunctionName});
            return false;
        }
        FunctionParameter.AttrType attrType = functionParameter.getAttrType();
        if (attrType == FunctionParameter.AttrType.FIELD) {
            funcParmBinding.setField(true);
        } else if (attrType == FunctionParameter.AttrType.SQLNULLABLE) {
            funcParmBinding.setSqlNullable(true);
        }
        funcParmBinding.setConst(functionParameter.isParmConst());
        FunctionParameter.UseType useType = functionParameter.getUseType();
        if (useType == FunctionParameter.UseType.IN) {
            funcParmBinding.setInput(true);
        } else if (useType == FunctionParameter.UseType.OUT) {
            funcParmBinding.setOutput(true);
        } else if (useType == null && Binding.isValidBinding(typeBinding) && typeBinding.isReference()) {
            funcParmBinding.setInput(true);
        }
        if (this.definedParameters.contains(parmName)) {
            this.problemRequestor.acceptProblem((Node)functionParameter, 3012, new String[]{parmName, this.functionBinding.getCaseSensitiveName()});
        } else {
            this.functionBinding.addParameter(funcParmBinding);
            this.definedParameters.add(parmName);
        }
        return false;
    }

    @Override
    public boolean visit(ConverseStatement converseStatement) {
        this.functionBinding.setHasConverse(true);
        return false;
    }
}

