/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.NestedFunctionBinding;
import org.eclipse.edt.compiler.binding.OverloadedFunctionSet;
import org.eclipse.edt.compiler.binding.PartBinding;

public abstract class FunctionContainerBinding
extends PartBinding {
    private List classFields = Collections.EMPTY_LIST;
    private List declaredFunctions = Collections.EMPTY_LIST;

    public FunctionContainerBinding(String[] packageName, String caseSensitiveInternedName) {
        super(packageName, caseSensitiveInternedName);
    }

    public FunctionContainerBinding(FunctionContainerBinding old) {
        super(old);
        if (old.classFields == Collections.EMPTY_LIST) {
            old.classFields = new ArrayList();
        }
        if (old.declaredFunctions == Collections.EMPTY_LIST) {
            old.declaredFunctions = new ArrayList();
        }
        this.classFields = old.classFields;
        this.declaredFunctions = old.declaredFunctions;
    }

    public List getClassFields() {
        return this.classFields;
    }

    public List getDeclaredData() {
        return this.classFields;
    }

    public List getDeclaredData(boolean includeSuperType) {
        if (!includeSuperType) {
            return this.classFields;
        }
        LinkedList retList = new LinkedList();
        retList.addAll(this.classFields);
        IPartBinding spBinding = this.getDefaultSuperType();
        if (spBinding instanceof FunctionContainerBinding) {
            retList.addAll(((FunctionContainerBinding)spBinding).getDeclaredData(includeSuperType));
        } else if (spBinding instanceof ExternalTypeBinding) {
            retList.addAll(((ExternalTypeBinding)spBinding).getDeclaredAndInheritedData());
        }
        return retList;
    }

    public void addClassField(ClassFieldBinding fieldBinding) {
        if (this.classFields == Collections.EMPTY_LIST) {
            this.classFields = new ArrayList();
        }
        this.classFields.add(fieldBinding);
    }

    @Override
    public List getDeclaredFunctions() {
        return this.declaredFunctions;
    }

    public List getDeclaredFunctions(boolean includeSuperType) {
        if (!includeSuperType) {
            return this.declaredFunctions;
        }
        LinkedList retList = new LinkedList();
        retList.addAll(this.declaredFunctions);
        IPartBinding spBinding = this.getDefaultSuperType();
        if (spBinding instanceof FunctionContainerBinding) {
            retList.addAll(((FunctionContainerBinding)spBinding).getDeclaredFunctions(includeSuperType));
        } else if (spBinding instanceof ExternalTypeBinding) {
            retList.addAll(((ExternalTypeBinding)spBinding).getDeclaredAndInheritedFunctions());
        }
        return retList;
    }

    public void addDeclaredFunction(NestedFunctionBinding functionBinding) {
        if (this.declaredFunctions == Collections.EMPTY_LIST) {
            this.declaredFunctions = new ArrayList();
        }
        this.declaredFunctions.add(functionBinding);
    }

    public void addDeclaredFunctions(List functionBindings) {
        if (this.declaredFunctions == Collections.EMPTY_LIST) {
            this.declaredFunctions = new ArrayList();
        }
        this.declaredFunctions.addAll(functionBindings);
    }

    public boolean referencedFunctionsAreIncluded() {
        return false;
    }

    @Override
    protected IDataBinding primFindData(String simpleName) {
        for (IDataBinding binding : this.classFields) {
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        OverloadedFunctionSet functionSet = new OverloadedFunctionSet();
        for (IDataBinding binding : this.declaredFunctions) {
            if (binding.getName() != simpleName) continue;
            functionSet.setName(binding.getCaseSensitiveName());
            functionSet.addNestedFunctionBinding(binding);
        }
        List nestedFunctionBindings = functionSet.getNestedFunctionBindings();
        if (nestedFunctionBindings.size() == 1) {
            return (IDataBinding)nestedFunctionBindings.get(0);
        }
        if (!nestedFunctionBindings.isEmpty()) {
            return functionSet;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    protected IFunctionBinding primFindFunction(String simpleName) {
        Iterator iter = this.declaredFunctions.iterator();
        while (iter.hasNext()) {
            IFunctionBinding binding = (IFunctionBinding)((NestedFunctionBinding)iter.next()).getType();
            if (binding.getName() != simpleName) continue;
            return binding;
        }
        return IBinding.NOT_FOUND_BINDING;
    }

    @Override
    public IFunctionBinding findPublicFunction(String simpleName) {
        IFunctionBinding result = this.findFunction(simpleName);
        if (IBinding.NOT_FOUND_BINDING != result && result.isPrivate()) {
            return IBinding.NOT_FOUND_BINDING;
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.classFields = Collections.EMPTY_LIST;
        this.declaredFunctions = Collections.EMPTY_LIST;
    }

    @Override
    public boolean isDeclarablePart() {
        return false;
    }

    @Override
    public IDataBinding findPublicData(String simpleName) {
        IDataBinding result = this.findData(simpleName);
        if (IBinding.NOT_FOUND_BINDING != result) {
            if (20 == result.getKind()) {
                if (((NestedFunctionBinding)result).isPrivate()) {
                    return IBinding.NOT_FOUND_BINDING;
                }
            } else if (23 == result.getKind()) {
                OverloadedFunctionSet newSet = new OverloadedFunctionSet();
                newSet.setName(result.getCaseSensitiveName());
                for (NestedFunctionBinding func : ((OverloadedFunctionSet)result).getNestedFunctionBindings()) {
                    if (func.isPrivate()) continue;
                    newSet.addNestedFunctionBinding(func);
                }
                if (newSet.getNestedFunctionBindings().isEmpty()) {
                    return IBinding.NOT_FOUND_BINDING;
                }
                result = newSet;
            } else if (3 == result.getKind() && ((ClassFieldBinding)result).isPrivate) {
                return IBinding.NOT_FOUND_BINDING;
            }
        }
        return result;
    }
}

