/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.binding.annotationType;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.FunctionParameter;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;

public class JavaScriptObjectFieldContentValidator
extends DefaultFieldContentAnnotationValidationRule {
    private static Set invalidPrimitives = null;

    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding type = containerBinding.getType();
        if (Binding.isValidBinding(type)) {
            JavaScriptObjectFieldContentValidator.checkTypeValidInJavaObjectType(errorNode, containerBinding.getDeclaringPart(), type.getBaseType(), false, problemRequestor);
        }
    }

    public void validateFunctionParameter(FunctionParameter fParameter, FunctionParameterBinding parameterBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding parameterTypeBinding = parameterBinding.getType();
        if (Binding.isValidBinding(parameterTypeBinding)) {
            JavaScriptObjectFieldContentValidator.checkTypeValidInJavaObjectType(fParameter.getType().getBaseType(), parameterBinding.getDeclaringPart(), parameterTypeBinding.getBaseType(), true, problemRequestor);
            if (3 == parameterTypeBinding.getKind() && !Primitive.isDateTimeType(((PrimitiveTypeBinding)parameterTypeBinding).getPrimitive()) && !parameterBinding.isInput()) {
                problemRequestor.acceptProblem(fParameter, 7826);
            }
        }
    }

    @Override
    public void validateFunctionReturnType(Type typeNode, ITypeBinding typeBinding, IPartBinding declaringPart, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        JavaScriptObjectFieldContentValidator.checkTypeValidInJavaObjectType(typeNode.getBaseType(), declaringPart, typeBinding.getBaseType(), true, problemRequestor);
    }

    public static void checkTypeValidInJavaObjectType(Node errorNode, IPartBinding partBinding, ITypeBinding typeBinding, boolean issueErrorForDelegate, IProblemRequestor problemRequestor) {
    }

    private static Set getInvalidPrimitives() {
        if (invalidPrimitives == null) {
            invalidPrimitives = new HashSet();
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.BLOB));
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.CLOB));
            invalidPrimitives.add(PrimitiveTypeBinding.getInstance(Primitive.ANY));
        }
        return invalidPrimitives;
    }
}

