/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.Stack;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.ParseStack;

public abstract class AbstractRecovery {
    protected ParseStack errorStack;
    protected ITokenStream tokenStream;
    protected Stack realStack;
    protected ISyntaxErrorRequestor problemRequestor;

    public AbstractRecovery(ParseStack errorStack, Stack realStack, ITokenStream tokenStream, ISyntaxErrorRequestor problemRequestor) {
        this.errorStack = errorStack;
        this.tokenStream = tokenStream;
        this.realStack = realStack;
        this.problemRequestor = problemRequestor;
        this.performTrial();
    }

    protected Symbol getLastRealSymbol(Stack realStack2) {
        int i = realStack2.size() - 1;
        while (i >= 0) {
            Symbol next = (Symbol)realStack2.get(i);
            if (next.left != next.right && next.left >= 0 && next.right >= 0) {
                return next;
            }
            --i;
        }
        return (Symbol)realStack2.peek();
    }

    protected abstract void performTrial();

    public abstract float getMisspellingIndex();

    public abstract int getParseCheckDistance();

    public abstract int performRecovery();
}

