/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;

public class AnnotationExpression
extends Expression {
    private Name name;

    public AnnotationExpression(Name name, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.name = name;
        name.setParent(this);
    }

    public Name getName() {
        return this.name;
    }

    @Override
    public String getCanonicalString() {
        return this.getName().getCanonicalString();
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public IDataBinding resolveDataBinding() {
        IDataBinding result = super.resolveDataBinding();
        if (result == null) {
            result = this.getName().resolveDataBinding();
        }
        return result;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new AnnotationExpression((Name)this.name.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }
}

