/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Type;

public class ArrayType
extends Type {
    private Type elementType;
    private Expression initialSize;
    private ArrayTypeBinding arrayTypeBinding;

    public ArrayType(Type elementType, Expression initialSize, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.elementType = elementType;
        elementType.setParent(this);
        if (initialSize != null) {
            this.initialSize = initialSize;
            this.initialSize.setParent(this);
        }
    }

    public Type getElementType() {
        return this.elementType;
    }

    public boolean hasInitialSize() {
        return this.initialSize != null;
    }

    public Expression getInitialSize() {
        return this.initialSize;
    }

    @Override
    public int getKind() {
        return 2;
    }

    @Override
    public boolean isArrayType() {
        return true;
    }

    @Override
    public ITypeBinding resolveTypeBinding() {
        return this.arrayTypeBinding;
    }

    public void setTypeBinding(ArrayTypeBinding arrayTypeBinding) {
        this.arrayTypeBinding = arrayTypeBinding;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.elementType.accept(visitor);
            if (this.initialSize != null) {
                this.initialSize.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public String getCanonicalName() {
        return String.valueOf(this.elementType.getCanonicalName()) + "[]";
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        Expression newInitialSize = this.initialSize != null ? (Expression)this.initialSize.clone() : null;
        return new ArrayType((Type)this.elementType.clone(), newInitialSize, this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public Type getBaseType() {
        return this.elementType.getBaseType();
    }
}

