/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;

public class BinaryExpression
extends Expression {
    private Operator operator;
    private Expression expr1;
    private Expression expr2;

    public BinaryExpression(Operator operator, Expression expr1, Expression expr2, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.operator = operator;
        this.expr1 = expr1;
        expr1.setParent(this);
        this.expr2 = expr2;
        expr2.setParent(this);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public Expression getFirstExpression() {
        return this.expr1;
    }

    public Expression getSecondExpression() {
        return this.expr2;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr1.accept(visitor);
            this.expr2.accept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new BinaryExpression(this.operator, (Expression)this.expr1.clone(), (Expression)this.expr2.clone(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public String getCanonicalString() {
        return String.valueOf(this.expr1.getCanonicalString()) + this.operator.toString() + this.expr2.getCanonicalString();
    }

    public static class Operator {
        private String token;
        public static final Operator TIMES = new Operator("*");
        public static final Operator TIMESTIMES = new Operator("**");
        public static final Operator DIVIDE = new Operator("/");
        public static final Operator MODULO = new Operator("%");
        public static final Operator PLUS = new Operator("+");
        public static final Operator MINUS = new Operator("-");
        public static final Operator LESS = new Operator("<");
        public static final Operator GREATER = new Operator(">");
        public static final Operator LESS_EQUALS = new Operator("<=");
        public static final Operator GREATER_EQUALS = new Operator(">=");
        public static final Operator EQUALS = new Operator("==");
        public static final Operator NOT_EQUALS = new Operator("!=");
        public static final Operator OR = new Operator("||");
        public static final Operator AND = new Operator("&&");
        public static final Operator CONCAT = new Operator("::");
        public static final Operator NULLCONCAT = new Operator("?:");
        public static final Operator BITAND = new Operator("&");
        public static final Operator BITOR = new Operator("|");
        public static final Operator XOR = new Operator("xor");
        private static final Map CODES = new HashMap(16);

        static {
            Operator[] ops = new Operator[]{TIMES, TIMESTIMES, DIVIDE, MODULO, PLUS, MINUS, LESS, GREATER, LESS_EQUALS, GREATER_EQUALS, EQUALS, NOT_EQUALS, OR, AND, CONCAT, NULLCONCAT, BITAND, BITOR, XOR};
            int i = 0;
            while (i < ops.length) {
                CODES.put(ops[i].toString(), ops[i]);
                ++i;
            }
        }

        private Operator(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }

        public static Operator toOperator(String token) {
            return (Operator)CODES.get(token);
        }
    }
}

