/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.CallStatementBinding;
import org.eclipse.edt.compiler.core.ast.CallbackTarget;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.FunctionInvocation;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Statement;

public class CallStatement
extends Statement {
    private Expression expr;
    private List exprs;
    private SettingsBlock settingsBlockOpt;
    private CallbackTarget callbackOpt;
    private CallbackTarget errorCallbackOpt;
    private CallStatementBinding statementBinding;

    public CallStatement(Expression expr, List exprs, SettingsBlock settingsBlockOpt, CallbackTarget callbackOpt, CallbackTarget errorCallbackOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        if (exprs == null && expr instanceof FunctionInvocation) {
            FunctionInvocation fInvocation = (FunctionInvocation)expr;
            expr = fInvocation.getTarget();
            exprs = fInvocation.getArguments();
        }
        this.expr = expr;
        expr.setParent(this);
        if (exprs != null) {
            this.exprs = this.setParent(exprs);
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
        if (callbackOpt != null) {
            this.callbackOpt = callbackOpt;
            this.callbackOpt.setParent(this);
        }
        if (errorCallbackOpt != null) {
            this.errorCallbackOpt = errorCallbackOpt;
            this.errorCallbackOpt.setParent(this);
        }
    }

    public Expression getInvocationTarget() {
        return this.expr;
    }

    public Name getName() {
        throw new RuntimeException();
    }

    public boolean hasArguments() {
        return this.exprs != null && !this.exprs.isEmpty();
    }

    public List getArguments() {
        return this.exprs;
    }

    public List getCallOptions() {
        return Collections.EMPTY_LIST;
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public CallbackTarget getCallbackTarget() {
        return this.callbackOpt;
    }

    public CallbackTarget getErrorCallbackTarget() {
        return this.errorCallbackOpt;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.expr.accept(visitor);
            if (this.exprs != null) {
                CallStatement.acceptChildren(visitor, this.exprs);
            }
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
            if (this.callbackOpt != null) {
                this.callbackOpt.accept(visitor);
            }
            if (this.errorCallbackOpt != null) {
                this.errorCallbackOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ArrayList newArguments = this.exprs != null ? this.cloneList(this.exprs) : null;
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        CallbackTarget newCallbackOpt = this.callbackOpt != null ? (CallbackTarget)this.callbackOpt.clone() : null;
        CallbackTarget newErrorCallbackOpt = this.errorCallbackOpt != null ? (CallbackTarget)this.errorCallbackOpt.clone() : null;
        return new CallStatement((Expression)this.expr.clone(), newArguments, newSettingsBlockOpt, newCallbackOpt, newErrorCallbackOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public CallStatementBinding getStatementBinding() {
        return this.statementBinding;
    }

    public void setStatementBinding(CallStatementBinding statementBinding) {
        this.statementBinding = statementBinding;
    }
}

