/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import org.eclipse.edt.compiler.core.ast.AbstractRecovery;
import org.eclipse.edt.compiler.core.ast.AccumulatingSyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.AdvancedPhraseRecovery;
import org.eclipse.edt.compiler.core.ast.CUP$Parser$actions;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.ISyntaxErrorRequestor;
import org.eclipse.edt.compiler.core.ast.ITokenStream;
import org.eclipse.edt.compiler.core.ast.Lexer;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.NonTerminalInsertionRecovery;
import org.eclipse.edt.compiler.core.ast.NonTerminalSubstitutionRecovery;
import org.eclipse.edt.compiler.core.ast.ParseStack;
import org.eclipse.edt.compiler.core.ast.Parser;
import org.eclipse.edt.compiler.core.ast.PreviousNonTerminalInsertionRecovery;
import org.eclipse.edt.compiler.core.ast.PreviousNonTerminalSubstitutionRecovery;
import org.eclipse.edt.compiler.core.ast.PreviousTerminalDeletionRecovery;
import org.eclipse.edt.compiler.core.ast.PreviousTerminalInsertionRecovery;
import org.eclipse.edt.compiler.core.ast.PreviousTerminalSubstitutionRecovery;
import org.eclipse.edt.compiler.core.ast.ScopeRecovery;
import org.eclipse.edt.compiler.core.ast.SlimParseStack;
import org.eclipse.edt.compiler.core.ast.Terminal;
import org.eclipse.edt.compiler.core.ast.TerminalDeletionRecovery;
import org.eclipse.edt.compiler.core.ast.TerminalInsertionRecovery;
import org.eclipse.edt.compiler.core.ast.TerminalSubstitutionRecovery;
import org.eclipse.edt.compiler.core.ast.TokenStream;
import org.eclipse.edt.compiler.core.ast.VAGLexer;

public class ErrorCorrectingParser
extends Parser {
    public static final int RECOVERY_SUCCESS = 5;
    public static final int INITIAL_STACK_SIZE = 128;
    public static final int RETURN_LINEBREAKS = 2;
    public static final int RETURN_LINE_COMMENT = 4;
    public static final int RETURN_BLOCK_COMMENT = 8;
    private ISyntaxErrorRequestor problemRequestor;
    private TokenStream stream;
    public static final int MAX_ERRORS = 100;
    private int errorsDetected;

    public ErrorCorrectingParser() {
    }

    public void setProblemRequestor(ISyntaxErrorRequestor problemRequestor) {
        this.problemRequestor = problemRequestor;
    }

    public Node parse(String source) {
        VAGLexer scanner = null;
        scanner = new VAGLexer(new StringReader(source));
        this.stream = new TokenStream(20, scanner);
        return (Node)this.parse().value;
    }

    public ErrorCorrectingParser(Scanner lexer) {
        this.stream = new TokenStream(20, lexer);
    }

    public ErrorCorrectingParser(Scanner lexer, int whitespaceMask) {
        if (lexer instanceof Lexer) {
            Lexer eglLexer = (Lexer)lexer;
            eglLexer.returnBlockComments = (whitespaceMask & 8) != 0;
            eglLexer.returnLineBreaks = (whitespaceMask & 2) != 0;
            eglLexer.returnLineComments = (whitespaceMask & 4) != 0;
        } else if (lexer instanceof VAGLexer) {
            VAGLexer vagLexer = (VAGLexer)lexer;
            vagLexer.returnBlockComments = (whitespaceMask & 8) != 0;
            vagLexer.returnLineBreaks = (whitespaceMask & 2) != 0;
            vagLexer.returnLineComments = (whitespaceMask & 4) != 0;
        }
        this.stream = new TokenStream(20, lexer);
    }

    @Override
    public Symbol parse() {
        Scanner lexer;
        this.errorsDetected = 0;
        if (this.problemRequestor == null) {
            this.problemRequestor = new AccumulatingSyntaxErrorRequestor();
        }
        this.production_tab = this.production_table();
        this.action_tab = this.action_table();
        this.reduce_tab = this.reduce_table();
        CUP$Parser$actions actionObject = new CUP$Parser$actions(this);
        SlimParseStack scoutStack = new SlimParseStack();
        scoutStack.shiftStartState();
        boolean[] isNonTerminal = new boolean[128];
        Stack<Symbol> realStack = new Stack<Symbol>();
        realStack.push(new Symbol(0, 0));
        int realStackTop = 0;
        isNonTerminal[0] = true;
        int leftMostErrorNodeIndex = 0;
        this._done_parsing = false;
        while (!this._done_parsing) {
            Terminal lookAhead = this.stream.getLookAhead();
            if (scoutStack.canShift(lookAhead)) {
                short nonTerminalType;
                do {
                    Symbol nonTerminal;
                    Symbol lookAheadSymbol = this.stream.getLookAheadSymbol();
                    short action = this.get_action(((Symbol)realStack.peek()).parse_state, lookAheadSymbol.sym);
                    if (action > 0) {
                        boolean isErrorNode = lookAheadSymbol.parse_state == -2;
                        lookAheadSymbol.parse_state = action - 1;
                        realStack.push(lookAheadSymbol);
                        ++realStackTop;
                        try {
                            isNonTerminal[realStackTop] = false;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            isNonTerminal = this.enlargeStack(isNonTerminal);
                            isNonTerminal[realStackTop] = false;
                        }
                        if (!isErrorNode) break;
                        leftMostErrorNodeIndex = leftMostErrorNodeIndex == 0 ? realStackTop : Math.min(leftMostErrorNodeIndex, realStackTop);
                        break;
                    }
                    nonTerminalType = this.production_tab[-action - 1][0];
                    int handleSize = this.production_tab[-action - 1][1];
                    if (leftMostErrorNodeIndex == 0) {
                        try {
                            nonTerminal = actionObject.CUP$Parser$do_action(-action - 1, this, realStack, realStackTop);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Parse action failed with exception", e);
                        }
                    } else {
                        int left = ((Symbol)realStack.elementAt((int)(realStackTop - handleSize + (handleSize == 0 ? 0 : 1)))).left;
                        int right = ((Symbol)realStack.peek()).right;
                        nonTerminal = new Symbol(nonTerminalType, left, right);
                        boolean nullable = false;
                        if (scoutStack.isConstructPlus(nonTerminalType)) {
                            nullable = true;
                            if (handleSize == 1) {
                                nonTerminal.value = new ArrayList();
                            } else {
                                Symbol elementAt = (Symbol)realStack.elementAt(realStackTop - handleSize + 1);
                                Object value = elementAt.value;
                                nonTerminal.value = Collections.EMPTY_LIST == value && scoutStack.isConstructStar(elementAt.sym) ? new ArrayList() : (value == null ? new ArrayList() : value);
                            }
                        } else {
                            nullable = true;
                            switch (nonTerminalType) {
                                case 28: {
                                    nonTerminal.value = Collections.EMPTY_LIST;
                                }
                                case 64: 
                                case 66: 
                                case 76: {
                                    break;
                                }
                                default: {
                                    nullable = false;
                                }
                            }
                        }
                        if (nullable && realStackTop - handleSize < leftMostErrorNodeIndex) {
                            leftMostErrorNodeIndex = 0;
                        }
                    }
                    int i = 0;
                    while (i < handleSize) {
                        realStack.pop();
                        --realStackTop;
                        ++i;
                    }
                    nonTerminal.parse_state = this.get_reduce(((Symbol)realStack.peek()).parse_state, nonTerminalType);
                    realStack.push(nonTerminal);
                    ++realStackTop;
                    try {
                        isNonTerminal[realStackTop] = true;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        isNonTerminal = this.enlargeStack(isNonTerminal);
                        isNonTerminal[realStackTop] = true;
                    }
                    if (realStackTop >= leftMostErrorNodeIndex) continue;
                    leftMostErrorNodeIndex = realStackTop;
                } while (nonTerminalType != 0);
                this.stream.advanceLookAhead();
                continue;
            }
            int errorNodeIndex = this.recover(realStack, isNonTerminal);
            scoutStack.reset(realStack);
            if (errorNodeIndex != 0) {
                int n = leftMostErrorNodeIndex = leftMostErrorNodeIndex == 0 ? errorNodeIndex : Math.min(leftMostErrorNodeIndex, errorNodeIndex);
            }
            if ((realStackTop = realStack.size() - 1) >= leftMostErrorNodeIndex) continue;
            leftMostErrorNodeIndex = 0;
        }
        File file = (File)((Symbol)realStack.peek()).value;
        if (this.problemRequestor instanceof AccumulatingSyntaxErrorRequestor) {
            List errors = ((AccumulatingSyntaxErrorRequestor)this.problemRequestor).getSyntaxErrors();
            errors.addAll(this.stream.getLexerErrors());
            file.setSyntaxErrors(errors);
        }
        if ((lexer = this.stream.getLexer()) instanceof Lexer) {
            Lexer eglLexer = (Lexer)lexer;
            file.blockComments = eglLexer.blockComments;
            file.lineBreaks = eglLexer.lineBreaks;
            file.lineComments = eglLexer.lineComments;
        } else if (lexer instanceof VAGLexer) {
            VAGLexer vagLexer = (VAGLexer)lexer;
            file.blockComments = vagLexer.blockComments;
            file.lineBreaks = vagLexer.lineBreaks;
            file.lineComments = vagLexer.lineComments;
        }
        return (Symbol)realStack.peek();
    }

    private boolean[] enlargeStack(boolean[] stack) {
        boolean[] newStack = new boolean[stack.length * 2];
        System.arraycopy(stack, 0, newStack, 0, stack.length);
        return newStack;
    }

    private int recover(Stack realStack, boolean[] isNonTerminal) {
        ParseStack stack = new ParseStack(realStack, isNonTerminal);
        ++this.errorsDetected;
        if (this.errorsDetected < 100) {
            AbstractRecovery[] recoveries = new AbstractRecovery[]{new ScopeRecovery(stack, realStack, this.stream, this.problemRequestor), new TerminalDeletionRecovery(stack, realStack, this.stream, this.problemRequestor), new NonTerminalSubstitutionRecovery(stack, realStack, this.stream, this.problemRequestor), new TerminalSubstitutionRecovery(stack, realStack, this.stream, this.problemRequestor), new NonTerminalInsertionRecovery(stack, realStack, this.stream, this.problemRequestor), new TerminalInsertionRecovery(stack, realStack, this.stream, this.problemRequestor), new PreviousTerminalDeletionRecovery(stack, realStack, this.stream, this.problemRequestor), new PreviousNonTerminalSubstitutionRecovery(stack, realStack, this.stream, this.problemRequestor), new PreviousTerminalSubstitutionRecovery(stack, realStack, this.stream, this.problemRequestor), new PreviousNonTerminalInsertionRecovery(stack, realStack, this.stream, this.problemRequestor), new PreviousTerminalInsertionRecovery(stack, realStack, this.stream, this.problemRequestor)};
            AbstractRecovery bestRecovery = recoveries[0];
            int i = 1;
            while (i < recoveries.length) {
                if (recoveries[i].getParseCheckDistance() > bestRecovery.getParseCheckDistance()) {
                    bestRecovery = recoveries[i];
                }
                ++i;
            }
            if (bestRecovery.getParseCheckDistance() >= 5) {
                int result = bestRecovery.performRecovery();
                stack.sync(isNonTerminal);
                return result;
            }
            AdvancedPhraseRecovery phraseRecovery = new AdvancedPhraseRecovery(stack, realStack, this.stream, this.problemRequestor);
            if (phraseRecovery.getParseCheckDistance() >= 5) {
                if (phraseRecovery.getNumTokensDeleted() < 5) {
                    int result = phraseRecovery.performRecovery();
                    stack.sync(isNonTerminal);
                    return result;
                }
                int result = bestRecovery.performRecovery();
                stack.sync(isNonTerminal);
                return result;
            }
        }
        if (this.errorsDetected == 100) {
            this.problemRequestor.tooManyErrors();
        }
        return this.panicRecover(stack, realStack, this.stream, this.problemRequestor);
    }

    private int panicRecover(ParseStack stack, Stack realStack, ITokenStream stream, ISyntaxErrorRequestor problemRequestor) {
        ParseStack trialStack;
        int left = stream.getLookAhead().left;
        int right = stream.getLookAhead().right;
        stack.dumpStackUntil(65, 71);
        while (stack.getStackTop() != realStack.size() - 1) {
            realStack.pop();
        }
        while ((trialStack = stack.createCopy()).parseCheck(stream, 5) != 5) {
            stream.advanceLookAhead();
        }
        if (this.errorsDetected < 100) {
            problemRequestor.panicPhrase(left, right);
        }
        return 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.stack.toString());
        buffer.append("\n");
        buffer.append(this.stream.toString());
        return buffer.toString();
    }
}

