/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.Type;

public class NewExpression
extends Expression {
    private Type type;
    private boolean hasArgumentList;
    private List funcArgs;
    private SettingsBlock settingsBlockOpt;
    private IDataBinding dataBindingForAnnotations;
    private IDataBinding constructorBinding;

    public NewExpression(Type type, List funcArgs, SettingsBlock settingsBlockOpt, int startOffset, int endOffset) {
        super(startOffset, endOffset);
        this.type = type;
        type.setParent(this);
        if (funcArgs == null) {
            this.funcArgs = Collections.EMPTY_LIST;
            this.hasArgumentList = false;
        } else {
            this.funcArgs = this.setParent(funcArgs);
            this.hasArgumentList = true;
        }
        if (settingsBlockOpt != null) {
            this.settingsBlockOpt = settingsBlockOpt;
            settingsBlockOpt.setParent(this);
        }
    }

    public Type getType() {
        return this.type;
    }

    public List getArguments() {
        return this.funcArgs;
    }

    public boolean hasArgumentList() {
        return this.hasArgumentList;
    }

    @Override
    public String getCanonicalString() {
        return "new " + this.type.getCanonicalName();
    }

    public boolean hasSettingsBlock() {
        return this.settingsBlockOpt != null;
    }

    public SettingsBlock getSettingsBlock() {
        return this.settingsBlockOpt;
    }

    public IDataBinding resolveConstructorBinding() {
        return this.constructorBinding;
    }

    public void setConstructorBinding(IDataBinding constructorBinding) {
        this.constructorBinding = constructorBinding;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.type.accept(visitor);
            NewExpression.acceptChildren(visitor, this.funcArgs);
            if (this.settingsBlockOpt != null) {
                this.settingsBlockOpt.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        SettingsBlock newSettingsBlockOpt = this.settingsBlockOpt != null ? (SettingsBlock)this.settingsBlockOpt.clone() : null;
        ArrayList newArgs = this.hasArgumentList ? this.cloneList(this.funcArgs) : null;
        return new NewExpression((Type)this.type.clone(), newArgs, newSettingsBlockOpt, this.getOffset(), this.getOffset() + this.getLength());
    }

    public IDataBinding getDataBindingForAnnotations() {
        return this.dataBindingForAnnotations;
    }

    public void setDataBindingForAnnotations(IDataBinding dataBindingForAnnotations) {
        this.dataBindingForAnnotations = dataBindingForAnnotations;
    }
}

