/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.core.ast;

import java.util.List;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Assignment;
import org.eclipse.edt.compiler.core.ast.BooleanLiteral;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.core.ast.ReturnsDeclaration;
import org.eclipse.edt.compiler.core.ast.SettingsBlock;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.compiler.core.ast.Type;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class TopLevelFunction
extends Part {
    private boolean isPrivate;
    private List functionParameters;
    private ReturnsDeclaration returnsOpt;

    public TopLevelFunction(java.lang.Boolean privateAccessModifierOpt, SimpleName name, List functionParameters, ReturnsDeclaration returnsOpt, List stmts, int startOffset, int endOffset) {
        super(privateAccessModifierOpt, name, stmts, startOffset, endOffset);
        this.isPrivate = privateAccessModifierOpt;
        this.functionParameters = this.setParent(functionParameters);
        if (returnsOpt != null) {
            this.returnsOpt = returnsOpt;
            returnsOpt.setParent(this);
        }
    }

    @Override
    public boolean isPrivate() {
        return this.isPrivate;
    }

    public List getFunctionParameters() {
        return this.functionParameters;
    }

    public ReturnsDeclaration getReturnDeclaration() {
        return this.returnsOpt;
    }

    public boolean hasReturnType() {
        return this.returnsOpt != null;
    }

    public Type getReturnType() {
        return this.returnsOpt.getType();
    }

    public boolean returnTypeIsSqlNullable() {
        return this.returnsOpt.isSqlNullable();
    }

    public List getStmts() {
        return this.contents;
    }

    @Override
    public void accept(IASTVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.name.accept(visitor);
            TopLevelFunction.acceptChildren(visitor, this.functionParameters);
            if (this.returnsOpt != null) {
                this.returnsOpt.accept(visitor);
            }
            TopLevelFunction.acceptChildren(visitor, this.contents);
        }
        visitor.endVisit(this);
    }

    public boolean isContainerContextDependent() {
        final boolean[] result = new boolean[1];
        this.accept(new DefaultASTVisitor(){

            @Override
            public boolean visit(TopLevelFunction topLevelFunction) {
                return true;
            }

            @Override
            public boolean visit(SettingsBlock settingsBlock) {
                settingsBlock.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(SettingsBlock settingsBlock) {
                        return true;
                    }

                    @Override
                    public boolean visit(Assignment assignment) {
                        Name lhsName;
                        Expression lhs = assignment.getLeftHandSide();
                        if (lhs.isName() && (lhsName = (Name)lhs).isSimpleName() && lhsName.getIdentifier() == InternUtil.intern((String)"containerContextDependent")) {
                            Expression rhs = assignment.getRightHandSide();
                            rhs.accept(new DefaultASTVisitor(){

                                @Override
                                public boolean visit(BooleanLiteral booleanLiteral) {
                                    result[0] = Boolean.YES == booleanLiteral.booleanValue();
                                    return false;
                                }
                            });
                        }
                        return false;
                    }
                });
                return false;
            }
        });
        return result[0];
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        ReturnsDeclaration newReturnsOpt = this.returnsOpt != null ? (ReturnsDeclaration)this.returnsOpt.clone() : null;
        return new TopLevelFunction(new java.lang.Boolean(this.isPrivate), (SimpleName)this.name.clone(), this.cloneList(this.functionParameters), newReturnsOpt, this.cloneContents(), this.getOffset(), this.getOffset() + this.getLength());
    }

    @Override
    public String getPartTypeName() {
        return "function";
    }

    @Override
    public int getPartType() {
        return 2;
    }

    @Override
    public boolean hasSubType() {
        return false;
    }

    @Override
    public Name getSubType() {
        return null;
    }
}

