/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.compiler.binding.AnnotationAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.ClassFieldBinding;
import org.eclipse.edt.compiler.binding.EnumerationTypeBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.binding.annotationType.EGLSpecificValuesAnnotationTypeBinding;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.enumerations.EGLEnumeration;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class EGLPropertyRule
implements Comparable {
    protected String name;
    protected String description = "";
    protected int[] types;
    protected int[] elementTypes;
    protected EGLPropertyRule[] elementAnnotationTypes;
    private String[] specificValues;
    private String[] packageName;
    private boolean arrayOnly;
    private boolean isComplex = false;
    private boolean isValueless = false;
    private boolean isAnnotationField = false;
    private EGLEnumeration enumeration;
    private int specialRules = 0;
    private IAnnotationTypeBinding elementAnnotationType;
    public static int DONT_VALIDATE_IN_OPENUI_STATEMENT = 2;
    public static int IS_DLI_NAME = 4;

    public EGLPropertyRule(String name, String description, int[] types, String[] specificValues, boolean arrayOnly) {
        this.name = name;
        this.description = description;
        this.types = types;
        this.specificValues = specificValues;
        this.arrayOnly = arrayOnly;
    }

    public EGLPropertyRule(String name, int[] types, String[] specificValues, boolean arrayOnly) {
        this(name, "", types, specificValues, arrayOnly);
    }

    public EGLPropertyRule(String name, String description, int[] types, String[] specificValues) {
        this(name, description, types, specificValues, false);
    }

    public EGLPropertyRule(String name, int[] types, String[] specificValues) {
        this(name, types, specificValues, false);
    }

    public EGLPropertyRule(String name, String description, int[] types) {
        this(name, types);
        this.description = description;
    }

    public EGLPropertyRule(String name, int[] types) {
        this(name, types, null, false);
    }

    public EGLPropertyRule(String name, int[] types, int[] elementTypes, EGLPropertyRule[] elementAnnotationTypes) {
        this(name, types, null, true);
        this.elementTypes = elementTypes;
        this.elementAnnotationTypes = elementAnnotationTypes;
    }

    public EGLPropertyRule(String name, EGLPropertyRule[] elementAnnotationTypes) {
        this.name = name;
        this.elementAnnotationTypes = elementAnnotationTypes;
        this.isComplex = true;
    }

    public EGLPropertyRule(IAnnotationTypeBinding typeBindingImpl) {
        this.name = typeBindingImpl.getCaseSensitiveName();
        this.packageName = typeBindingImpl.getPackageName();
        List fieldNames = typeBindingImpl.getFieldNames();
        if (typeBindingImpl.hasSingleValue() && (fieldNames.isEmpty() || "value".equalsIgnoreCase((String)fieldNames.iterator().next()))) {
            this.setFieldsFromType(typeBindingImpl.getSingleValueType(), typeBindingImpl);
        } else if (typeBindingImpl.isValueless()) {
            this.isValueless = true;
        } else {
            this.types = new int[]{7};
            this.isComplex = true;
            ArrayList<EGLPropertyRule> elementRules = new ArrayList<EGLPropertyRule>();
            Iterator iter = typeBindingImpl.getFieldNames().iterator();
            while (iter.hasNext()) {
                elementRules.add(new EGLPropertyRule((IAnnotationTypeBinding)typeBindingImpl.findData((String)iter.next()).getType()));
            }
            this.elementAnnotationTypes = elementRules.toArray(new EGLPropertyRule[0]);
        }
    }

    public EGLPropertyRule(IDataBinding dBinding) {
        this.name = dBinding.getCaseSensitiveName();
        this.packageName = dBinding.getDeclaringPart().getPackageName();
        this.setFieldsFromType(dBinding.getType(), null);
    }

    public EGLPropertyRule(ClassFieldBinding cfBinding) {
        this.name = cfBinding.getCaseSensitiveName();
        this.packageName = cfBinding.getDeclaringPart().getPackageName();
        this.setFieldsFromType(cfBinding.getType(), null);
    }

    private void setFieldsFromType(ITypeBinding type, IAnnotationTypeBinding typeBindingImpl) {
        block0 : switch (type.getKind()) {
            case 3: {
                switch (((PrimitiveTypeBinding)type).getPrimitive().getType()) {
                    case 19: {
                        IAnnotationBinding aBinding;
                        IAnnotationBinding iAnnotationBinding = aBinding = typeBindingImpl == null ? null : typeBindingImpl.getAnnotation(EGLSpecificValuesAnnotationTypeBinding.getInstance());
                        if (aBinding == null) {
                            int[] nArray;
                            if (typeBindingImpl != null && typeBindingImpl.isBIDIEnabled()) {
                                int[] nArray2 = new int[2];
                                nArray2[0] = 1;
                                nArray = nArray2;
                                nArray2[1] = 12;
                            } else {
                                int[] nArray3 = new int[1];
                                nArray = nArray3;
                                nArray3[0] = 1;
                            }
                            this.types = nArray;
                            break;
                        }
                        this.types = new int[]{1, 2};
                        Object[] specificValues = (Object[])aBinding.getValue();
                        this.specificValues = new String[specificValues.length];
                        int i = 0;
                        while (i < specificValues.length) {
                            this.specificValues[i] = (String)specificValues[i];
                            ++i;
                        }
                        break block0;
                    }
                    case 3: {
                        this.types = new int[]{2};
                        this.specificValues = new String[]{"yes", "no"};
                        break;
                    }
                    case 10: {
                        this.types = new int[]{3};
                        break;
                    }
                    case 0: {
                        int[] nArray;
                        if (typeBindingImpl != null && typeBindingImpl.isBIDIEnabled()) {
                            int[] nArray4 = new int[2];
                            nArray4[0] = 4;
                            nArray = nArray4;
                            nArray4[1] = 12;
                        } else {
                            int[] nArray5 = new int[1];
                            nArray = nArray5;
                            nArray5[0] = 4;
                        }
                        this.types = nArray;
                    }
                }
                break;
            }
            case 19: {
                ArrayList<String> fieldNames = new ArrayList<String>();
                Iterator iter = ((EnumerationTypeBinding)type).getEnumerations().iterator();
                while (iter.hasNext()) {
                    fieldNames.add(((IDataBinding)iter.next()).getCaseSensitiveName());
                }
                this.types = new int[]{2};
                this.specificValues = fieldNames.toArray(new String[0]);
                break;
            }
            case 15: {
                if (SystemPartManager.SQLSTRING_BINDING == type) {
                    this.types = new int[]{8};
                    break;
                }
                if (InternUtil.intern((String[])new String[]{"egl", "core", "reflect"}) != type.getPackageName()) break;
                this.types = new int[1];
                break;
            }
            case 2: {
                this.types = new int[]{5};
                ITypeBinding elementType = ((ArrayTypeBinding)type).getElementType();
                switch (elementType.getKind()) {
                    case 19: {
                        ArrayList<String> fieldNames = new ArrayList<String>();
                        Iterator iter = ((EnumerationTypeBinding)elementType).getEnumerations().iterator();
                        while (iter.hasNext()) {
                            fieldNames.add(this.firstLower(((IDataBinding)iter.next()).getName()));
                        }
                        this.specificValues = fieldNames.toArray(new String[0]);
                        break block0;
                    }
                    case 2: {
                        this.types = new int[]{9};
                        break block0;
                    }
                    case 28: {
                        this.types = new int[]{5};
                        break block0;
                    }
                }
                if (elementType.getAnnotation(AnnotationAnnotationTypeBinding.getInstance()) == null) break;
                this.types = new int[]{10};
                this.elementAnnotationType = new AnnotationTypeBindingImpl((FlexibleRecordBinding)elementType, (IPartBinding)elementType);
            }
        }
    }

    private String firstLower(String str) {
        StringBuffer result = new StringBuffer();
        result.append(str.substring(0, 1).toLowerCase());
        result.append(str.substring(1));
        return result.toString();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String[] getSpecificValues() {
        return this.specificValues;
    }

    public int[] getTypes() {
        return this.types;
    }

    public boolean hasType(int type) {
        if (this.getTypes() != null) {
            int i = 0;
            while (i < this.getTypes().length) {
                if (this.getTypes()[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public int[] getElementTypes() {
        return this.elementTypes;
    }

    public boolean hasElementType(int type) {
        if (this.getElementTypes() != null) {
            int i = 0;
            while (i < this.getElementTypes().length) {
                if (this.getElementTypes()[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public EGLPropertyRule[] getElementAnnotationTypes() {
        return this.elementAnnotationTypes;
    }

    public IAnnotationTypeBinding getElementAnnotationType() {
        return this.elementAnnotationType;
    }

    public boolean isSQLItemPropertyRule() {
        return false;
    }

    public boolean isPageItemPropertyRule() {
        return false;
    }

    public boolean isFormattingPropertyRule() {
        return false;
    }

    public boolean isValidationPropertyRule() {
        return false;
    }

    public boolean isFieldPresentationPropertyRule() {
        return false;
    }

    public boolean isArrayOnly() {
        return this.arrayOnly;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isValueless() {
        return this.isValueless;
    }

    public boolean isCombo() {
        return this.name.equals("currency") || this.name.equals("fillCharacter") || this.name.equals("keyItem") || this.name.equals("lengthItem");
    }

    public boolean isRecordPropertyRule() {
        return false;
    }

    public boolean equals(Object arg0) {
        return this.getName().equals(((EGLPropertyRule)arg0).getName());
    }

    public int compareTo(Object arg0) {
        return this.getName().toLowerCase().compareTo(((EGLPropertyRule)arg0).getName().toLowerCase());
    }

    public void setEnumeration(EGLEnumeration enumer) {
        this.enumeration = enumer;
    }

    public EGLEnumeration getEnumeration() {
        return this.enumeration;
    }

    public boolean isEnumerationProperty() {
        return this.enumeration != null;
    }

    public void setSpecialRules(int newRules) {
        this.specialRules = newRules;
    }

    public boolean shouldValidateInOpenUIStatement() {
        return (this.specialRules & DONT_VALIDATE_IN_OPENUI_STATEMENT) == 0;
    }

    public boolean isDLIName() {
        return (this.specialRules & IS_DLI_NAME) != 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = "";
        }
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getPackageName() {
        return this.packageName;
    }

    public boolean isAnnotationField() {
        return this.isAnnotationField;
    }

    public void setAnnotationField(boolean isAnnotationField) {
        this.isAnnotationField = isAnnotationField;
    }
}

