/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.lookup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.BindingUtilities;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPackageBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.LocalVariableBinding;
import org.eclipse.edt.compiler.internal.core.lookup.ILocalVariableScope;
import org.eclipse.edt.compiler.internal.core.lookup.Scope;

public class FunctionScope
extends Scope
implements ILocalVariableScope {
    private Map localVariables = Collections.EMPTY_MAP;
    private Set ioObjects = Collections.EMPTY_SET;
    private List locallyDefinedRecords;
    private Map level2Items;
    protected Set declaredDataNames = new HashSet();
    private List dataBindingsToIgnore = Collections.EMPTY_LIST;

    public FunctionScope(Scope parentScope, IFunctionBinding functionBinding) {
        this(parentScope);
        List functionParameters = functionBinding.getParameters();
        if (functionParameters != Collections.EMPTY_LIST) {
            this.localVariables = new HashMap();
            for (IDataBinding nextParm : functionParameters) {
                this.localVariables.put(nextParm.getName(), nextParm);
            }
        }
    }

    protected FunctionScope(Scope parentScope) {
        super(parentScope);
    }

    @Override
    public IDataBinding findData(String simpleName) {
        IDataBinding result = (IDataBinding)this.localVariables.get(simpleName);
        if (this.dataBindingsToIgnore.contains(result)) {
            result = null;
        }
        if (result != null) {
            return result;
        }
        result = (IDataBinding)this.getLevel2Items().get(simpleName);
        if (result != null) {
            return result;
        }
        return this.parentScope.findData(simpleName);
    }

    @Override
    public IDataBinding findIOTargetData(String simpleName) {
        int resultTypeKind;
        IDataBinding result = (IDataBinding)this.localVariables.get(simpleName);
        if (result != null && ((resultTypeKind = result.getType().getBaseType().getKind()) == 6 || resultTypeKind == 7)) {
            return result;
        }
        return this.parentScope.findIOTargetData(simpleName);
    }

    @Override
    public IFunctionBinding findFunction(String simpleName) {
        return this.parentScope.findFunction(simpleName);
    }

    @Override
    public IPackageBinding findPackage(String simpleName) {
        return this.parentScope.findPackage(simpleName);
    }

    @Override
    public ITypeBinding findType(String simpleName) {
        return this.parentScope.findType(simpleName);
    }

    @Override
    public void addLocalVariable(LocalVariableBinding var) {
        if (this.localVariables == Collections.EMPTY_MAP) {
            this.localVariables = new HashMap();
        }
        this.localVariables.put(var.getName(), var);
        this.locallyDefinedRecords = null;
        this.level2Items = null;
    }

    @Override
    public void addIOObject(IDataBinding ioObjectDataBinding) {
        if (this.ioObjects == Collections.EMPTY_SET) {
            this.ioObjects = new HashSet();
        }
        this.ioObjects.add(ioObjectDataBinding);
    }

    private List getLocallyDefinedRecords() {
        if (this.locallyDefinedRecords == null) {
            this.locallyDefinedRecords = new ArrayList();
            for (IDataBinding nextVar : this.localVariables.values()) {
                int nextVarTypeKind = nextVar.getType().getKind();
                if (nextVarTypeKind != 7 && nextVarTypeKind != 6 && (nextVarTypeKind != 2 || nextVar.getType().getBaseType().getKind() != 6)) continue;
                this.locallyDefinedRecords.add(nextVar);
            }
        }
        return this.locallyDefinedRecords;
    }

    private Map getLevel2Items() {
        if (this.level2Items == null) {
            this.level2Items = new HashMap();
            if (this.unqualifiedItemReferencesAreAllowed()) {
                for (IDataBinding nextRecVar : this.getLocallyDefinedRecords()) {
                    if (this.dataBindingsToIgnore.contains(nextRecVar)) continue;
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.level2Items, nextRecVar, nextRecVar.getType().getSimpleNamesToDataBindingsMap());
                }
            }
            for (IDataBinding nextIOObject : this.ioObjects) {
                if (this.dataBindingsToIgnore.contains(nextIOObject)) continue;
                BindingUtilities.addToUnqualifiedBindingNameMap(this.level2Items, null, nextIOObject);
                if (!this.unqualifiedItemReferencesAreAllowed()) continue;
                if (!this.getLocallyDefinedRecords().contains(nextIOObject)) {
                    Map simpleNamesToDataBindingsMap = nextIOObject.getType().getSimpleNamesToDataBindingsMap();
                    BindingUtilities.addAllToUnqualifiedBindingNameMap(this.level2Items, nextIOObject, simpleNamesToDataBindingsMap);
                }
                BindingUtilities.addResourceAssociationBindingToMap(this.level2Items, nextIOObject);
            }
        }
        return this.level2Items;
    }

    @Override
    public Scope getScopeForKeywordThis() {
        return this.parentScope.getScopeForKeywordThis();
    }

    @Override
    public boolean unqualifiedItemReferencesAreAllowed() {
        return this.parentScope.unqualifiedItemReferencesAreAllowed();
    }

    @Override
    public IPartBinding getPartBinding() {
        return this.parentScope.getPartBinding();
    }

    @Override
    public void addDeclaredDataName(String name) {
        this.declaredDataNames.add(name);
    }

    @Override
    public boolean hasDeclaredDataName(String name) {
        return this.declaredDataNames.contains(name);
    }

    @Override
    public boolean I4GLItemsNullableIsEnabled() {
        return this.parentScope.I4GLItemsNullableIsEnabled();
    }
}

