/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.edt.compiler.binding.ArrayDictionaryBinding;
import org.eclipse.edt.compiler.binding.ArrayTypeBinding;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DelegateBinding;
import org.eclipse.edt.compiler.binding.DictionaryBinding;
import org.eclipse.edt.compiler.binding.ExternalTypeBinding;
import org.eclipse.edt.compiler.binding.FixedRecordBinding;
import org.eclipse.edt.compiler.binding.FixedStructureBinding;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FormBinding;
import org.eclipse.edt.compiler.binding.FunctionParameterBinding;
import org.eclipse.edt.compiler.binding.HandlerBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IFunctionBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.InterfaceBinding;
import org.eclipse.edt.compiler.binding.NilBinding;
import org.eclipse.edt.compiler.binding.PartBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.binding.ServiceBinding;
import org.eclipse.edt.compiler.binding.annotationType.AnnotationTypeBindingImpl;
import org.eclipse.edt.compiler.core.ast.ArrayLiteral;
import org.eclipse.edt.compiler.core.ast.BinaryExpression;
import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.ParenthesizedExpression;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.IEnvironment;
import org.eclipse.edt.compiler.internal.core.lookup.System.SystemPartManager;
import org.eclipse.edt.compiler.internal.core.validation.type.PrimitiveTypeValidator;

public class TypeCompatibilityUtil {
    private static Map inferredTypeForDateTimeArithmetic = new HashMap();
    private static Set numericPrimitives;
    private static Set textPrimitives;
    private static Set dateTimePrimitives;

    static {
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.NUM, BinaryExpression.Operator.PLUS), Primitive.DATE);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.NUM, BinaryExpression.Operator.MINUS), Primitive.DATE);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.NUM, Primitive.DATE, BinaryExpression.Operator.PLUS), Primitive.DATE);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.TIMESTAMP, BinaryExpression.Operator.MINUS), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.DATE, BinaryExpression.Operator.MINUS), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.TIMESTAMP, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.TIMESTAMP, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.TIMESTAMP, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.INTERVAL, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.DATE, Primitive.INTERVAL, BinaryExpression.Operator.MINUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.DATE, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.DATE, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.DATE, BinaryExpression.Operator.PLUS), Primitive.TIMESTAMP);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.PLUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.MONTHSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.PLUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.PLUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.PLUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.MINUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.MONTHSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.MINUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.INTERVAL, BinaryExpression.Operator.MINUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.SECONDSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.MONTHSPAN_INTERVAL, BinaryExpression.Operator.MINUS), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.NUM, BinaryExpression.Operator.TIMES), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.NUM, BinaryExpression.Operator.TIMES), Primitive.MONTHSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.NUM, BinaryExpression.Operator.TIMES), Primitive.INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.SECONDSPAN_INTERVAL, Primitive.NUM, BinaryExpression.Operator.DIVIDE), Primitive.SECONDSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.MONTHSPAN_INTERVAL, Primitive.NUM, BinaryExpression.Operator.DIVIDE), Primitive.MONTHSPAN_INTERVAL);
        inferredTypeForDateTimeArithmetic.put(new DateTimeCalculation(Primitive.INTERVAL, Primitive.NUM, BinaryExpression.Operator.DIVIDE), Primitive.INTERVAL);
        numericPrimitives = new HashSet<Primitive>(Arrays.asList(Primitive.BIN, Primitive.INT, Primitive.SMALLINT, Primitive.BIGINT, Primitive.DECIMAL, Primitive.NUM, Primitive.PACF, Primitive.NUMC, Primitive.FLOAT, Primitive.SMALLFLOAT, Primitive.MONEY, Primitive.NUMBER));
        textPrimitives = new HashSet<Primitive>(Arrays.asList(Primitive.CHAR, Primitive.UNICODE, Primitive.STRING, Primitive.MBCHAR, Primitive.DBCHARLIT));
        dateTimePrimitives = new HashSet<Primitive>(Arrays.asList(Primitive.DATE, Primitive.TIME, Primitive.TIMESTAMP, Primitive.MONTHSPAN_INTERVAL, Primitive.SECONDSPAN_INTERVAL, Primitive.INTERVAL));
    }

    public static Primitive getDateTimeArithmeticResult(ITypeBinding type1, ITypeBinding type2, BinaryExpression.Operator operator) {
        DateTimeCalculation dateTimeCalculation = new DateTimeCalculation(type1, type2, operator);
        if (new DateTimeCalculation(Primitive.TIMESTAMP, Primitive.TIMESTAMP, BinaryExpression.Operator.MINUS).equals(dateTimeCalculation)) {
            if (TypeCompatibilityUtil.spansYearsOrMonths(((PrimitiveTypeBinding)type1).getTimeStampOrIntervalPattern()) && TypeCompatibilityUtil.spansYearsOrMonths(((PrimitiveTypeBinding)type2).getTimeStampOrIntervalPattern())) {
                return Primitive.MONTHSPAN_INTERVAL;
            }
            return Primitive.SECONDSPAN_INTERVAL;
        }
        return (Primitive)inferredTypeForDateTimeArithmetic.get(dateTimeCalculation);
    }

    private static boolean spansYearsOrMonths(String pattern) {
        PrimitiveTypeValidator.DateTimePattern dtPattern;
        String[] components;
        if (pattern != null && ((components = (dtPattern = new PrimitiveTypeValidator.DateTimePattern(pattern)).getComponents()).length == 1 || components.length == 2)) {
            char firstChar = components[0].charAt(0);
            return Character.toLowerCase(firstChar) == 'y' || components.length == 1 && 'M' == firstChar;
        }
        return false;
    }

    public static boolean typesOrElementTypesMoveCompatible(ITypeBinding targetType, ITypeBinding sourceType, ICompilerOptions compilerOptions) {
        if (targetType == null || sourceType == null || IBinding.NOT_FOUND_BINDING == sourceType || IBinding.NOT_FOUND_BINDING == targetType) {
            return true;
        }
        if (2 == targetType.getKind()) {
            return 2 == sourceType.getKind() && TypeCompatibilityUtil.typesOrElementTypesMoveCompatible(((ArrayTypeBinding)targetType).getElementType(), ((ArrayTypeBinding)sourceType).getElementType(), compilerOptions);
        }
        if (2 == sourceType.getKind()) {
            return false;
        }
        return TypeCompatibilityUtil.isMoveCompatible(targetType, sourceType, null, compilerOptions);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isMoveCompatible(ITypeBinding targetType, ITypeBinding sourceType, Expression sourceExpr, ICompilerOptions compilerOptions) {
        typesMatch = false;
        if (targetType == null || sourceType == null || IBinding.NOT_FOUND_BINDING == sourceType || IBinding.NOT_FOUND_BINDING == targetType) {
            return true;
        }
        if (targetType.isNullable()) {
            targetType = targetType.getNonNullableInstance();
        }
        if (sourceType.isNullable()) {
            sourceType = sourceType.getNonNullableInstance();
        }
        if (targetType == sourceType) {
            return true;
        }
        if (targetType.isDynamic()) {
            return true;
        }
        if (sourceType == NilBinding.INSTANCE) {
            return true;
        }
        if (TypeCompatibilityUtil.compatibilityAnnotationMatches(sourceType, targetType)) {
            return true;
        }
        if (!targetType.isReference() || !sourceType.isReference()) ** GOTO lbl35
        return TypeCompatibilityUtil.isReferenceCompatible(sourceType, targetType, compilerOptions);
lbl-1000:
        // 1 sources

        {
            if (2 == targetType.getKind() && 2 != sourceType.getKind() || 2 != targetType.getKind() && 2 == sourceType.getKind()) {
                return false;
            }
            targetType = ((ArrayTypeBinding)targetType).getElementType();
            sourceType = ((ArrayTypeBinding)sourceType).getElementType();
            if (targetType.isDynamic()) {
                return true;
            }
            if (sourceExpr != null) {
                arrLitExpr = new ArrayLiteral[1];
                sourceExpr.accept(new DefaultASTVisitor(){

                    @Override
                    public boolean visit(ParenthesizedExpression parenthesizedExpression) {
                        return true;
                    }

                    @Override
                    public boolean visit(ArrayLiteral arrayLiteral) {
                        arrLitExpr[0] = arrayLiteral;
                        return false;
                    }
                });
                sourceExpr = null;
                if (arrLitExpr[0] != null) {
                    entries = arrLitExpr[0].getExpressions();
                    for (Expression expr : entries) {
                        if (!Binding.isValidBinding(expr.resolveTypeBinding()) || expr.resolveTypeBinding().isDynamic() || TypeCompatibilityUtil.isMoveCompatible(targetType, expr.resolveTypeBinding(), expr, compilerOptions)) continue;
                        return false;
                    }
                }
            }
            if (!sourceType.isDynamic() && sourceType != NilBinding.INSTANCE) continue;
            return true;
lbl35:
            // 2 sources

            ** while (2 == targetType.getKind() || 2 == sourceType.getKind())
        }
lbl36:
        // 1 sources

        if (targetType == sourceType) {
            return true;
        }
        if (targetType == SystemPartManager.TYPEREF_BINDING) {
            return true;
        }
        if (sourceType instanceof AnnotationTypeBindingImpl) {
            sourceType = ((AnnotationTypeBindingImpl)sourceType).getAnnotationRecord();
        }
        if (targetType == DictionaryBinding.INSTANCE && sourceType != DictionaryBinding.INSTANCE || targetType != DictionaryBinding.INSTANCE && sourceType == DictionaryBinding.INSTANCE) {
            return false;
        }
        if (targetType == ArrayDictionaryBinding.INSTANCE && sourceType != ArrayDictionaryBinding.INSTANCE || targetType != ArrayDictionaryBinding.INSTANCE && sourceType == ArrayDictionaryBinding.INSTANCE) {
            return false;
        }
        if (19 == targetType.getKind() && sourceType.isDynamic()) {
            return true;
        }
        sourcePrimitiveType = 2 == sourceType.getKind() ? TypeCompatibilityUtil.getPrimitiveType(((ArrayTypeBinding)sourceType).getBaseType()) : TypeCompatibilityUtil.getPrimitiveType(sourceType);
        sourcePrimitive = sourcePrimitiveType == null ? null : sourcePrimitiveType.getPrimitive();
        targetPrimitiveType = 2 == targetType.getKind() ? TypeCompatibilityUtil.getPrimitiveType(((ArrayTypeBinding)targetType).getBaseType()) : TypeCompatibilityUtil.getPrimitiveType(targetType);
        v0 = targetPrimitive = targetPrimitiveType == null ? null : targetPrimitiveType.getPrimitive();
        if (sourcePrimitiveType != null && targetPrimitiveType != null) {
            typesMatch = TypeCompatibilityUtil.isMoveCompatible(targetPrimitiveType, sourcePrimitiveType);
        } else if (sourcePrimitive != null && 6 == targetType.getKind()) {
            typesMatch = sourcePrimitive == Primitive.CHAR || sourcePrimitive == Primitive.MBCHAR || sourcePrimitive == Primitive.HEX || sourcePrimitive == Primitive.DBCHARLIT || sourcePrimitive == Primitive.STRING && sourcePrimitiveType.getLength() != 0;
        } else if (targetPrimitive != null && 6 == sourceType.getKind()) {
            typesMatch = targetPrimitive == Primitive.CHAR || targetPrimitive == Primitive.MBCHAR || targetPrimitive == Primitive.HEX || targetPrimitive == Primitive.DBCHARLIT || targetPrimitive == Primitive.STRING && targetPrimitiveType.getLength() != 0;
        } else if (7 == targetType.getKind() && 7 == sourceType.getKind()) {
            typesMatch = targetType == sourceType;
        } else if (TypeCompatibilityUtil.isRecord(targetType) && TypeCompatibilityUtil.isRecord(sourceType)) {
            typesMatch = 7 != targetType.getKind() && 7 != sourceType.getKind();
        } else if (27 == targetType.getKind()) {
            typesMatch = 27 == sourceType.getKind() ? TypeCompatibilityUtil.functionSignituresAreIdentical(new DelegateSignature((DelegateBinding)targetType), new DelegateSignature((DelegateBinding)sourceType), compilerOptions) : (20 == sourceType.getKind() ? TypeCompatibilityUtil.functionSignituresAreIdentical(new DelegateSignature((DelegateBinding)targetType), new FunctionSignature((IFunctionBinding)sourceType), compilerOptions) : SystemPartManager.FUNCTIONREF_BINDING == sourceType);
        } else if (SystemPartManager.FUNCTIONREF_BINDING == targetType) {
            typesMatch = 27 == sourceType.getKind() || 20 == sourceType.getKind();
        } else if (!(14 != sourceType.getKind() && 15 != sourceType.getKind() || 15 != targetType.getKind() && 14 != targetType.getKind())) {
            implementedInterfaces = TypeCompatibilityUtil.getExtendedInterfaces(sourceType);
            iter = implementedInterfaces.iterator();
            while (iter.hasNext() && !typesMatch) {
                v1 = typesMatch = targetType == iter.next();
            }
            if (!typesMatch && 15 == sourceType.getKind()) {
                implementedInterfaces = TypeCompatibilityUtil.getExtendedInterfaces(targetType);
                iter = implementedInterfaces.iterator();
                while (iter.hasNext() && !typesMatch) {
                    v2 = typesMatch = sourceType == iter.next();
                }
            }
        } else if (28 == targetType.getKind() && 28 == sourceType.getKind()) {
            typesMatch = ((ExternalTypeBinding)sourceType).getExtendedTypes().contains(targetType) != false || ((ExternalTypeBinding)targetType).getExtendedTypes().contains(sourceType) != false;
        } else if (8 == targetType.getKind() && 8 == sourceType.getKind()) {
            typesMatch = targetType.getName() == sourceType.getName() && ((FormBinding)targetType).getEnclosingFormGroup() == ((FormBinding)sourceType).getEnclosingFormGroup();
        } else if (targetType.isReference() || sourceType.isReference()) {
            v3 = typesMatch = targetType == sourceType;
        }
        if (!(typesMatch || 14 != targetType.getKind() && 15 != targetType.getKind())) {
            typesMatch = sourceType == SystemPartManager.SERVICEREF_BINDING;
        }
        return typesMatch;
    }

    private static ITypeBinding realize(ITypeBinding binding, IEnvironment env) {
        IPartBinding part;
        if (!Binding.isValidBinding(binding)) {
            return binding;
        }
        if (binding.isValid()) {
            return binding;
        }
        if (binding.isPartBinding() && (part = (IPartBinding)binding).getEnvironment() == null) {
            part.setEnvironment(env);
        }
        return binding;
    }

    private static IEnvironment getEnvironment(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return null;
        }
        if (type.isPartBinding()) {
            return ((IPartBinding)type).getEnvironment();
        }
        return null;
    }

    private static boolean typeBindingsAreEqual(ITypeBinding type1, ITypeBinding type2) {
        if (!Binding.isValidBinding(type1) || !Binding.isValidBinding(type2)) {
            return false;
        }
        if (type1 == type2) {
            return true;
        }
        if (type1.isPartBinding() && type2.isPartBinding()) {
            return type1.getPackageName() == type2.getPackageName() && type1.getName() == type2.getName();
        }
        return false;
    }

    public static boolean compatibilityAnnotationMatches(ITypeBinding sType, ITypeBinding tType) {
        PartBinding partBinding;
        IPartBinding superType;
        if (!Binding.isValidBinding(sType) || !Binding.isValidBinding(tType)) {
            return false;
        }
        if (sType.getKind() == 2 && tType.getKind() == 2) {
            return TypeCompatibilityUtil.compatibilityAnnotationMatches(((ArrayTypeBinding)sType).getElementType(), ((ArrayTypeBinding)tType).getElementType());
        }
        IEnvironment sourceEnv = TypeCompatibilityUtil.getEnvironment(sType);
        IEnvironment targetEnv = TypeCompatibilityUtil.getEnvironment(tType);
        ITypeBinding sourceType = TypeCompatibilityUtil.realize(sType, sourceEnv);
        ITypeBinding targetType = TypeCompatibilityUtil.realize(tType, targetEnv);
        if (sourceType instanceof PartBinding && (superType = (partBinding = (PartBinding)sourceType).getDefaultSuperType()) != null && TypeCompatibilityUtil.typeBindingsAreEqual(superType, targetType)) {
            return true;
        }
        return targetType instanceof PartBinding && (superType = (partBinding = (PartBinding)targetType).getDefaultSuperType()) != null && TypeCompatibilityUtil.typeBindingsAreEqual(superType, sourceType);
    }

    private static FlexibleRecordBinding getPartTypeAnnotationRecord(ITypeBinding type) {
        if (!Binding.isValidBinding(type)) {
            return null;
        }
        if (type.isPartBinding()) {
            IPartBinding part = (IPartBinding)type;
            IPartSubTypeAnnotationTypeBinding subType = part.getSubType();
            if (subType == null) {
                return null;
            }
            return subType.getAnnotationRecord();
        }
        return null;
    }

    public static boolean areCompatibleArrayTypes(ITypeBinding targetType, ITypeBinding sourceType, ICompilerOptions compilerOptions) {
        return 2 == targetType.getKind() && 2 == sourceType.getKind() && TypeCompatibilityUtil.isMoveCompatible(((ArrayTypeBinding)targetType).getElementType(), ((ArrayTypeBinding)sourceType).getElementType(), null, compilerOptions);
    }

    private static List getExtendedInterfaces(ITypeBinding tBinding) {
        if (14 == tBinding.getKind()) {
            return ((ServiceBinding)tBinding).getImplementedInterfaces();
        }
        if (10 == tBinding.getKind()) {
            return ((HandlerBinding)tBinding).getImplementedInterfaces();
        }
        return Collections.EMPTY_LIST;
    }

    private static PrimitiveTypeBinding getPrimitiveType(ITypeBinding tBinding) {
        return 3 == tBinding.getKind() ? (PrimitiveTypeBinding)tBinding : null;
    }

    private static boolean isRecord(ITypeBinding tBinding) {
        return 7 == tBinding.getKind() || 6 == tBinding.getKind();
    }

    public static boolean isMoveCompatible(PrimitiveTypeBinding target, PrimitiveTypeBinding source) {
        boolean targetIsFloat;
        Primitive sourcePrim;
        if (target == null || source == null) {
            return false;
        }
        Primitive targetPrim = target.getPrimitive();
        if (targetPrim == (sourcePrim = source.getPrimitive())) {
            return true;
        }
        if (Primitive.ANY == targetPrim) {
            return true;
        }
        boolean targetIsNumeric = TypeCompatibilityUtil.isNumeric(targetPrim);
        boolean sourceIsNumeric = TypeCompatibilityUtil.isNumeric(sourcePrim);
        boolean sourceIsText = TypeCompatibilityUtil.isText(sourcePrim);
        boolean sourceIsDateTime = TypeCompatibilityUtil.isDateTime(sourcePrim);
        boolean sourceIsInterval = Primitive.MONTHSPAN_INTERVAL == sourcePrim || Primitive.SECONDSPAN_INTERVAL == sourcePrim || Primitive.INTERVAL == sourcePrim;
        boolean sourceIsFloat = Primitive.FLOAT == sourcePrim || Primitive.SMALLFLOAT == sourcePrim;
        boolean bl = targetIsFloat = Primitive.FLOAT == targetPrim || Primitive.SMALLFLOAT == targetPrim;
        if (Primitive.BOOLEAN == sourcePrim && Primitive.STRING == targetPrim) {
            return true;
        }
        if (Primitive.BOOLEAN == targetPrim) {
            return Primitive.ANY == sourcePrim;
        }
        if (Primitive.BOOLEAN == sourcePrim) {
            return false;
        }
        if (targetIsFloat) {
            if (Primitive.HEX == sourcePrim && (16 == source.getLength() || 8 == source.getLength())) {
                return true;
            }
            return sourceIsNumeric || sourceIsText || Primitive.BOOLEAN == sourcePrim;
        }
        if (targetIsNumeric) {
            if (target.getDecimals() == 0) {
                return sourceIsNumeric || sourceIsText || Primitive.BOOLEAN == sourcePrim || sourceIsInterval;
            }
            return sourceIsNumeric || sourceIsText || Primitive.BOOLEAN == sourcePrim;
        }
        if (Primitive.CHAR == targetPrim) {
            return sourceIsNumeric || sourceIsText || sourceIsDateTime || Primitive.HEX == sourcePrim;
        }
        if (Primitive.DBCHAR == targetPrim) {
            return Primitive.UNICODE == sourcePrim || Primitive.STRING == sourcePrim || Primitive.DBCHARLIT == sourcePrim;
        }
        if (Primitive.MBCHAR == targetPrim) {
            return sourceIsNumeric || sourceIsText || sourceIsDateTime;
        }
        if (Primitive.UNICODE == targetPrim || Primitive.STRING == targetPrim) {
            return sourceIsNumeric || sourceIsText || sourceIsDateTime || Primitive.HEX == sourcePrim || Primitive.DBCHAR == sourcePrim;
        }
        if (Primitive.HEX == targetPrim) {
            if (!(8 != target.getLength() && 16 != target.getLength() || Primitive.FLOAT != sourcePrim && Primitive.SMALLFLOAT != sourcePrim)) {
                return true;
            }
            return Primitive.CHAR == sourcePrim || Primitive.UNICODE == sourcePrim || Primitive.STRING == sourcePrim || Primitive.NUMBER == sourcePrim;
        }
        if (Primitive.DATE == targetPrim) {
            return sourceIsText || Primitive.TIMESTAMP == sourcePrim;
        }
        if (Primitive.TIME == targetPrim) {
            return sourceIsText || Primitive.TIMESTAMP == sourcePrim;
        }
        if (Primitive.MONTHSPAN_INTERVAL == targetPrim || Primitive.SECONDSPAN_INTERVAL == targetPrim) {
            return sourceIsText || sourceIsNumeric && !sourceIsFloat && source.getDecimals() == 0 || Primitive.INTERVAL == sourcePrim;
        }
        if (Primitive.INTERVAL == targetPrim) {
            return sourceIsText || sourceIsNumeric && !sourceIsFloat && source.getDecimals() == 0 || sourceIsInterval;
        }
        if (Primitive.TIMESTAMP == targetPrim) {
            return sourceIsText || Primitive.TIME == sourcePrim || Primitive.DATE == sourcePrim;
        }
        if (Primitive.BOOLEAN == targetPrim) {
            return sourceIsNumeric || Primitive.BOOLEAN == sourcePrim;
        }
        return false;
    }

    private static boolean isNumeric(Primitive prim) {
        return numericPrimitives.contains(prim);
    }

    private static boolean isText(Primitive prim) {
        return textPrimitives.contains(prim);
    }

    private static boolean isDateTime(Primitive prim) {
        return dateTimePrimitives.contains(prim);
    }

    public static boolean isReferenceCompatible(ITypeBinding sourceType, ITypeBinding targetType, ICompilerOptions compilerOptions) {
        Primitive tgtPrim;
        Primitive srcPrim;
        if (TypeCompatibilityUtil.getEquivalentType(sourceType, compilerOptions) == TypeCompatibilityUtil.getEquivalentType(targetType, compilerOptions)) {
            return true;
        }
        if (Binding.isValidBinding(sourceType) && Binding.isValidBinding(targetType) && sourceType.isReference() != targetType.isReference()) {
            return false;
        }
        if (targetType == null || sourceType == null || IBinding.NOT_FOUND_BINDING == sourceType || IBinding.NOT_FOUND_BINDING == targetType) {
            return true;
        }
        if (6 == sourceType.getKind() && 6 == targetType.getKind()) {
            return ((FixedRecordBinding)sourceType).getSizeInBytes() >= ((FixedRecordBinding)targetType).getSizeInBytes();
        }
        if (sourceType == NilBinding.INSTANCE) {
            return targetType.isReference() || targetType.isNullable();
        }
        if (3 == sourceType.getKind() && ((PrimitiveTypeBinding)sourceType).getLength() == -1) {
            return 3 == targetType.getKind() && ((PrimitiveTypeBinding)targetType).getPrimitive() == ((PrimitiveTypeBinding)sourceType).getPrimitive();
        }
        if (3 == sourceType.getKind() && 3 == targetType.getKind()) {
            srcPrim = ((PrimitiveTypeBinding)sourceType).getPrimitive();
            Primitive tgtPrim2 = ((PrimitiveTypeBinding)targetType).getPrimitive();
            if (srcPrim == Primitive.DECIMAL && tgtPrim2 == Primitive.NUMBER) {
                return true;
            }
            if (srcPrim == Primitive.NUMBER && tgtPrim2 == Primitive.DECIMAL) {
                return true;
            }
            if (srcPrim == Primitive.TIMESTAMP && tgtPrim2 == Primitive.TIMESTAMP && (sourceType.isReference() || targetType.isReference())) {
                return true;
            }
            if (srcPrim == Primitive.DECIMAL && tgtPrim2 == Primitive.DECIMAL && (sourceType.isReference() || targetType.isReference())) {
                return true;
            }
            if (srcPrim == Primitive.NUMBER && Primitive.isNumericType(tgtPrim2)) {
                return true;
            }
        }
        if (3 == sourceType.getKind() && (srcPrim = ((PrimitiveTypeBinding)sourceType).getPrimitive()) == Primitive.ANY) {
            return true;
        }
        if (3 == targetType.getKind() && (tgtPrim = ((PrimitiveTypeBinding)targetType).getPrimitive()) == Primitive.ANY) {
            return true;
        }
        if (compilerOptions.isVAGCompatible() && 3 == sourceType.getKind()) {
            PrimitiveTypeBinding primSourceType = (PrimitiveTypeBinding)sourceType;
            int sourceLength = primSourceType.getLength();
            int sourceDecimals = primSourceType.getDecimals();
            if (primSourceType.getPrimitive() == Primitive.DECIMAL && sourceLength % 2 == 0 && PrimitiveTypeBinding.getInstance(Primitive.DECIMAL, sourceLength + 1, sourceDecimals) == targetType) {
                return true;
            }
        }
        if (15 == targetType.getKind() && 15 == sourceType.getKind() && (((InterfaceBinding)sourceType).getExtendedTypes().contains(targetType) || ((InterfaceBinding)targetType).getExtendedTypes().contains(sourceType))) {
            return true;
        }
        if (!(14 != sourceType.getKind() && 15 != sourceType.getKind() || 15 != targetType.getKind() && 14 != targetType.getKind())) {
            List implementedInterfaces = TypeCompatibilityUtil.getExtendedInterfaces(sourceType);
            boolean typesMatch = false;
            Iterator iter = implementedInterfaces.iterator();
            while (iter.hasNext() && !typesMatch) {
                boolean bl = typesMatch = targetType == iter.next();
            }
            if (!typesMatch && 15 == sourceType.getKind()) {
                implementedInterfaces = TypeCompatibilityUtil.getExtendedInterfaces(targetType);
                iter = implementedInterfaces.iterator();
                while (iter.hasNext() && !typesMatch) {
                    boolean bl = typesMatch = sourceType == iter.next();
                }
            }
            if (!(typesMatch || 14 != targetType.getKind() && 15 != targetType.getKind())) {
                typesMatch = sourceType == SystemPartManager.SERVICEREF_BINDING;
            }
            return typesMatch;
        }
        if (28 == targetType.getKind() && 28 == sourceType.getKind() && (((ExternalTypeBinding)sourceType).getExtendedTypes().contains(targetType) || ((ExternalTypeBinding)targetType).getExtendedTypes().contains(sourceType))) {
            return true;
        }
        if (27 == targetType.getKind()) {
            if (27 == sourceType.getKind()) {
                return TypeCompatibilityUtil.functionSignituresAreIdentical(new DelegateSignature((DelegateBinding)targetType), new DelegateSignature((DelegateBinding)sourceType), compilerOptions);
            }
            if (20 == sourceType.getKind()) {
                return TypeCompatibilityUtil.functionSignituresAreIdentical(new DelegateSignature((DelegateBinding)targetType), new FunctionSignature((IFunctionBinding)sourceType), compilerOptions);
            }
            return SystemPartManager.FUNCTIONREF_BINDING == sourceType;
        }
        return false;
    }

    public static boolean areCompatibleExceptions(ITypeBinding sourceType, ITypeBinding targetType, ICompilerOptions compilerOptions) {
        if (AbstractBinder.typeIs(targetType, new String[]{"egl", "core"}, "AnyException")) {
            return sourceType.getAnnotation(new String[]{"egl", "core"}, "Exception") != null;
        }
        if (AbstractBinder.typeIs(sourceType, new String[]{"egl", "core"}, "AnyException")) {
            return targetType.getAnnotation(new String[]{"egl", "core"}, "Exception") != null;
        }
        return false;
    }

    private static ITypeBinding getEquivalentType(ITypeBinding tBinding, ICompilerOptions compilerOptions) {
        if (2 == tBinding.getKind()) {
            return ArrayTypeBinding.getInstance(TypeCompatibilityUtil.getEquivalentType(((ArrayTypeBinding)tBinding).getElementType(), compilerOptions));
        }
        if (tBinding.isNullable()) {
            return TypeCompatibilityUtil.getEquivalentType(tBinding.getNonNullableInstance(), compilerOptions).getNullableInstance();
        }
        if (tBinding == PrimitiveTypeBinding.getInstance(Primitive.BIN, 4)) {
            return PrimitiveTypeBinding.getInstance(Primitive.SMALLINT);
        }
        if (tBinding == PrimitiveTypeBinding.getInstance(Primitive.BIN, 9)) {
            return PrimitiveTypeBinding.getInstance(Primitive.INT);
        }
        if (tBinding == PrimitiveTypeBinding.getInstance(Primitive.BIN, 18)) {
            return PrimitiveTypeBinding.getInstance(Primitive.BIGINT);
        }
        if (3 == tBinding.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)tBinding;
            if (Primitive.MONEY == primTypeBinding.getPrimitive()) {
                if (primTypeBinding.getLength() == 0) {
                    return PrimitiveTypeBinding.getInstance(Primitive.DECIMAL, 16, 2);
                }
                return PrimitiveTypeBinding.getInstance(Primitive.DECIMAL, primTypeBinding.getLength(), primTypeBinding.getDecimals());
            }
            if (Primitive.TIMESTAMP == primTypeBinding.getPrimitive() && !primTypeBinding.isReference()) {
                return PrimitiveTypeBinding.getInstance(Primitive.TIMESTAMP, primTypeBinding.getTimeStampOrIntervalPattern().toUpperCase().toLowerCase());
            }
            if (Primitive.MONTHSPAN_INTERVAL == primTypeBinding.getPrimitive()) {
                return PrimitiveTypeBinding.getInstance(Primitive.MONTHSPAN_INTERVAL, primTypeBinding.getTimeStampOrIntervalPattern().toUpperCase().toLowerCase());
            }
            if (Primitive.SECONDSPAN_INTERVAL == primTypeBinding.getPrimitive()) {
                return PrimitiveTypeBinding.getInstance(Primitive.SECONDSPAN_INTERVAL, primTypeBinding.getTimeStampOrIntervalPattern().toUpperCase().toLowerCase());
            }
            if (compilerOptions.isVAGCompatible()) {
                int sourceLength = primTypeBinding.getLength();
                if (primTypeBinding.getPrimitive() == Primitive.DECIMAL && sourceLength % 2 == 1) {
                    return PrimitiveTypeBinding.getInstance(Primitive.DECIMAL, sourceLength - 1, primTypeBinding.getDecimals());
                }
            }
        }
        return tBinding;
    }

    public static boolean functionSignituresAreIdentical(IFunctionBinding fBinding1, IFunctionBinding fBinding2, ICompilerOptions compilerOptions) {
        return TypeCompatibilityUtil.functionSignituresAreIdentical(fBinding1, fBinding2, compilerOptions, true, true);
    }

    public static boolean functionSignituresAreIdentical(IFunctionBinding fBinding1, IFunctionBinding fBinding2, ICompilerOptions compilerOptions, boolean includeReturnTypeInSignature, boolean includeParameterModifiersInSignature) {
        if (fBinding1.getName() != fBinding2.getName()) {
            return false;
        }
        return TypeCompatibilityUtil.functionSignituresAreIdentical(new FunctionSignature(fBinding1), new FunctionSignature(fBinding2), compilerOptions, includeReturnTypeInSignature, includeParameterModifiersInSignature);
    }

    public static boolean functionSignituresAreIdentical(IFunctionSignature fSignature1, IFunctionSignature fSignature2, ICompilerOptions compilerOptions) {
        return TypeCompatibilityUtil.functionSignituresAreIdentical(fSignature1, fSignature2, compilerOptions, true, true);
    }

    public static boolean functionSignituresAreIdentical(IFunctionSignature fSignature1, IFunctionSignature fSignature2, ICompilerOptions compilerOptions, boolean includeReturnTypeInSignature, boolean includeParameterModifiersInSignature) {
        List parameters1 = fSignature1.getParameters();
        List parameters2 = fSignature2.getParameters();
        if (parameters1.size() != parameters2.size()) {
            return false;
        }
        int i = 0;
        while (i < parameters1.size()) {
            FunctionParameterBinding parm1 = (FunctionParameterBinding)parameters1.get(i);
            FunctionParameterBinding parm2 = (FunctionParameterBinding)parameters2.get(i);
            if (includeParameterModifiersInSignature) {
                if (parm1.isInput() && !parm2.isInput()) {
                    return false;
                }
                if (parm1.isOutput() && !parm2.isOutput()) {
                    return false;
                }
                if (parm1.isInputOutput() && !parm2.isInputOutput()) {
                    return false;
                }
                if (parm1.isConst() != parm2.isConst()) {
                    return false;
                }
                if (parm1.isField() != parm2.isField()) {
                    return false;
                }
            }
            if (!TypeCompatibilityUtil.typesAreIdentical(parm1.getType(), parm2.getType(), compilerOptions)) {
                return false;
            }
            ++i;
        }
        if (includeReturnTypeInSignature) {
            ITypeBinding returnType1 = fSignature1.getReturnType();
            ITypeBinding returnType2 = fSignature2.getReturnType();
            if (returnType1 == null) {
                if (returnType2 != null) {
                    return false;
                }
            } else {
                if (returnType2 == null) {
                    return false;
                }
                if (!TypeCompatibilityUtil.typesAreIdentical(returnType1, returnType2, compilerOptions)) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean areDifferentExternalTypes(ITypeBinding type1, ITypeBinding type2) {
        return type1 != type2 && type1 != null && IBinding.NOT_FOUND_BINDING != type1 && type2 != null && IBinding.NOT_FOUND_BINDING != type2 && 28 == type1.getKind() && 28 == type2.getKind();
    }

    public static boolean typesAreIdentical(ITypeBinding type1, ITypeBinding type2, ICompilerOptions compilerOptions) {
        return TypeCompatibilityUtil.getEquivalentType(type1, compilerOptions) == TypeCompatibilityUtil.getEquivalentType(type2, compilerOptions);
    }

    public static int wideningDistance(ITypeBinding sourceType, ITypeBinding targetType, ICompilerOptions compilerOptions) {
        int result = TypeCompatibilityUtil.valueWideningDistance(sourceType, targetType, compilerOptions);
        if (result == -1) {
            result = TypeCompatibilityUtil.referenceWideningDistance(sourceType, targetType, compilerOptions);
        }
        return result;
    }

    public static int valueWideningDistance(ITypeBinding sourceType, ITypeBinding targetType, ICompilerOptions compilerOptions) {
        if (targetType == null || sourceType == null || IBinding.NOT_FOUND_BINDING == sourceType || IBinding.NOT_FOUND_BINDING == targetType) {
            return -1;
        }
        if (TypeCompatibilityUtil.typesAreIdentical(sourceType = TypeCompatibilityUtil.getEquivalentType(sourceType, compilerOptions), targetType = TypeCompatibilityUtil.getEquivalentType(targetType, compilerOptions), compilerOptions)) {
            return 0;
        }
        List wideners = TypeCompatibilityUtil.getValueWideners(sourceType, compilerOptions);
        int shortestDistance = -1;
        Iterator iter = wideners.iterator();
        while (iter.hasNext() && shortestDistance != 1) {
            int newDistance = ((IWidener)iter.next()).getDistance(targetType);
            if (newDistance == -1 || shortestDistance != -1 && newDistance >= shortestDistance) continue;
            shortestDistance = newDistance;
        }
        return shortestDistance;
    }

    public static int referenceWideningDistance(ITypeBinding sourceType, ITypeBinding targetType, ICompilerOptions compilerOptions) {
        if (targetType == null || sourceType == null || IBinding.NOT_FOUND_BINDING == sourceType || IBinding.NOT_FOUND_BINDING == targetType) {
            return -1;
        }
        if (TypeCompatibilityUtil.typesAreIdentical(sourceType = TypeCompatibilityUtil.getEquivalentType(sourceType, compilerOptions), targetType = TypeCompatibilityUtil.getEquivalentType(targetType, compilerOptions), compilerOptions)) {
            return 0;
        }
        List wideners = TypeCompatibilityUtil.getReferenceWideners(sourceType, compilerOptions);
        int shortestDistance = -1;
        Iterator iter = wideners.iterator();
        while (iter.hasNext() && shortestDistance != 1) {
            int newDistance = ((IWidener)iter.next()).getDistance(targetType);
            if (newDistance == -1 || shortestDistance != -1 && newDistance >= shortestDistance) continue;
            shortestDistance = newDistance;
        }
        return shortestDistance;
    }

    private static List getValueWideners(ITypeBinding sourceType, ICompilerOptions compilerOptions) {
        int sourceFixedLength;
        ArrayList<IWidener> result = new ArrayList<IWidener>();
        result.add(new NullableTargetTypeWidener(sourceType, compilerOptions));
        if (sourceType.isNullable()) {
            result.add(new NullableSourceTypeWidener(sourceType, compilerOptions));
        }
        if (3 == sourceType.getKind()) {
            PrimitiveTypeBinding primSourceType = (PrimitiveTypeBinding)sourceType;
            Primitive prim = primSourceType.getPrimitive();
            switch (prim.getType()) {
                case 9: {
                    result.add(AnyFixedRecordTargetTypeWidener.INSTANCE);
                    result.add(new TargetInPrimitiveTypeSetTypeWidener(textPrimitives, 2));
                    if (16 == primSourceType.getLength()) {
                        result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.FLOAT, Primitive.SMALLFLOAT}));
                    } else if (8 == primSourceType.getLength()) {
                        result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.SMALLFLOAT, Primitive.FLOAT}));
                    }
                    result.add(new TargetInPrimitiveTypeSetTypeWidener(dateTimePrimitives, 3));
                    break;
                }
                case 4: {
                    if (primSourceType.getLength() != 0) {
                        result.add(AnyFixedRecordTargetTypeWidener.INSTANCE);
                    }
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.MBCHAR, Primitive.UNICODE, Primitive.STRING}, new Set[]{numericPrimitives, dateTimePrimitives}));
                    break;
                }
                case 11: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.UNICODE, Primitive.STRING}, new Set[]{numericPrimitives, dateTimePrimitives}));
                    break;
                }
                case 5: 
                case 6: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.MBCHAR, Primitive.UNICODE, Primitive.STRING}));
                    break;
                }
                case 20: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.STRING}, new Set[]{numericPrimitives, dateTimePrimitives}));
                    break;
                }
                case 19: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Set[]{numericPrimitives, dateTimePrimitives}));
                    break;
                }
                case 18: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.INT, Primitive.BIGINT, Primitive.BIN, Primitive.NUMC, Primitive.NUM, Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 10: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.BIGINT, Primitive.BIN, Primitive.NUMC, Primitive.NUM, Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 1: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.BIN, Primitive.NUMC, Primitive.NUM, Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 2: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.NUMC, Primitive.NUM, Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 15: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.NUM, Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 13: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.PACF, Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 16: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 7: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.DECIMAL, Primitive.SMALLFLOAT, Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 17: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.FLOAT, Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 8: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(new Primitive[]{Primitive.NUMBER}, new Set[]{dateTimePrimitives}));
                    break;
                }
                case 14: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(dateTimePrimitives));
                    break;
                }
                case 23: 
                case 27: {
                    result.add(new TargetInPrimitiveListOrSetTypeWidener(Primitive.TIMESTAMP));
                }
            }
        }
        if ((sourceFixedLength = TypeCompatibilityUtil.getFixedLength(sourceType)) != -1) {
            PrimitiveTypeBinding variableLengthSourceType;
            result.add(new LargerFixedLengthTargetWidener(sourceType, sourceFixedLength));
            if (sourceFixedLength != 0 && 3 == sourceType.getKind() && TypeCompatibilityUtil.getFixedLength(variableLengthSourceType = PrimitiveTypeBinding.getInstance(((PrimitiveTypeBinding)sourceType).getPrimitive())) == 0) {
                result.add(new FixedLengthToVariableLengthTargetWidener(variableLengthSourceType, compilerOptions));
            }
        }
        result.add(new DynamicTypeTargetWidener());
        return result;
    }

    private static List getReferenceWideners(ITypeBinding sourceType, ICompilerOptions compilerOptions) {
        ArrayList<IWidener> result = new ArrayList<IWidener>();
        result.add(AnyTargetTypeWidener.INSTANCE);
        if (NilBinding.INSTANCE == sourceType) {
            result.add(ReferenceTypeTargetTypeWidener.INSTANCE);
            result.add(NullableTypeTargetTypeWidener.INSTANCE);
        }
        switch (sourceType.getKind()) {
            case 28: {
                result.add(new SuperExternalTypeTargetWidener((ExternalTypeBinding)sourceType));
                break;
            }
            case 15: {
                result.add(new SuperInterfaceTargetWidener((InterfaceBinding)sourceType));
                break;
            }
            case 14: {
                result.add(new SuperServiceInterfaceTypeTargetWidener((ServiceBinding)sourceType));
                break;
            }
            case 10: {
                result.add(new SuperHandlerInterfaceTypeTargetWidener((HandlerBinding)sourceType));
                break;
            }
            case 2: {
                ArrayTypeBinding arraySourceType = (ArrayTypeBinding)sourceType;
                if (!arraySourceType.getElementType().isReference()) break;
                result.add(new ArrayOfCompatibleReferenceTypesTargetWidener(arraySourceType, compilerOptions));
            }
        }
        int sourceFixedLength = TypeCompatibilityUtil.getFixedLength(sourceType);
        if (sourceFixedLength != -2) {
            switch (sourceType.getKind()) {
                case 3: {
                    PrimitiveTypeBinding primSourceType = (PrimitiveTypeBinding)sourceType;
                    if (Primitive.CHAR == primSourceType.getPrimitive()) {
                        result.add(new SmallerFixedRecordTargetWidener(sourceFixedLength));
                    }
                    if (!TypeCompatibilityUtil.isText(primSourceType.getPrimitive()) && Primitive.DBCHAR != primSourceType.getPrimitive() && Primitive.NUM != primSourceType.getPrimitive() && Primitive.HEX != primSourceType.getPrimitive()) break;
                    result.add(new SmallerFixedPrimitiveTypeTargetWidener(sourceFixedLength, new HashSet<Primitive>(Arrays.asList(primSourceType.getPrimitive())), 1));
                    break;
                }
                case 6: {
                    result.add(new SmallerFixedRecordTargetWidener(sourceFixedLength));
                }
            }
        }
        return result;
    }

    private static int getFixedLength(ITypeBinding type) {
        if (3 == type.getKind()) {
            int result = ((PrimitiveTypeBinding)type).getLength();
            if (result == 0 && ((PrimitiveTypeBinding)type).getTimeStampOrIntervalPattern() != null) {
                result = ((PrimitiveTypeBinding)type).getTimeStampOrIntervalPattern().length();
            }
            return result;
        }
        if (6 == type.getKind()) {
            return ((FixedStructureBinding)type).getSizeInBytes();
        }
        return -2;
    }

    private static class AnyFixedRecordTargetTypeWidener
    implements IWidener {
        static AnyFixedRecordTargetTypeWidener INSTANCE = new AnyFixedRecordTargetTypeWidener();

        private AnyFixedRecordTargetTypeWidener() {
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return 6 == targetType.getKind() ? 1 : -1;
        }
    }

    private static class AnyTargetTypeWidener
    implements IWidener {
        static AnyTargetTypeWidener INSTANCE = new AnyTargetTypeWidener();

        private AnyTargetTypeWidener() {
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return PrimitiveTypeBinding.getInstance(Primitive.ANY) == targetType ? 1 : -1;
        }
    }

    private static class ArrayOfCompatibleReferenceTypesTargetWidener
    implements IWidener {
        private ArrayTypeBinding sourceType;
        private ICompilerOptions compilerOptions;

        public ArrayOfCompatibleReferenceTypesTargetWidener(ArrayTypeBinding sourceType, ICompilerOptions compilerOptions) {
            this.sourceType = sourceType;
            this.compilerOptions = compilerOptions;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            ITypeBinding elementType;
            if (2 == targetType.getKind() && (elementType = ((ArrayTypeBinding)targetType).getElementType()).isReference()) {
                return TypeCompatibilityUtil.referenceWideningDistance(this.sourceType.getElementType(), elementType, this.compilerOptions);
            }
            return -1;
        }
    }

    private static class DateTimeCalculation {
        Primitive firstPrim;
        Primitive secondPrim;
        BinaryExpression.Operator operator;

        DateTimeCalculation(ITypeBinding firstType, ITypeBinding secondType, BinaryExpression.Operator operator) {
            this.firstPrim = firstType.getKind() == 3 ? ((PrimitiveTypeBinding)firstType).getPrimitive() : null;
            this.secondPrim = secondType.getKind() == 3 ? ((PrimitiveTypeBinding)secondType).getPrimitive() : null;
            this.firstPrim = this.translatePrimitive(this.firstPrim);
            this.secondPrim = this.translatePrimitive(this.secondPrim);
            this.operator = operator;
        }

        DateTimeCalculation(Primitive firstPrim, Primitive secondPrim, BinaryExpression.Operator operator) {
            this.firstPrim = this.translatePrimitive(firstPrim);
            this.secondPrim = this.translatePrimitive(secondPrim);
            this.operator = operator;
        }

        private Primitive translatePrimitive(Primitive prim) {
            return Primitive.isNumericType(prim) || Primitive.isStringType(prim) ? Primitive.NUM : prim;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DateTimeCalculation)) {
                return false;
            }
            DateTimeCalculation other = (DateTimeCalculation)obj;
            return this.firstPrim == other.firstPrim && this.secondPrim == other.secondPrim && this.operator == other.operator;
        }

        public int hashCode() {
            int result = 17;
            if (this.firstPrim != null) {
                result = 37 * result + this.firstPrim.getType();
            }
            if (this.secondPrim != null) {
                result = 37 * result + this.secondPrim.getType();
            }
            result = 37 * result + this.operator.hashCode();
            return result;
        }
    }

    public static class DelegateSignature
    implements IFunctionSignature {
        private DelegateBinding delegateBinding;

        public DelegateSignature(DelegateBinding delegateBinding) {
            this.delegateBinding = delegateBinding;
        }

        @Override
        public ITypeBinding getReturnType() {
            return this.delegateBinding.getReturnType();
        }

        @Override
        public List getParameters() {
            return this.delegateBinding.getParemeters();
        }
    }

    private static class DynamicTypeTargetWidener
    implements IWidener {
        @Override
        public int getDistance(ITypeBinding targetType) {
            return targetType.isDynamic() ? 1000 : -1;
        }
    }

    private static class FixedLengthToVariableLengthTargetWidener
    implements IWidener {
        private ITypeBinding sourceType;
        private ICompilerOptions compilerOptions;

        public FixedLengthToVariableLengthTargetWidener(ITypeBinding sourceType, ICompilerOptions compilerOptions) {
            this.sourceType = sourceType;
            this.compilerOptions = compilerOptions;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int distance;
            int targetFixedLength = TypeCompatibilityUtil.getFixedLength(targetType);
            if (targetFixedLength == 0 && (distance = TypeCompatibilityUtil.valueWideningDistance(this.sourceType, targetType, this.compilerOptions)) != -1) {
                return 1 + distance;
            }
            return -1;
        }
    }

    public static class FunctionSignature
    implements IFunctionSignature {
        private IFunctionBinding functionBinding;

        public FunctionSignature(IFunctionBinding functionBinding) {
            this.functionBinding = functionBinding;
        }

        @Override
        public ITypeBinding getReturnType() {
            return this.functionBinding.getReturnType();
        }

        @Override
        public List getParameters() {
            return this.functionBinding.getParameters();
        }
    }

    public static interface IFunctionSignature {
        public ITypeBinding getReturnType();

        public List getParameters();
    }

    private static interface IWidener {
        public int getDistance(ITypeBinding var1);
    }

    private static class LargerFixedLengthTargetWidener
    implements IWidener {
        private ITypeBinding sourceType;
        private int sourceFixedLength;

        public LargerFixedLengthTargetWidener(ITypeBinding sourceType, int sourceFixedLength) {
            this.sourceType = sourceType;
            this.sourceFixedLength = sourceFixedLength;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int targetFixedLength = TypeCompatibilityUtil.getFixedLength(targetType);
            if (targetFixedLength != -1 && targetFixedLength > this.sourceFixedLength) {
                if (3 == this.sourceType.getKind() && 3 == targetType.getKind() && ((PrimitiveTypeBinding)targetType).getPrimitive() == ((PrimitiveTypeBinding)this.sourceType).getPrimitive()) {
                    return 1;
                }
                if (6 == this.sourceType.getKind() && 6 == targetType.getKind()) {
                    return 1;
                }
            }
            return -1;
        }
    }

    private static class NullableSourceTypeWidener
    implements IWidener {
        private ITypeBinding sourceType;
        private ICompilerOptions compilerOptions;

        public NullableSourceTypeWidener(ITypeBinding sourceType, ICompilerOptions compilerOptions) {
            this.sourceType = sourceType;
            this.compilerOptions = compilerOptions;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int baseWideningDistance;
            if (!targetType.isNullable() && (baseWideningDistance = TypeCompatibilityUtil.valueWideningDistance(this.sourceType.getNonNullableInstance(), targetType, this.compilerOptions)) != -1) {
                return 1 + baseWideningDistance;
            }
            return -1;
        }
    }

    private static class NullableTargetTypeWidener
    implements IWidener {
        private ITypeBinding sourceType;
        private ICompilerOptions compilerOptions;

        public NullableTargetTypeWidener(ITypeBinding sourceType, ICompilerOptions compilerOptions) {
            this.sourceType = sourceType;
            this.compilerOptions = compilerOptions;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int baseWideningDistance;
            if (targetType.isNullable() && (baseWideningDistance = TypeCompatibilityUtil.valueWideningDistance(this.sourceType, targetType.getNonNullableInstance(), this.compilerOptions)) != -1) {
                return 1 + baseWideningDistance;
            }
            return -1;
        }
    }

    private static class NullableTypeTargetTypeWidener
    implements IWidener {
        static NullableTypeTargetTypeWidener INSTANCE = new NullableTypeTargetTypeWidener();

        private NullableTypeTargetTypeWidener() {
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return targetType.isNullable() ? 1 : -1;
        }
    }

    private static class ReferenceTypeTargetTypeWidener
    implements IWidener {
        static ReferenceTypeTargetTypeWidener INSTANCE = new ReferenceTypeTargetTypeWidener();

        private ReferenceTypeTargetTypeWidener() {
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return targetType.isReference() ? 1 : -1;
        }
    }

    private static class SmallerFixedPrimitiveTypeTargetWidener
    implements IWidener {
        private int sourceSize;
        private Set allowedPrimitives;
        private int scoreForHit;

        public SmallerFixedPrimitiveTypeTargetWidener(int sourceSize, Set allowedPrimitives, int scoreForHit) {
            this.sourceSize = sourceSize;
            this.allowedPrimitives = allowedPrimitives;
            this.scoreForHit = scoreForHit;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            if (3 == targetType.getKind() && this.allowedPrimitives.contains(((PrimitiveTypeBinding)targetType).getPrimitive()) && (TypeCompatibilityUtil.getFixedLength(targetType) < this.sourceSize || this.sourceSize == -1)) {
                return this.scoreForHit;
            }
            return -1;
        }
    }

    private static class SmallerFixedRecordTargetWidener
    implements IWidener {
        private int sourceSize;

        public SmallerFixedRecordTargetWidener(int sourceSize) {
            this.sourceSize = sourceSize;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            if (6 == targetType.getKind() && TypeCompatibilityUtil.getFixedLength(targetType) < this.sourceSize) {
                return 1;
            }
            return -1;
        }
    }

    private static class SuperExternalTypeTargetWidener
    implements IWidener {
        private ExternalTypeBinding sourceType;

        public SuperExternalTypeTargetWidener(ExternalTypeBinding sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int indexOf = this.sourceType.getExtendedTypes().indexOf(targetType);
            return indexOf == -1 ? -1 : indexOf + 1;
        }
    }

    private static class SuperHandlerInterfaceTypeTargetWidener
    implements IWidener {
        private HandlerBinding sourceType;

        public SuperHandlerInterfaceTypeTargetWidener(HandlerBinding sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return this.sourceType.getImplementedInterfaces().contains(targetType) ? 1 : -1;
        }
    }

    private static class SuperInterfaceTargetWidener
    implements IWidener {
        private InterfaceBinding sourceType;

        public SuperInterfaceTargetWidener(InterfaceBinding sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int indexOf = this.sourceType.getExtendedTypes().indexOf(targetType);
            return indexOf == -1 ? -1 : indexOf + 1;
        }
    }

    private static class SuperServiceInterfaceTypeTargetWidener
    implements IWidener {
        private ServiceBinding sourceType;

        public SuperServiceInterfaceTypeTargetWidener(ServiceBinding sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            return this.sourceType.getImplementedInterfaces().contains(targetType) ? 1 : -1;
        }
    }

    private static class TargetInPrimitiveListOrSetTypeWidener
    implements IWidener {
        private Primitive[] allowedPrimitives;
        private Set[] allowedPrimitiveSets;

        public TargetInPrimitiveListOrSetTypeWidener(Primitive[] allowedPrimitives, Set[] allowedPrimitiveSets) {
            this.allowedPrimitives = allowedPrimitives;
            this.allowedPrimitiveSets = allowedPrimitiveSets;
        }

        public TargetInPrimitiveListOrSetTypeWidener(Primitive[] allowedPrimitives) {
            this(allowedPrimitives, new Set[0]);
        }

        public TargetInPrimitiveListOrSetTypeWidener(Primitive allowedPrimitive) {
            this(new Primitive[]{allowedPrimitive}, new Set[0]);
        }

        public TargetInPrimitiveListOrSetTypeWidener(Set[] allowedPrimitiveSets) {
            this(new Primitive[0], allowedPrimitiveSets);
        }

        public TargetInPrimitiveListOrSetTypeWidener(Set allowedPrimitiveSet) {
            this(new Primitive[0], new Set[]{allowedPrimitiveSet});
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            int distance = 2;
            if (3 == targetType.getKind()) {
                Primitive targetPrim = ((PrimitiveTypeBinding)targetType).getPrimitive();
                int i = 0;
                while (i < this.allowedPrimitives.length) {
                    if (targetPrim == this.allowedPrimitives[i]) {
                        return distance;
                    }
                    ++distance;
                    ++i;
                }
                i = 0;
                while (i < this.allowedPrimitiveSets.length) {
                    Iterator iter = this.allowedPrimitiveSets[i].iterator();
                    while (iter.hasNext()) {
                        if (targetPrim == iter.next()) {
                            return distance;
                        }
                        ++distance;
                    }
                    ++i;
                }
            }
            return -1;
        }
    }

    private static class TargetInPrimitiveTypeSetTypeWidener
    implements IWidener {
        private Set allowedPrimitives;
        private int scoreForHit;

        public TargetInPrimitiveTypeSetTypeWidener(Set allowedPrimitives) {
            this(allowedPrimitives, 1);
        }

        public TargetInPrimitiveTypeSetTypeWidener(Set allowedPrimitives, int scoreForHit) {
            this.allowedPrimitives = allowedPrimitives;
            this.scoreForHit = scoreForHit;
        }

        @Override
        public int getDistance(ITypeBinding targetType) {
            if (3 == targetType.getKind() && this.allowedPrimitives.contains(((PrimitiveTypeBinding)targetType).getPrimitive())) {
                return this.scoreForHit;
            }
            return -1;
        }
    }
}

