/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class DateFormatAnnotationValueValidator
implements IValueValidationRule {
    private static Set invalidDateFormatChars = new TreeSet();

    static {
        invalidDateFormatChars.add(new Character('Y'));
    }

    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotationBinding.getValue() != null && annotationBinding.getValue() != IBinding.NOT_FOUND_BINDING && annotationBinding.getValue() instanceof String) {
            String value = (String)annotationBinding.getValue();
            try {
                char[] dateFormatPropertyValue = value.toCharArray();
                boolean validating = true;
                TreeSet<Character> markedChars = new TreeSet<Character>();
                int i = 0;
                while (i < dateFormatPropertyValue.length) {
                    char currentChar = dateFormatPropertyValue[i];
                    if (currentChar == '\'') {
                        validating = !validating;
                    } else if (validating && invalidDateFormatChars.contains(new Character(currentChar)) && !markedChars.contains(new Character(currentChar))) {
                        markedChars.add(new Character(currentChar));
                        problemRequestor.acceptProblem(errorNode, 3171, new String[]{"dateFormat", "'" + currentChar + "'"});
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
    }
}

