/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Map;
import org.eclipse.edt.compiler.binding.FieldLenUtility;
import org.eclipse.edt.compiler.binding.FormFieldBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class FieldLenForFormFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        FormFieldBinding fieldBinding;
        IAnnotationBinding annotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"fieldLen"));
        if (annotationBinding != null && annotationBinding.getValue() != null && containerBinding != null && 7 == containerBinding.getKind() && !(fieldBinding = (FormFieldBinding)containerBinding).isConstant()) {
            try {
                int value = Integer.parseInt(annotationBinding.getValue().toString());
                if (!this.isValid(value, fieldBinding, new FieldLenUtility(fieldBinding, DefaultCompilerOptions.getInstance(), null).getDefaultFieldLen())) {
                    problemRequestor.acceptProblem(errorNode, 5342, new String[]{"fieldLen", canonicalContainerName});
                } else if (!this.isValidForNumeric(value, fieldBinding)) {
                    problemRequestor.acceptProblem(errorNode, 5349, 1, new String[]{"fieldLen", canonicalContainerName});
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private boolean isValidForNumeric(int value, FormFieldBinding formFieldBinding) {
        PrimitiveTypeBinding primTypeBinding;
        Primitive prim;
        boolean result = true;
        ITypeBinding formFieldType = formFieldBinding.getType();
        if (formFieldType != null && 3 == formFieldType.getKind() && Primitive.isNumericType(prim = (primTypeBinding = (PrimitiveTypeBinding)formFieldType).getPrimitive())) {
            result = value >= primTypeBinding.getLength();
        }
        return result;
    }

    private boolean isValid(int value, FormFieldBinding formFieldBinding, int calculatedFieldLength) {
        boolean result = true;
        ITypeBinding formFieldType = formFieldBinding.getType();
        if (formFieldType != null && 3 == formFieldType.getKind()) {
            PrimitiveTypeBinding primTypeBinding = (PrimitiveTypeBinding)formFieldType;
            Primitive prim = primTypeBinding.getPrimitive();
            IAnnotationBinding format = null;
            switch (prim.getType()) {
                case 23: {
                    IDataBinding dBinding;
                    format = formFieldBinding.getAnnotation(new String[]{"egl", "ui"}, "DateFormat");
                    IDataBinding iDataBinding = dBinding = format != null && format.getValue() instanceof IDataBinding ? (IDataBinding)format.getValue() : null;
                    if (format != null && format.getValue() != null) {
                        if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "StrLib", "DEFAULTDATEFORMAT")) {
                            result = true;
                            break;
                        }
                        result = calculatedFieldLength <= value;
                        break;
                    }
                    result = true;
                    break;
                }
                case 27: {
                    IDataBinding dBinding;
                    format = formFieldBinding.getAnnotation(new String[]{"egl", "ui"}, "TimeFormat");
                    IDataBinding iDataBinding = dBinding = format != null && format.getValue() instanceof IDataBinding ? (IDataBinding)format.getValue() : null;
                    if (format != null && format.getValue() != null) {
                        if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "StrLib", "DEFAULTTIMEFORMAT")) {
                            result = true;
                            break;
                        }
                        result = calculatedFieldLength <= value;
                        break;
                    }
                    result = true;
                    break;
                }
                case 28: {
                    IDataBinding dBinding;
                    format = formFieldBinding.getAnnotation(new String[]{"egl", "ui"}, "TimeStampFormat");
                    IDataBinding iDataBinding = dBinding = format != null && format.getValue() instanceof IDataBinding ? (IDataBinding)format.getValue() : null;
                    if (format != null && format.getValue() != null) {
                        if (AbstractBinder.dataBindingIs(dBinding, new String[]{"egl", "core"}, "StrLib", "DEFAULTTIMESTAMPFORMAT")) {
                            result = true;
                            break;
                        }
                        result = calculatedFieldLength <= value;
                        break;
                    }
                    result = true;
                    break;
                }
                case 24: 
                case 25: {
                    result = calculatedFieldLength <= value;
                    break;
                }
                case 4: 
                case 11: {
                    result = value == primTypeBinding.getLength();
                    break;
                }
                case 5: {
                    result = value == primTypeBinding.getBytes();
                    break;
                }
                default: {
                    result = value >= 0;
                }
            }
        }
        return result;
    }
}

