/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.HashSet;
import org.eclipse.edt.compiler.binding.DataBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Expression;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.annotation.TypeNameUtility;

public class LengthItemForSerialMessageOrIndexedRecordValidator
implements IValueValidationRule {
    private static final HashSet validLengthItemTypes = new HashSet();

    static {
        validLengthItemTypes.add(Primitive.BIN);
        validLengthItemTypes.add(Primitive.NUM);
        validLengthItemTypes.add(Primitive.NUMC);
        validLengthItemTypes.add(Primitive.PACF);
        validLengthItemTypes.add(Primitive.DECIMAL);
        validLengthItemTypes.add(Primitive.INT);
        validLengthItemTypes.add(Primitive.SMALLINT);
    }

    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        String canonicalRecordName = TypeNameUtility.getName(target);
        DataBinding dataBinding = null;
        if (annotationBinding.getValue() instanceof DataBinding) {
            dataBinding = (DataBinding)annotationBinding.getValue();
        } else if (annotationBinding.getValue() instanceof Expression && ((Expression)annotationBinding.getValue()).resolveDataBinding() instanceof DataBinding) {
            dataBinding = (DataBinding)((Expression)annotationBinding.getValue()).resolveDataBinding();
        }
        if (dataBinding != null) {
            if (dataBinding.getType().getKind() == 3) {
                PrimitiveTypeBinding primitiveTypeBinding = (PrimitiveTypeBinding)dataBinding.getType();
                if (!validLengthItemTypes.contains(primitiveTypeBinding.getPrimitive())) {
                    problemRequestor.acceptProblem(errorNode, 3218, new String[]{canonicalRecordName, "lengthItem", "\"" + dataBinding.getCaseSensitiveName() + "\"", canonicalRecordName, primitiveTypeBinding.getPrimitive().getName()});
                } else {
                    if (primitiveTypeBinding.getLength() > 9) {
                        problemRequestor.acceptProblem(errorNode, 3219, new String[]{canonicalRecordName, "lengthItem", "\"" + dataBinding.getCaseSensitiveName() + "\"", canonicalRecordName, Integer.toString(primitiveTypeBinding.getLength())});
                    }
                    if (primitiveTypeBinding.getDecimals() > 0) {
                        problemRequestor.acceptProblem(errorNode, 3220, new String[]{canonicalRecordName, "lengthItem", "\"" + dataBinding.getCaseSensitiveName() + "\"", canonicalRecordName});
                    }
                }
            } else {
                problemRequestor.acceptProblem(errorNode, 3223, new String[]{canonicalRecordName, "lengthItem", "\"" + dataBinding.getCaseSensitiveName() + "\"", canonicalRecordName});
            }
        }
    }
}

