/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.ValueValidationAnnotationTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class MustBeDLINameAnnotationValidator
extends ValueValidationAnnotationTypeBinding {
    public static ValueValidationAnnotationTypeBinding INSTANCE = new MustBeDLINameAnnotationValidator();

    private MustBeDLINameAnnotationValidator() {
        super(InternUtil.internCaseSensitive((String)"MustBeDLINameAnnotationValidator"));
    }

    @Override
    public void validate(final Node errorNode, Node target, IAnnotationBinding annotationBinding, final IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        final String name = annotationBinding.getValue().toString();
        MustBeDLINameAnnotationValidator.checkDLIName(name, new DLINameProblemRequestor(){

            @Override
            public void nameTooLong() {
                problemRequestor.acceptProblem(errorNode, 7851, new String[]{name});
            }

            @Override
            public void badFirstCharacter() {
                problemRequestor.acceptProblem(errorNode, 7852, new String[]{name});
            }

            @Override
            public void badCharacter() {
                problemRequestor.acceptProblem(errorNode, 7853, new String[]{name});
            }
        });
    }

    public static boolean isValidDLIName(String name) {
        final boolean[] result = new boolean[]{true};
        MustBeDLINameAnnotationValidator.checkDLIName(name, new DLINameProblemRequestor(){

            @Override
            public void nameTooLong() {
                result[0] = false;
            }

            @Override
            public void badFirstCharacter() {
                result[0] = false;
            }

            @Override
            public void badCharacter() {
                result[0] = false;
            }
        });
        return result[0];
    }

    public static void checkDLIName(String name, DLINameProblemRequestor problemRequestor) {
        if (name.length() > 8) {
            problemRequestor.nameTooLong();
        }
        if (name.length() != 0) {
            char ch = name.charAt(0);
            if (!Character.isLetter(ch) && ch != '@' && ch != '$' && ch != '#') {
                problemRequestor.badFirstCharacter();
            }
            if (name.length() != 1) {
                int i = 1;
                while (i < name.length()) {
                    ch = name.charAt(i);
                    if (!Character.isLetter(ch) && !Character.isDigit(ch) && ch != '@' && ch != '$' && ch != '#') {
                        problemRequestor.badCharacter();
                    }
                    ++i;
                }
            }
        }
    }

    public static interface DLINameProblemRequestor {
        public void nameTooLong();

        public void badFirstCharacter();

        public void badCharacter();
    }
}

