/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.edt.compiler.binding.FlexibleRecordBinding;
import org.eclipse.edt.compiler.binding.FunctionBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;

public class OnConstructionFunctionAnnotationValueValidator
implements IValueValidationRule {
    private Set validPrimitives = new HashSet<Primitive>(Arrays.asList(Primitive.BIN, Primitive.INT, Primitive.SMALLINT, Primitive.BIGINT, Primitive.BOOLEAN, Primitive.CHAR, Primitive.DATE, Primitive.DBCHAR, Primitive.DECIMAL, Primitive.FLOAT, Primitive.HEX, Primitive.INTERVAL, Primitive.MBCHAR, Primitive.MONEY, Primitive.NUM, Primitive.NUMC, Primitive.PACF, Primitive.SMALLFLOAT, Primitive.STRING, Primitive.TIME, Primitive.TIMESTAMP, Primitive.UNICODE));

    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        if (annotationBinding.getValue() != null && annotationBinding.getValue() != IBinding.NOT_FOUND_BINDING && annotationBinding.getValue() instanceof FunctionBinding) {
            IPartBinding valueDeclarer;
            FunctionBinding value = (FunctionBinding)annotationBinding.getValue();
            boolean parameterTypesValid = true;
            String invalidParameterName = null;
            ITypeBinding invalidParameterType = null;
            Iterator iter = value.getParameters().iterator();
            while (iter.hasNext() && parameterTypesValid) {
                IDataBinding parm = (IDataBinding)iter.next();
                ITypeBinding type = parm.getType();
                if (type == null || this.parameterTypeIsValid(type)) continue;
                parameterTypesValid = false;
                invalidParameterName = parm.getCaseSensitiveName();
                invalidParameterType = type;
            }
            if (!parameterTypesValid) {
                problemRequestor.acceptProblem(errorNode, 3456, new String[]{StatementValidator.getShortTypeString(invalidParameterType), invalidParameterName, value.getName()});
            }
            if ((valueDeclarer = value.getDeclarer()) != null && annotationBinding.getDeclaringPart() != valueDeclarer) {
                problemRequestor.acceptProblem(errorNode, 3461, new String[]{"onConstructionFunction", annotationBinding.getDeclaringPart().getCaseSensitiveName()});
            }
        }
    }

    private boolean parameterTypeIsValid(ITypeBinding type) {
        if (type == null || IBinding.NOT_FOUND_BINDING == type) {
            return true;
        }
        switch (type.getKind()) {
            case 2: {
                return this.parameterTypeIsValid(type.getBaseType());
            }
            case 3: {
                return this.validPrimitives.contains(((PrimitiveTypeBinding)type).getPrimitive());
            }
            case 6: {
                return true;
            }
            case 7: {
                boolean typeValid = true;
                IDataBinding[] fields = ((FlexibleRecordBinding)type).getFields();
                int i = 0;
                while (i < fields.length && typeValid) {
                    typeValid = this.parameterTypeIsValid(fields[i].getType());
                    ++i;
                }
                return typeValid;
            }
        }
        return false;
    }
}

