/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.annotation.IValueValidationRule;

public class ScreenSizesAnnotationValidator
implements IValueValidationRule {
    @Override
    public void validate(Node errorNode, Node target, IAnnotationBinding annotationBinding, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        boolean valueIsValid = true;
        Object[] value = (Object[])annotationBinding.getValue();
        int i = 0;
        while (i < value.length && valueIsValid) {
            Object[] element = (Object[])value[i];
            if (element instanceof Integer[]) {
                Integer[] intAry;
                if (element.length == 2 && (intAry = (Integer[])element)[0] < 1 && intAry[1] < 1) {
                    valueIsValid = false;
                }
            } else {
                valueIsValid = false;
            }
            ++i;
        }
        if (!valueIsValid) {
            problemRequestor.acceptProblem(errorNode, 5385, new String[]{"screenSizes", this.getCanonicalName(target)});
        }
    }

    private String getCanonicalName(Node target) {
        return this.getEnclosingPart(target).getName().getCanonicalName();
    }

    private Part getEnclosingPart(Node node) {
        if (node instanceof Part) {
            return (Part)node;
        }
        return this.getEnclosingPart(node.getParent());
    }
}

