/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.annotation;

import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.binding.Binding;
import org.eclipse.edt.compiler.binding.DataTableBinding;
import org.eclipse.edt.compiler.binding.IAnnotationBinding;
import org.eclipse.edt.compiler.binding.IDataBinding;
import org.eclipse.edt.compiler.binding.IPartSubTypeAnnotationTypeBinding;
import org.eclipse.edt.compiler.binding.ITypeBinding;
import org.eclipse.edt.compiler.binding.PrimitiveTypeBinding;
import org.eclipse.edt.compiler.core.Boolean;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Primitive;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.AbstractBinder;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.utils.TypeCompatibilityUtil;
import org.eclipse.edt.compiler.internal.core.validation.annotation.DefaultFieldContentAnnotationValidationRule;
import org.eclipse.edt.compiler.internal.core.validation.statement.StatementValidator;
import org.eclipse.edt.mof.egl.utils.InternUtil;

public class ValidatorDataTableForPageItemFieldValidator
extends DefaultFieldContentAnnotationValidationRule {
    @Override
    public void validate(Node errorNode, Node container, IDataBinding containerBinding, String canonicalContainerName, Map allAnnotations, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        ITypeBinding baseType;
        ITypeBinding containerType;
        if (allAnnotations.containsKey(InternUtil.intern((String)"validatorDataTable")) && Binding.isValidBinding(containerType = containerBinding.getType()) && 3 == (baseType = containerType.getBaseType()).getKind()) {
            Primitive basePrimitive = ((PrimitiveTypeBinding)baseType).getPrimitive();
            if (PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN) == baseType || Primitive.MONTHSPAN_INTERVAL == basePrimitive || Primitive.SECONDSPAN_INTERVAL == basePrimitive || PrimitiveTypeBinding.getInstance(Primitive.BLOB) == baseType || PrimitiveTypeBinding.getInstance(Primitive.CLOB) == baseType) {
                problemRequestor.acceptProblem(errorNode, 3462, new String[]{"validatorDataTable", containerBinding.getCaseSensitiveName(), containerType.getCaseSensitiveName(), AbstractBinder.toCommaList(new ITypeBinding[]{PrimitiveTypeBinding.getInstance(Primitive.BOOLEAN), PrimitiveTypeBinding.getInstance(Primitive.INTERVAL), PrimitiveTypeBinding.getInstance(Primitive.BLOB), PrimitiveTypeBinding.getInstance(Primitive.CLOB)})});
            } else {
                IAnnotationBinding aBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"validatorDataTable"));
                Object value = aBinding.getValue();
                if (value instanceof DataTableBinding) {
                    ITypeBinding firstColumnType;
                    Boolean typeaheadvalue;
                    IAnnotationBinding typeaheadannotationBinding;
                    DataTableBinding tblBinding = (DataTableBinding)value;
                    List structureItems = tblBinding.getStructureItems();
                    IPartSubTypeAnnotationTypeBinding subType = tblBinding.getSubType();
                    if (!AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MatchvalidTable") && (typeaheadannotationBinding = (IAnnotationBinding)allAnnotations.get(InternUtil.intern((String)"typeAhead"))) != null && typeaheadannotationBinding.getValue() != null && (typeaheadvalue = (Boolean)typeaheadannotationBinding.getValue()).booleanValue()) {
                        problemRequestor.acceptProblem(errorNode, 3272, new String[]{tblBinding.getCaseSensitiveName(), "validatorDataTable"});
                    }
                    if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MatchvalidTable") || AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "MatchInvalidTable")) {
                        ITypeBinding iTypeBinding = firstColumnType = structureItems.isEmpty() ? null : ((IDataBinding)structureItems.get(0)).getType();
                        if (firstColumnType != null && !this.typesAreCompatible(firstColumnType, baseType, compilerOptions)) {
                            problemRequestor.acceptProblem(errorNode, 7696, new String[]{tblBinding.getCaseSensitiveName(), ((IDataBinding)structureItems.get(0)).getCaseSensitiveName(), StatementValidator.getTypeString(firstColumnType), StatementValidator.getTypeString(baseType)});
                        }
                    } else if (AbstractBinder.annotationIs(subType, new String[]{"egl", "core"}, "RangeChkTable")) {
                        ITypeBinding iTypeBinding = firstColumnType = structureItems.isEmpty() ? null : ((IDataBinding)structureItems.get(0)).getType();
                        if (firstColumnType != null) {
                            if (!this.typesAreCompatible(firstColumnType, baseType, compilerOptions)) {
                                problemRequestor.acceptProblem(errorNode, 7697, new String[]{tblBinding.getCaseSensitiveName(), ((IDataBinding)structureItems.get(0)).getCaseSensitiveName(), StatementValidator.getTypeString(firstColumnType), StatementValidator.getTypeString(baseType)});
                            } else {
                                ITypeBinding secondColumnType;
                                ITypeBinding iTypeBinding2 = secondColumnType = structureItems.size() < 2 ? null : ((IDataBinding)structureItems.get(1)).getType();
                                if (secondColumnType != null && !this.typesAreCompatible(secondColumnType, baseType, compilerOptions)) {
                                    problemRequestor.acceptProblem(errorNode, 7697, new String[]{tblBinding.getCaseSensitiveName(), ((IDataBinding)structureItems.get(0)).getCaseSensitiveName(), StatementValidator.getTypeString(secondColumnType), StatementValidator.getTypeString(baseType)});
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean typesAreCompatible(ITypeBinding type1, ITypeBinding type2, ICompilerOptions compilerOptions) {
        return TypeCompatibilityUtil.isMoveCompatible(type1, type2, null, compilerOptions) || TypeCompatibilityUtil.isMoveCompatible(type2, type1, null, compilerOptions);
    }
}

