/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.compiler.internal.core.validation.name;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Stack;
import org.eclipse.edt.compiler.internal.core.builder.IProblemRequestor;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameAndSubscripts;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameLexer;
import org.eclipse.edt.compiler.internal.core.validation.name.EGLNameToken;

public class EGLNameParser {
    private Reader inputReader;
    private EGLNameLexer lexer;
    private IProblemRequestor problemRequestor;
    private EGLNameToken currentToken;
    private EGLNameAndSubscripts nameAndSubscripts;
    private Stack state = new Stack();
    private String nameState = "NAME";
    private String subScriptState = "SUBSCRIPT";
    private String subStringState = "SUBSTRING";
    private String subScriptNameState = "SubscriptName";
    private String subStringNameState = "SubstringName";
    private boolean alreadyConsumed = false;
    private boolean hadSubstringState = false;
    private String inputString = null;
    private boolean parsingFileName = false;

    public EGLNameParser(String input, boolean normalWhiteSpaceChecking, boolean filename, IProblemRequestor problemRequestor, ICompilerOptions compilerOptions) {
        this.inputString = input;
        this.problemRequestor = problemRequestor;
        this.parsingFileName = filename;
        this.inputReader = new StringReader(input);
        this.lexer = new EGLNameLexer(this.inputReader, 0, this.parsingFileName, problemRequestor, compilerOptions);
        this.currentToken = null;
        this.nameAndSubscripts = new EGLNameAndSubscripts();
        try {
            this.parseName();
        }
        catch (Exception exception) {}
    }

    private void parseName() throws IOException {
        this.currentToken = this.lexer.getNextToken(this.parsingFileName);
        this.state.push(this.nameState);
        while (this.currentToken != null) {
            this.alreadyConsumed = false;
            switch (this.currentToken.getType()) {
                case 6: {
                    EGLNameToken lastName;
                    ArrayList names;
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        names = this.nameAndSubscripts.getNames();
                        if (names.isEmpty()) {
                            this.nameAndSubscripts.addName(this.currentToken);
                            break;
                        }
                        lastName = (EGLNameToken)names.get(names.size() - 1);
                        if (lastName.getText().endsWith(",")) {
                            names.remove(lastName);
                            names.add(new EGLNameToken(lastName.getType(), String.valueOf(lastName.getText()) + this.currentToken.getText(), lastName.getOffset(), lastName.getLine(), this.currentToken.getColumn()));
                            break;
                        }
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (!((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) break;
                    this.nameAndSubscripts.addSubstring(this.currentToken);
                    break;
                }
                case 7: 
                case 9: {
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subStringState)) {
                        this.nameAndSubscripts.addSubstring(this.currentToken);
                        break;
                    }
                    if (!((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) break;
                    this.nameAndSubscripts.addSubstring(this.currentToken);
                    break;
                }
                case 10: {
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (!((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) break;
                    this.nameAndSubscripts.addSubstring(this.currentToken);
                    break;
                }
                case 8: {
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (!((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) break;
                    this.nameAndSubscripts.addSubstring(this.currentToken);
                    break;
                }
                case 0x7FFFFFFF: {
                    break;
                }
                case 1: {
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptState) || ((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState) || ((String)this.state.peek()).equalsIgnoreCase(this.subStringState) || ((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) {
                        this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + 1, 2, 3035, new String[]{this.inputString});
                    }
                    this.updateState();
                    if (this.alreadyConsumed) break;
                    this.nameAndSubscripts.newSubscript();
                    break;
                }
                case 2: {
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptState) || ((String)this.state.peek()).equalsIgnoreCase(this.subStringState)) {
                        this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + 1, 2, 5211, new String[]{this.inputString});
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + 1, 2, 5205, new String[]{this.inputString});
                    }
                    this.updateState();
                    break;
                }
                case 3: {
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (((String)this.state.peek()).equalsIgnoreCase(this.subScriptState) || ((String)this.state.peek()).equalsIgnoreCase(this.subScriptNameState)) {
                        this.nameAndSubscripts.addSubscript(this.currentToken);
                        break;
                    }
                    if (!((String)this.state.peek()).equalsIgnoreCase(this.subStringState) && !((String)this.state.peek()).equalsIgnoreCase(this.subStringNameState)) break;
                    this.nameAndSubscripts.addSubstring(this.currentToken);
                    break;
                }
                case 5: {
                    if (this.state.peek().equals(this.subScriptState) || this.state.peek().equals(this.subStringState)) {
                        this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + 1, 2, 5206, new String[]{this.inputString});
                    } else if (this.state.peek().equals(this.subStringNameState)) {
                        this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + 1, 2, 5207, new String[]{this.inputString});
                    }
                    this.updateState();
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        this.nameAndSubscripts.addName(this.currentToken);
                        break;
                    }
                    if (this.alreadyConsumed) break;
                    this.nameAndSubscripts.newSubstring();
                    this.nameAndSubscripts.copySubscriptToSubstring();
                    this.nameAndSubscripts.newSubstring();
                    break;
                }
                case 4: {
                    EGLNameToken lastName;
                    ArrayList names;
                    if (((String)this.state.peek()).equalsIgnoreCase(this.nameState)) {
                        names = this.nameAndSubscripts.getNames();
                        lastName = (EGLNameToken)names.get(names.size() - 1);
                        names.remove(lastName);
                        names.add(new EGLNameToken(lastName.getType(), String.valueOf(lastName.getText()) + ",", lastName.getOffset(), lastName.getLine(), lastName.getColumn() + 1));
                        break;
                    }
                    this.updateState();
                    this.nameAndSubscripts.newSubscript();
                    break;
                }
                case 11: {
                    this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + this.currentToken.getText().length(), 2, 5208, new String[]{this.currentToken.getText(), this.inputString});
                }
            }
            if (this.alreadyConsumed) continue;
            this.currentToken = this.lexer.getNextToken(this.parsingFileName);
        }
        if (this.state.isEmpty() || !this.state.peek().equals(this.nameState)) {
            this.problemRequestor.acceptProblem(this.inputString.lastIndexOf(91), this.inputString.lastIndexOf(91), 2, 5209, new String[]{this.inputString});
        }
    }

    private void updateState() throws IOException {
        if (this.hadSubstringState) {
            this.problemRequestor.acceptProblem(this.currentToken.getOffset(), this.currentToken.getOffset() + this.currentToken.getText().length() + 1, 2, 5210, new String[]{this.currentToken.getText(), this.inputString});
            this.consumeRest();
            return;
        }
        switch (this.currentToken.getType()) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                if (this.state.isEmpty()) {
                    this.state.push(this.nameState);
                    break;
                }
                if (this.state.peek().equals(this.subScriptState)) {
                    this.state.push(this.subScriptNameState);
                    break;
                }
                if (!this.state.peek().equals(this.subStringState)) break;
                this.state.push(this.subStringNameState);
                break;
            }
            case 8: 
            case 10: {
                if (this.state.isEmpty()) {
                    this.state.push(this.nameState);
                    break;
                }
                if (this.state.peek().equals(this.subScriptState)) {
                    this.state.push(this.subScriptNameState);
                    break;
                }
                if (!this.state.peek().equals(this.subStringState)) break;
                this.state.push(this.subStringNameState);
                break;
            }
            case 1: {
                if (this.state.isEmpty()) {
                    this.alreadyConsumed = this.consumeBadSubscript();
                    break;
                }
                if (!this.state.peek().equals(this.nameState)) {
                    this.alreadyConsumed = this.consumeBadSubscript();
                    break;
                }
                this.state.push(this.subScriptState);
                break;
            }
            case 2: {
                if (this.state.isEmpty()) break;
                if (this.state.peek().equals(this.subScriptState)) {
                    this.state.pop();
                    break;
                }
                if (this.state.peek().equals(this.subStringState)) {
                    this.state.pop();
                    break;
                }
                if (this.state.peek().equals(this.nameState)) break;
                String currentState = (String)this.state.pop();
                if (currentState.equals(this.subStringNameState)) {
                    this.hadSubstringState = true;
                }
                while (currentState.equals(this.subScriptNameState) || currentState.equals(this.subStringNameState)) {
                    currentState = (String)this.state.pop();
                }
                break;
            }
            case 5: {
                if (this.state.isEmpty()) {
                    this.state.push(this.nameState);
                    break;
                }
                if (this.state.peek().equals(this.subScriptState) || this.state.peek().equals(this.subStringState)) {
                    this.state.push(this.subStringNameState);
                    break;
                }
                if (this.state.peek().equals(this.subStringNameState)) {
                    this.consumeRest();
                    break;
                }
                if (this.state.peek().equals(this.nameState)) {
                    this.state.push(this.nameState);
                    break;
                }
                if (!this.state.peek().equals(this.subScriptNameState)) break;
                String currentState = (String)this.state.pop();
                while (currentState.equals(this.subScriptNameState)) {
                    currentState = (String)this.state.pop();
                }
                this.state.push(this.subStringState);
                this.state.push(this.subStringNameState);
                break;
            }
            default: {
                if (!this.state.isEmpty()) break;
                this.state.push(this.nameState);
            }
        }
    }

    public boolean consumeBadSubscript() throws IOException {
        int bracketCount = 1;
        this.currentToken = this.lexer.getNextToken(this.parsingFileName);
        while (this.currentToken != null && bracketCount > 0) {
            switch (this.currentToken.getType()) {
                case 1: {
                    ++bracketCount;
                }
                case 2: {
                    --bracketCount;
                }
            }
            this.currentToken = this.lexer.getNextToken(this.parsingFileName);
        }
        return true;
    }

    public void consumeRest() throws IOException {
        while (this.currentToken != null) {
            this.currentToken = this.lexer.getNextToken(this.parsingFileName);
        }
    }

    public EGLNameAndSubscripts getNamesAndSubscripts() {
        return this.nameAndSubscripts;
    }

    public ArrayList getNames() {
        return this.nameAndSubscripts.getNames();
    }

    public ArrayList getSubscripts() {
        return this.nameAndSubscripts.getSubscripts();
    }

    public ArrayList getFirstSubscript() {
        return (ArrayList)this.nameAndSubscripts.getSubscripts().get(0);
    }

    public ArrayList getSubstrings() {
        return this.nameAndSubscripts.getSubstrings();
    }

    public ArrayList getFirstSubstring() {
        return (ArrayList)this.nameAndSubscripts.getSubstrings().get(0);
    }
}

